/*
 * Decompiled with CFR 0.152.
 */
package colorpicker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.StringWriter;
import java.security.AccessControlException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.java.dev.colorchooser.ColorChooser;

public class ColorPickerFrame
extends JFrame
implements DocumentListener,
PropertyChangeListener,
ListSelectionListener {
    private static Preferences prefs;
    private static boolean cantGetPreferences;
    private final DefaultListModel lmdl = new DefaultListModel();
    boolean inColorChange = false;
    private boolean changing = false;
    private boolean fromTextChange = false;
    private Timer timer = null;
    boolean inRgbTextChange = false;
    boolean inHsbTextChange = false;
    private static final ColorIcon CI;
    private JMenuItem aboutItem;
    private JButton addToListButton;
    private JMenuItem addToListItem;
    private JLabel bglabel;
    private JMenuItem clearList;
    private ColorChooser colorChooser1;
    private JLabel colorlbl;
    private JMenuItem copyItem;
    private JMenuItem cutItem;
    private JMenu editmenu;
    private JLabel errlbl;
    private JMenuItem exitItem;
    private JLabel fglabel;
    private JMenu filemenu;
    private JMenu helpmenu;
    private JTextField hexvalue;
    private JLabel hsblbl;
    private JTextField hsbval;
    private JLabel instructions;
    private JButton jButton1;
    private JLabel jLabel1;
    private JMenuBar jMenuBar1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JList list;
    private JScrollPane listpane;
    private JMenuItem pasteItem;
    private JLabel rgblbl;
    private JTextField rgbval;
    private JMenuItem webItem;

    public ColorPickerFrame() {
        this.initComponents();
        this.hexvalue.getDocument().addDocumentListener(this);
        this.colorChooser1.addPropertyChangeListener(this);
        this.colorChooser1.setFocusable(true);
        DL dl = new DL();
        this.rgbval.getDocument().addDocumentListener(dl);
        this.hsbval.getDocument().addDocumentListener(dl);
        this.errlbl.setText("  ");
        Font f = this.bglabel.getFont();
        f = f.deriveFont(1, 15.0f);
        this.bglabel.setFont(f);
        this.fglabel.setFont(f);
        this.list.setModel(this.lmdl);
        this.list.setCellRenderer(new LRen());
        this.list.getSelectionModel().addListSelectionListener(this);
        if (!this.canShowHomeMenu()) {
            this.helpmenu.remove(this.webItem);
        }
        if (!this.restore()) {
            this.pack();
        }
    }

    static Preferences getPreferences() {
        if (prefs == null && !cantGetPreferences) {
            try {
                prefs = Preferences.userNodeForPackage(ColorPickerFrame.class);
            }
            catch (AccessControlException e) {
                cantGetPreferences = true;
            }
        }
        return prefs;
    }

    public void addNotify() {
        super.addNotify();
        this.colorChooser1.requestFocus();
    }

    public void removeNotify() {
        try {
            this.store();
        }
        finally {
            super.removeNotify();
        }
    }

    private void initComponents() {
        this.colorChooser1 = new ColorChooser();
        this.jLabel1 = new JLabel();
        this.hexvalue = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.fglabel = new JLabel();
        this.bglabel = new JLabel();
        this.errlbl = new JLabel();
        this.rgblbl = new JLabel();
        this.rgbval = new JTextField();
        this.hsbval = new JTextField();
        this.hsblbl = new JLabel();
        this.colorlbl = new JLabel();
        this.listpane = new JScrollPane();
        this.list = new JList();
        this.addToListButton = new JButton();
        this.jButton1 = new JButton();
        this.instructions = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.filemenu = new JMenu();
        this.exitItem = new JMenuItem();
        this.editmenu = new JMenu();
        this.cutItem = new JMenuItem();
        this.copyItem = new JMenuItem();
        this.pasteItem = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.addToListItem = new JMenuItem();
        this.clearList = new JMenuItem();
        this.helpmenu = new JMenu();
        this.webItem = new JMenuItem();
        this.aboutItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("Color Calculator");
        this.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent evt) {
                ColorPickerFrame.this.formComponentMoved(evt);
            }

            public void componentResized(ComponentEvent evt) {
                ColorPickerFrame.this.formComponentResized(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.colorChooser1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorPickerFrame.this.colorChooser1ActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.getContentPane().add((Component)this.colorChooser1, gridBagConstraints);
        this.jLabel1.setDisplayedMnemonic('a');
        this.jLabel1.setLabelFor(this.hexvalue);
        this.jLabel1.setText("Hex Value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.hexvalue.setColumns(6);
        this.hexvalue.setText("0000FF");
        this.hexvalue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorPickerFrame.this.performAddToList(evt);
            }
        });
        this.hexvalue.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ColorPickerFrame.this.hexvalueFocusGained(evt);
            }
        });
        this.hexvalue.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                ColorPickerFrame.this.hexvalueKeyPressed(evt);
            }

            public void keyTyped(KeyEvent evt) {
                ColorPickerFrame.this.hexvalueKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.getContentPane().add((Component)this.hexvalue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.fglabel.setBackground(new Color(255, 255, 255));
        this.fglabel.setForeground(new Color(0, 0, 255));
        this.fglabel.setHorizontalAlignment(0);
        this.fglabel.setText("As Foreground");
        this.fglabel.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.fglabel, gridBagConstraints);
        this.bglabel.setBackground(new Color(0, 0, 255));
        this.bglabel.setForeground(new Color(255, 255, 255));
        this.bglabel.setHorizontalAlignment(0);
        this.bglabel.setText("As Background");
        this.bglabel.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.bglabel, gridBagConstraints);
        this.errlbl.setForeground(new Color(255, 0, 0));
        this.errlbl.setText("error msg here");
        this.errlbl.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.getContentPane().add((Component)this.errlbl, gridBagConstraints);
        this.rgblbl.setDisplayedMnemonic('G');
        this.rgblbl.setLabelFor(this.rgbval);
        this.rgblbl.setText("RGB Value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.getContentPane().add((Component)this.rgblbl, gridBagConstraints);
        this.rgbval.setText("0, 0, 255");
        this.rgbval.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorPickerFrame.this.performAddToList(evt);
            }
        });
        this.rgbval.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ColorPickerFrame.this.rgbvalFocusGained(evt);
            }
        });
        this.rgbval.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                ColorPickerFrame.this.rgbvalKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.getContentPane().add((Component)this.rgbval, gridBagConstraints);
        this.hsbval.setText("0.6666, 1.0, 1.0");
        this.hsbval.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorPickerFrame.this.performAddToList(evt);
            }
        });
        this.hsbval.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ColorPickerFrame.this.hsbvalFocusGained(evt);
            }
        });
        this.hsbval.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                ColorPickerFrame.this.hsbvalKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 130;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.getContentPane().add((Component)this.hsbval, gridBagConstraints);
        this.hsblbl.setLabelFor(this.hsbval);
        this.hsblbl.setText("HSB Value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.getContentPane().add((Component)this.hsblbl, gridBagConstraints);
        this.colorlbl.setDisplayedMnemonic('C');
        this.colorlbl.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.colorlbl, gridBagConstraints);
        this.listpane.setVerticalScrollBarPolicy(22);
        this.list.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.list.setSelectionMode(0);
        this.listpane.setViewportView(this.list);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 60;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.listpane, gridBagConstraints);
        this.addToListButton.setMnemonic('A');
        this.addToListButton.setText("Add to List");
        this.addToListButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorPickerFrame.this.performAddToList(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.addToListButton, gridBagConstraints);
        this.jButton1.setText("Clear List");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorPickerFrame.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.getContentPane().add((Component)this.jButton1, gridBagConstraints);
        this.instructions.setText("<html>Click the color swatch or enter text to select a color.  Press combinations of ctrl, shift and alt while dragging to view different color palettes.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.instructions, gridBagConstraints);
        this.filemenu.setMnemonic('F');
        this.filemenu.setText("File");
        this.exitItem.setMnemonic('x');
        this.exitItem.setText("Exit");
        this.exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorPickerFrame.this.exitItemActionPerformed(evt);
            }
        });
        this.filemenu.add(this.exitItem);
        this.jMenuBar1.add(this.filemenu);
        this.editmenu.setMnemonic('E');
        this.editmenu.setText("Edit");
        this.cutItem.setMnemonic('u');
        this.cutItem.setText("Cut");
        this.cutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorPickerFrame.this.cutItemActionPerformed(evt);
            }
        });
        this.editmenu.add(this.cutItem);
        this.copyItem.setMnemonic('C');
        this.copyItem.setText("Copy");
        this.copyItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorPickerFrame.this.copyItemActionPerformed(evt);
            }
        });
        this.editmenu.add(this.copyItem);
        this.pasteItem.setMnemonic('P');
        this.pasteItem.setText("Paste");
        this.pasteItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorPickerFrame.this.pasteItemActionPerformed(evt);
            }
        });
        this.editmenu.add(this.pasteItem);
        this.editmenu.add(this.jSeparator2);
        this.addToListItem.setMnemonic('A');
        this.addToListItem.setText("Add to List");
        this.addToListItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorPickerFrame.this.performAddToList(evt);
            }
        });
        this.editmenu.add(this.addToListItem);
        this.clearList.setMnemonic('l');
        this.clearList.setText("Clear List");
        this.clearList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorPickerFrame.this.jButton1ActionPerformed(evt);
            }
        });
        this.editmenu.add(this.clearList);
        this.jMenuBar1.add(this.editmenu);
        this.helpmenu.setMnemonic('H');
        this.helpmenu.setText("Help");
        this.webItem.setMnemonic('W');
        this.webItem.setText("Web Site");
        this.webItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorPickerFrame.this.webItemActionPerformed(evt);
            }
        });
        this.helpmenu.add(this.webItem);
        this.aboutItem.setMnemonic('A');
        this.aboutItem.setText("About");
        this.aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorPickerFrame.this.aboutItemActionPerformed(evt);
            }
        });
        this.helpmenu.add(this.aboutItem);
        this.jMenuBar1.add(this.helpmenu);
        this.setJMenuBar(this.jMenuBar1);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.lmdl.clear();
    }

    private void performAddToList(ActionEvent evt) {
        int index = this.indexOfColorInList();
        if (index == -1) {
            this.lmdl.add(0, this.colorChooser1.getColor());
            this.list.setSelectedIndex(0);
        } else {
            this.list.setSelectedIndex(index);
        }
    }

    private void hsbvalKeyTyped(KeyEvent evt) {
        char c = evt.getKeyChar();
        if (!Character.isDigit(c) && c != ',' && c != ' ' && c != '.') {
            evt.consume();
        }
    }

    private void hsbvalFocusGained(FocusEvent evt) {
        this.hsbval.selectAll();
    }

    private void rgbvalKeyTyped(KeyEvent evt) {
        char c = evt.getKeyChar();
        if (!Character.isDigit(c) && c != ',' && c != ' ') {
            evt.consume();
        }
    }

    private void rgbvalFocusGained(FocusEvent evt) {
        this.rgbval.selectAll();
    }

    private void webItemActionPerformed(ActionEvent evt) {
        this.launchBrowser();
    }

    private void hexvalueFocusGained(FocusEvent evt) {
        this.hexvalue.selectAll();
    }

    private void hexvalueKeyTyped(KeyEvent evt) {
        char c = Character.toUpperCase(evt.getKeyChar());
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                break;
            }
            case '\t': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                evt.setKeyChar(Character.toUpperCase(c));
                break;
            }
            default: {
                evt.consume();
            }
        }
    }

    private void hexvalueKeyPressed(KeyEvent evt) {
    }

    private void formComponentMoved(ComponentEvent evt) {
        if (!this.isShowing()) {
            return;
        }
        this.queueStoreNewLocation();
    }

    private void formComponentResized(ComponentEvent evt) {
        if (!this.isShowing()) {
            return;
        }
        this.queueStoreNewLocation();
    }

    private void pasteItemActionPerformed(ActionEvent evt) {
        this.hexvalue.paste();
    }

    private void copyItemActionPerformed(ActionEvent evt) {
        if (this.hexvalue.getSelectionStart() == this.hexvalue.getSelectionEnd()) {
            this.hexvalue.selectAll();
        }
        if (!this.hexvalue.hasFocus()) {
            this.hexvalue.requestFocusInWindow();
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ColorPickerFrame.this.hexvalue.copy();
            }
        });
    }

    private void cutItemActionPerformed(ActionEvent evt) {
        if (this.hexvalue.getSelectionStart() == this.hexvalue.getSelectionEnd()) {
            this.hexvalue.selectAll();
        }
        if (!this.hexvalue.hasFocus()) {
            this.hexvalue.requestFocusInWindow();
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ColorPickerFrame.this.hexvalue.cut();
            }
        });
    }

    private void aboutItemActionPerformed(ActionEvent evt) {
        String s = "<html><center><b>Color Calculator</b> by Tim Boudreau (tboudreau@sun.com)<p> <a href=\"http://colorchooser.dev.java.net\">http://colorchooser.dev.java.net</a> for updates.";
        JLabel lbl = new JLabel(s);
        lbl.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent me) {
                JLabel lbl = (JLabel)me.getSource();
                if (lbl.contains(me.getPoint())) {
                    Container c = lbl.getTopLevelAncestor();
                    if (ColorPickerFrame.this.launchBrowser() && c instanceof Dialog) {
                        c.setVisible(false);
                        ((Dialog)c).dispose();
                    }
                }
            }
        });
        JOptionPane.showMessageDialog(this, lbl);
    }

    private boolean launchBrowser() {
        try {
            if (this.isMac()) {
                Runtime.getRuntime().exec("open http://colorchooser.dev.java.net");
                return true;
            }
            if (this.isWindows()) {
                Runtime.getRuntime().exec("cmd /c start http://colorchooser.dev.java.net");
                return true;
            }
        }
        catch (IOException ioe) {
            this.setError(ioe.getMessage());
        }
        return false;
    }

    boolean canShowHomeMenu() {
        return this.isMac();
    }

    boolean isWindows() {
        String s = System.getProperty("os.name");
        return s != null && s.toUpperCase().indexOf("WINDOWS") >= 0;
    }

    boolean isMac() {
        return System.getProperty("mrj.version") != null;
    }

    private void exitItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void colorChooser1ActionPerformed(ActionEvent evt) {
        if (this.changing) {
            return;
        }
        this.changing = true;
        this.inColorChange = true;
        try {
            Color c = this.colorChooser1.getColor();
            this.setError(this.setColor(c));
        }
        finally {
            this.inColorChange = false;
            this.changing = false;
        }
        this.queueStoreNewLocation();
    }

    public static void main(String[] args) throws Exception {
        Preferences prefs;
        if (args.length == 1 && "reset".equals(args[0]) && (prefs = ColorPickerFrame.getPreferences()) != null) {
            try {
                prefs.clear();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
        ColorPickerFrame.runIt();
    }

    static JFrame runIt() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        final ColorPickerFrame frm = new ColorPickerFrame();
        frm.setVisible(true);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                frm.setVisible(true);
            }
        });
        return frm;
    }

    private void txtChange() {
        if (this.changing) {
            return;
        }
        this.fromTextChange = true;
        try {
            this.setError(this.setColor(this.hexvalue.getText().trim()));
        }
        finally {
            this.fromTextChange = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setColor(Color c) {
        if (c == null) {
            c = Color.BLACK;
        }
        this.changing = true;
        try {
            int index;
            this.fglabel.setForeground(c);
            this.bglabel.setBackground(c);
            float[] vals = new float[3];
            Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), vals);
            if ((double)vals[2] > 0.5) {
                this.bglabel.setForeground(Color.BLACK);
            } else {
                this.bglabel.setForeground(Color.WHITE);
            }
            String r = ColorPickerFrame.pad(Integer.toString(c.getRed(), 16).toUpperCase());
            String g = ColorPickerFrame.pad(Integer.toString(c.getGreen(), 16).toUpperCase());
            String b = ColorPickerFrame.pad(Integer.toString(c.getBlue(), 16).toUpperCase());
            if (!this.inColorChange) {
                this.colorChooser1.setColor(c);
            }
            if (!this.fromTextChange) {
                this.hexvalue.setText(r + g + b);
            }
            if (!this.inRgbTextChange) {
                String rgb = "" + c.getRed() + ", " + c.getGreen() + ", " + c.getBlue();
                this.rgbval.setText(rgb);
            }
            if (!this.inHsbTextChange) {
                float[] hsb = new float[3];
                hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), hsb);
                String h = this.trim(hsb[0]);
                String s = this.trim(hsb[1]);
                String b1 = this.trim(hsb[2]);
                this.hsbval.setText(h + ", " + s + ", " + b1);
            }
            if ((index = this.indexOfColorInList()) >= 0) {
                this.list.setSelectedIndex(index);
            } else {
                this.list.clearSelection();
            }
            this.queueStoreNewLocation();
            String string = " ";
            return string;
        }
        finally {
            this.changing = false;
        }
    }

    private String trim(float f) {
        String s = Float.toString(f);
        if (s.length() > 6) {
            s = s.substring(0, 6);
        }
        return s;
    }

    static String pad(String s) {
        while (s.length() < 2) {
            s = "0" + s;
        }
        return s;
    }

    public String setColor(String s) {
        if (s.length() != 6) {
            return "Color must have 6 characters - '" + s + "' has " + s.length();
        }
        String r = s.substring(0, 2);
        String g = s.substring(2, 4);
        String b = s.substring(4);
        try {
            int rval = Integer.parseInt(r, 16);
            int gval = Integer.parseInt(g, 16);
            int bval = Integer.parseInt(b, 16);
            Color c = new Color(rval, gval, bval);
            this.setColor(c);
        }
        catch (NumberFormatException nfe) {
            return "Not legal hexadecimal: " + s;
        }
        catch (IllegalArgumentException e) {
            return e.getMessage();
        }
        return " ";
    }

    public void insertUpdate(DocumentEvent e) {
        this.txtChange();
    }

    public void removeUpdate(DocumentEvent e) {
        this.txtChange();
    }

    public void changedUpdate(DocumentEvent e) {
        this.txtChange();
    }

    private void setError(String s) {
        this.errlbl.setText(s);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.inColorChange = true;
        try {
            if ("transientColor".equals(evt.getPropertyName())) {
                this.setColor((Color)evt.getNewValue());
            } else if ("color".equals(evt.getPropertyName())) {
                this.setColor((Color)evt.getNewValue());
            }
        }
        finally {
            this.inColorChange = false;
        }
    }

    private void queueStoreNewLocation() {
        if (this.timer != null) {
            this.timer.restart();
            return;
        }
        this.timer = new Timer(1000, new AL());
        this.timer.setRepeats(false);
    }

    void store() {
        Rectangle r = this.getBounds();
        Preferences prefs = ColorPickerFrame.getPreferences();
        if (prefs == null) {
            return;
        }
        prefs.putInt("x", r.x);
        prefs.putInt("y", r.y);
        prefs.putInt("w", r.width);
        prefs.putInt("h", r.height);
        Color c = this.colorChooser1.getColor();
        prefs.putInt("r", c.getRed());
        prefs.putInt("g", c.getGreen());
        prefs.putInt("b", c.getBlue());
        StringBuffer sb = new StringBuffer();
        int max = this.lmdl.getSize();
        for (int i = 0; i < max; ++i) {
            Color color = (Color)this.lmdl.elementAt(i);
            sb.append(Integer.toString(color.getRGB()));
            if (i == max - 1) continue;
            sb.append(',');
        }
        prefs.put("colors", sb.toString());
    }

    private boolean restore() {
        String colors;
        boolean result;
        Preferences prefs = ColorPickerFrame.getPreferences();
        int x = prefs.getInt("x", -1);
        int y = prefs.getInt("y", -1);
        int w = prefs.getInt("w", -1);
        int h = prefs.getInt("h", -1);
        int r = prefs.getInt("r", -1);
        int g = prefs.getInt("g", -1);
        int b = prefs.getInt("b", -1);
        if (r != -1 && g != -1 && b != -1 && r <= 255 && g <= 255 && b <= 255) {
            Color c = new Color(r, g, b);
            this.setColor(c);
        }
        boolean bl = result = x != -1 && y != -1 && w != -1 && h != -1;
        if (result) {
            int hh;
            Rectangle rect = new Rectangle(x, y, w, h);
            int ww = this.getGraphicsConfiguration().getDevice().getDisplayMode().getWidth();
            Rectangle screen = new Rectangle(0, 0, ww, hh = this.getGraphicsConfiguration().getDevice().getDisplayMode().getHeight());
            result = screen.contains(rect);
            if (result) {
                this.setBounds(rect);
            }
        }
        if ((colors = prefs.get("colors", null)) != null) {
            String[] cc = colors.split(",");
            try {
                for (int i = 0; i < cc.length; ++i) {
                    Color color = new Color(Integer.parseInt(cc[i]));
                    this.lmdl.addElement(color);
                }
            }
            catch (Exception e) {
                System.err.println("Bad saved color list: " + colors);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rgbTextChange() {
        String s = this.rgbval.getText().trim();
        char[] c = s.toCharArray();
        StringWriter sb = new StringWriter();
        int ix = 0;
        String[] strings = new String[3];
        for (int i = 0; i < c.length; ++i) {
            boolean added = false;
            if (Character.isDigit(c[i])) {
                sb.append(c[i]);
                added = true;
            } else {
                added = false;
            }
            if (added && i != c.length - 1) continue;
            String curr = sb.toString();
            sb = new StringWriter();
            if (curr.length() <= 0) continue;
            strings[ix] = curr;
            if (++ix == 3) break;
        }
        if (ix < 3) {
            if (ix == 0) {
                this.setError("Enter a red, green and blue values for a color");
            } else {
                this.setError("Only " + ix + " out of red, green and blue provided");
            }
            return;
        }
        this.inRgbTextChange = true;
        String curr = null;
        try {
            int[] rgb = new int[3];
            for (int i = 0; i < strings.length; ++i) {
                curr = strings[i];
                rgb[i] = Integer.parseInt(curr);
                if (rgb[i] < 0) {
                    this.setError("Negative value: " + rgb[i]);
                    return;
                }
                if (rgb[i] <= 255) continue;
                this.setError("Color component value must be <= 255");
                return;
            }
            Color color = new Color(rgb[0], rgb[1], rgb[2]);
            this.setError(this.setColor(color));
        }
        catch (NumberFormatException e) {
            this.setError("Not a number: " + curr);
            return;
        }
        finally {
            this.inRgbTextChange = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hsbTextChange() {
        String s = this.hsbval.getText().trim();
        char[] c = s.toCharArray();
        StringWriter sb = new StringWriter();
        int ix = 0;
        String[] strings = new String[3];
        for (int i = 0; i < c.length; ++i) {
            boolean added = false;
            if (Character.isDigit(c[i]) || c[i] == '.') {
                sb.append(c[i]);
                added = true;
            } else {
                added = false;
            }
            if (added && i != c.length - 1) continue;
            String curr = sb.toString();
            sb = new StringWriter();
            if (curr.length() <= 0) continue;
            strings[ix] = curr;
            if (++ix == 3) break;
        }
        if (ix < 3) {
            if (ix == 0) {
                this.setError("Enter a hue, saturation and brightness for a color");
            } else {
                this.setError("Only " + ix + " out of hue, saturation and brightness provided");
            }
            return;
        }
        this.inHsbTextChange = true;
        String curr = null;
        try {
            float[] hsb = new float[3];
            for (int i = 0; i < strings.length; ++i) {
                curr = strings[i];
                hsb[i] = Float.parseFloat(curr);
                if (hsb[i] < 0.0f) {
                    this.setError("HSB values must be between 0 and 1.0" + hsb[i]);
                    return;
                }
                if (!((double)hsb[i] > 1.0)) continue;
                this.setError("HSB color component value must be <= 1.0 -- " + hsb[i]);
                return;
            }
            Color color = new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
            this.setError(this.setColor(color));
        }
        catch (NumberFormatException e) {
            this.setError("Not a number: " + curr);
            return;
        }
        catch (IllegalArgumentException ee) {
            this.setError(ee.getMessage());
            return;
        }
        finally {
            this.inHsbTextChange = false;
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        int ix = this.list.getSelectedIndex();
        if (ix != -1 && !this.changing) {
            this.setColor((Color)this.list.getSelectedValue());
        }
    }

    public int indexOfColorInList() {
        Color color = this.colorChooser1.getColor();
        int max = this.lmdl.getSize();
        for (int i = 0; i < max; ++i) {
            Color c = (Color)this.lmdl.getElementAt(i);
            if (!color.equals(c)) continue;
            return i;
        }
        return -1;
    }

    static {
        cantGetPreferences = false;
        CI = new ColorIcon();
    }

    private static class ColorIcon
    implements Icon {
        Color color = Color.BLACK;

        private ColorIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            Insets ins = ((JComponent)c).getInsets();
            int w = Math.min(this.getIconWidth(), c.getWidth() - (3 + ins.left));
            int h = Math.min(this.getIconWidth(), c.getHeight() - (3 + ins.top)) - 1;
            g.setColor(this.color);
            g.fillRect(ins.left + 1, ins.top + 1, w, h);
            g.setColor(Color.BLACK);
            g.drawRect(ins.left + 1, ins.top + 1, w, h);
        }

        public int getIconWidth() {
            return 20;
        }

        public int getIconHeight() {
            return 14;
        }
    }

    private static class LRen
    extends DefaultListCellRenderer {
        LRen() {
            this.setIcon(CI);
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        }

        public void propertyChange(String s, Object a, Object b) {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Color c;
            Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            CI.color = c = (Color)value;
            this.setIcon(CI);
            String r = ColorPickerFrame.pad(Integer.toString(c.getRed(), 16).toUpperCase());
            String g = ColorPickerFrame.pad(Integer.toString(c.getGreen(), 16).toUpperCase());
            String b = ColorPickerFrame.pad(Integer.toString(c.getBlue(), 16).toUpperCase());
            this.setIconTextGap(5);
            String nm = ColorChooser.getColorName(c);
            if (nm == null) {
                this.setText(r + g + b);
            } else {
                this.setText(nm + " - " + r + g + b);
            }
            return result;
        }

        public Dimension getPreferredSize() {
            Dimension result = super.getPreferredSize();
            result.height = Math.max(22, result.height);
            return result;
        }
    }

    private class DL
    implements DocumentListener {
        private DL() {
        }

        public void insertUpdate(DocumentEvent e) {
            if (e.getDocument() == ColorPickerFrame.this.rgbval.getDocument()) {
                ColorPickerFrame.this.rgbTextChange();
            } else {
                ColorPickerFrame.this.hsbTextChange();
            }
        }

        public void removeUpdate(DocumentEvent e) {
            if (e.getDocument() == ColorPickerFrame.this.rgbval.getDocument()) {
                ColorPickerFrame.this.rgbTextChange();
            } else {
                ColorPickerFrame.this.hsbTextChange();
            }
        }

        public void changedUpdate(DocumentEvent e) {
            if (e.getDocument() == ColorPickerFrame.this.rgbval.getDocument()) {
                ColorPickerFrame.this.rgbTextChange();
            } else {
                ColorPickerFrame.this.hsbTextChange();
            }
        }
    }

    private class AL
    implements ActionListener {
        private AL() {
        }

        public void actionPerformed(ActionEvent e) {
            ColorPickerFrame.this.timer = null;
            ColorPickerFrame.this.store();
        }
    }
}

