/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.x11;

import com.jogamp.common.util.ArrayHashMap;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.nativewindow.Capabilities;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.WindowUpdateEvent;
import jogamp.nativewindow.x11.X11Util;
import jogamp.newt.WindowImpl;
import jogamp.newt.driver.KeyTracker;
import jogamp.newt.driver.MouseTracker;

public class X11UnderlayTracker
implements WindowListener,
KeyListener,
MouseListener,
MouseTracker,
KeyTracker {
    private static final X11UnderlayTracker tracker;
    private volatile WindowImpl focusedWindow = null;
    private volatile MouseEvent lastMouse;
    private static volatile ArrayHashMap<WindowImpl, WindowImpl> underlayWindowMap;
    private static volatile ArrayHashMap<WindowImpl, WindowImpl> overlayWindowMap;
    private final Display display = NewtFactory.createDisplay(NativeWindowFactory.TYPE_X11, null, false);
    private final Screen screen = NewtFactory.createScreen(this.display, 0);

    public static X11UnderlayTracker getSingleton() {
        return tracker;
    }

    private X11UnderlayTracker() {
    }

    @Override
    public void windowResized(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (underlayWindowMap.containsKey(object)) {
            WindowImpl windowImpl = (WindowImpl)object;
            WindowImpl windowImpl2 = (WindowImpl)underlayWindowMap.get(object);
            if (windowImpl2.getSurfaceWidth() != windowImpl.getSurfaceWidth() || windowImpl2.getSurfaceHeight() != windowImpl.getSurfaceHeight()) {
                windowImpl2.setSize(windowImpl.getSurfaceWidth(), windowImpl.getSurfaceHeight());
            }
        } else if (overlayWindowMap.containsKey(object)) {
            WindowImpl windowImpl = (WindowImpl)object;
            WindowImpl windowImpl3 = (WindowImpl)overlayWindowMap.get(object);
            if (windowImpl.getSurfaceWidth() != windowImpl3.getSurfaceWidth() || windowImpl.getSurfaceHeight() != windowImpl3.getSurfaceHeight()) {
                windowImpl3.setSize(windowImpl.getSurfaceWidth(), windowImpl.getSurfaceHeight());
            }
        }
    }

    @Override
    public void windowMoved(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (underlayWindowMap.containsKey(object)) {
            WindowImpl windowImpl = (WindowImpl)object;
            WindowImpl windowImpl2 = (WindowImpl)underlayWindowMap.get(object);
            Point point = new Point();
            Point point2 = new Point();
            windowImpl2.getLocationOnScreen(point);
            windowImpl.getLocationOnScreen(point2);
            if (point.getX() != point2.getX() || point.getY() != point2.getY()) {
                windowImpl2.setPosition(point2.getX(), point2.getY());
            }
        } else if (overlayWindowMap.containsKey(object)) {
            WindowImpl windowImpl = (WindowImpl)object;
            WindowImpl windowImpl3 = (WindowImpl)overlayWindowMap.get(object);
        }
    }

    @Override
    public void windowDestroyNotify(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (underlayWindowMap.containsKey(object)) {
            WindowImpl windowImpl = (WindowImpl)object;
            WindowImpl windowImpl2 = (WindowImpl)underlayWindowMap.get(object);
            overlayWindowMap.remove((Object)windowImpl2);
            underlayWindowMap.remove((Object)windowImpl);
            if (this.focusedWindow == windowImpl2) {
                this.focusedWindow = null;
            }
            windowImpl2.destroy();
        } else if (overlayWindowMap.containsKey(object)) {
            WindowImpl windowImpl = (WindowImpl)object;
            WindowImpl windowImpl3 = (WindowImpl)overlayWindowMap.get(object);
            overlayWindowMap.remove((Object)windowImpl);
            underlayWindowMap.remove((Object)windowImpl3);
            if (this.focusedWindow == windowImpl) {
                this.focusedWindow = null;
            }
            windowImpl3.destroy();
        }
    }

    @Override
    public void windowDestroyed(WindowEvent windowEvent) {
    }

    @Override
    public void windowGainedFocus(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (object instanceof WindowImpl) {
            if (underlayWindowMap.containsKey(object)) {
                WindowImpl windowImpl;
                this.focusedWindow = windowImpl = (WindowImpl)underlayWindowMap.get(object);
            } else if (overlayWindowMap.containsKey(object)) {
                this.focusedWindow = (WindowImpl)object;
            } else {
                WindowImpl windowImpl = (WindowImpl)object;
                Capabilities capabilities = new Capabilities();
                capabilities.setBackgroundOpaque(false);
                WindowImpl windowImpl2 = WindowImpl.create(null, 0L, this.screen, capabilities);
                underlayWindowMap.put((Object)windowImpl2, (Object)windowImpl);
                overlayWindowMap.put((Object)windowImpl, (Object)windowImpl2);
                windowImpl2.setAlwaysOnTop(true);
                windowImpl2.setTitle(windowImpl.getTitle());
                if (windowImpl.isUndecorated()) {
                    windowImpl2.setUndecorated(true);
                }
                windowImpl2.addKeyListener(this);
                windowImpl2.addMouseListener(this);
                windowImpl2.addWindowListener(this);
                windowImpl2.setSize(windowImpl.getSurfaceWidth(), windowImpl.getSurfaceHeight());
                windowImpl2.setPosition(windowImpl.getX(), windowImpl.getY());
                windowImpl2.setVisible(false, true);
                this.focusedWindow = (WindowImpl)object;
            }
        }
    }

    @Override
    public void windowLostFocus(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (underlayWindowMap.containsKey(object)) {
            WindowImpl windowImpl = (WindowImpl)underlayWindowMap.get(object);
            if (this.focusedWindow == windowImpl) {
                this.focusedWindow = null;
            }
        } else if (this.focusedWindow == object) {
            this.focusedWindow = null;
        }
    }

    @Override
    public void windowRepaint(WindowUpdateEvent windowUpdateEvent) {
    }

    public static void main(String[] stringArray) throws InterruptedException {
        Capabilities capabilities = new Capabilities();
        capabilities.setBackgroundOpaque(false);
        Window window = NewtFactory.createWindow(capabilities);
        window.setUndecorated(true);
        window.addWindowListener(X11UnderlayTracker.getSingleton());
        window.setTitle("1");
        window.setVisible(true);
        window = NewtFactory.createWindow(capabilities);
        window.setUndecorated(false);
        window.addWindowListener(X11UnderlayTracker.getSingleton());
        window.setTitle("2");
        window.setVisible(true);
        Thread.sleep(25000L);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.lastMouse = mouseEvent;
        Object object = mouseEvent.getSource();
        if (underlayWindowMap.containsKey(object)) {
            WindowImpl windowImpl = (WindowImpl)underlayWindowMap.get(object);
            windowImpl.sendMouseEvent((short)200, 0, mouseEvent.getX(), mouseEvent.getY(), (short)0, 0.0f);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.lastMouse = mouseEvent;
        Object object = mouseEvent.getSource();
        if (underlayWindowMap.containsKey(object)) {
            WindowImpl windowImpl = (WindowImpl)underlayWindowMap.get(object);
            windowImpl.sendMouseEvent((short)201, 0, mouseEvent.getX(), mouseEvent.getY(), (short)0, 0.0f);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.lastMouse = mouseEvent;
        Object object = mouseEvent.getSource();
        if (underlayWindowMap.containsKey(object)) {
            WindowImpl windowImpl = (WindowImpl)underlayWindowMap.get(object);
            windowImpl.sendMouseEvent((short)202, 0, mouseEvent.getX(), mouseEvent.getY(), (short)0, 0.0f);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.lastMouse = mouseEvent;
        Object object = mouseEvent.getSource();
        if (underlayWindowMap.containsKey(object)) {
            WindowImpl windowImpl = (WindowImpl)underlayWindowMap.get(object);
            windowImpl.sendMouseEvent((short)203, 0, mouseEvent.getX(), mouseEvent.getY(), (short)0, 0.0f);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.lastMouse = mouseEvent;
        Object object = mouseEvent.getSource();
        if (underlayWindowMap.containsKey(object)) {
            WindowImpl windowImpl = (WindowImpl)underlayWindowMap.get(object);
            windowImpl.sendMouseEvent((short)204, 0, mouseEvent.getX(), mouseEvent.getY(), (short)0, 0.0f);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.lastMouse = mouseEvent;
        Object object = mouseEvent.getSource();
        if (underlayWindowMap.containsKey(object)) {
            WindowImpl windowImpl = (WindowImpl)underlayWindowMap.get(object);
            windowImpl.sendMouseEvent((short)205, 0, mouseEvent.getX(), mouseEvent.getY(), (short)0, 0.0f);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.lastMouse = mouseEvent;
        Object object = mouseEvent.getSource();
        if (underlayWindowMap.containsKey(object)) {
            WindowImpl windowImpl = (WindowImpl)underlayWindowMap.get(object);
            windowImpl.sendMouseEvent((short)206, 0, mouseEvent.getX(), mouseEvent.getY(), (short)0, 0.0f);
        }
    }

    @Override
    public void mouseWheelMoved(MouseEvent mouseEvent) {
        this.lastMouse = mouseEvent;
        Object object = mouseEvent.getSource();
        if (underlayWindowMap.containsKey(object)) {
            WindowImpl windowImpl = (WindowImpl)underlayWindowMap.get(object);
            windowImpl.sendMouseEvent((short)207, 0, mouseEvent.getX(), mouseEvent.getY(), (short)0, 0.0f);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.focusedWindow != null) {
            this.focusedWindow.sendKeyEvent(keyEvent.getEventType(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeySymbol(), keyEvent.getKeyChar());
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.focusedWindow != null) {
            this.focusedWindow.sendKeyEvent(keyEvent.getEventType(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeySymbol(), keyEvent.getKeyChar());
        }
    }

    @Override
    public int getLastY() {
        if (this.lastMouse != null) {
            return this.lastMouse.getY();
        }
        return 0;
    }

    @Override
    public int getLastX() {
        if (this.lastMouse != null) {
            return this.lastMouse.getX();
        }
        return 0;
    }

    static {
        underlayWindowMap = new ArrayHashMap(false, 16, 0.75f);
        overlayWindowMap = new ArrayHashMap(false, 16, 0.75f);
        X11Util.initSingleton();
        GraphicsConfigurationFactory.initSingleton();
        try {
            ReflectionUtil.callStaticMethod((String)"jogamp.nativewindow.x11.X11GraphicsConfigurationFactory", (String)"registerFactory", null, null, (ClassLoader)GraphicsConfigurationFactory.class.getClassLoader());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        tracker = new X11UnderlayTracker();
    }
}

