/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.netbeans.InvalidException;
import org.netbeans.LocaleVariants;
import org.netbeans.ModuleData;
import org.netbeans.Stamps;
import org.netbeans.StandardModule;
import org.netbeans.Util;

final class StandardModuleData
extends ModuleData {
    private static final Map<File, Set<File>> extensionOwners = new HashMap<File, Set<File>>();
    private final Set<File> localeVariants;
    private final Set<File> plainExtensions;
    private final Set<File> localeExtensions;

    public StandardModuleData(Manifest mf, StandardModule forModule) throws InvalidException {
        super(mf, forModule);
        Set<File> bogoOwners;
        assert (forModule instanceof StandardModule);
        File jar = forModule.getJarFile();
        assert (jar != null) : "Cannot load extensions from classpath module " + this.getCodeNameBase();
        List<File> l = LocaleVariants.findLocaleVariantsOf(jar, this.getCodeNameBase());
        this.localeVariants = !l.isEmpty() ? new HashSet<File>(l) : null;
        HashSet<File> pe = null;
        HashSet<File> le = null;
        String classPath = mf.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        if (classPath != null) {
            StringTokenizer tok = new StringTokenizer(classPath);
            while (tok.hasMoreTokens()) {
                File extfile;
                String ext = tok.nextToken().replace("%20", " ");
                if (ext.equals("${java.home}/lib/ext/jfxrt.jar")) {
                    File jre = new File(System.getProperty("java.home"));
                    File jdk8 = new File(new File(new File(jre, "lib"), "ext"), "jfxrt.jar");
                    if (jdk8.exists()) continue;
                    extfile = new File(new File(jre, "lib"), "jfxrt.jar");
                } else {
                    if (new File(ext).isAbsolute()) {
                        Util.err.log(Level.WARNING, "Class-Path value {0} from {1} is illegal according to the Java Extension Mechanism: must be relative", new Object[]{ext, jar});
                    }
                    File base = jar.getParentFile();
                    while (ext.startsWith("../")) {
                        ext = ext.substring(3);
                        base = base.getParentFile();
                    }
                    extfile = new File(base, ext.replace('/', File.separatorChar));
                }
                Set<File> owners = extensionOwners.get(extfile);
                if (owners == null) {
                    owners = new HashSet<File>(2);
                    owners.add(jar);
                    extensionOwners.put(extfile, owners);
                } else if (!owners.contains(jar)) {
                    owners.add(jar);
                    forModule.getManager().getEvents().log("extensionMultiplyLoaded", extfile, owners);
                }
                if (StandardModule.isModuleJar(extfile)) {
                    Util.err.log(Level.WARNING, "Class-Path value {0} from {1} illegally refers to another module; use OpenIDE-Module-Module-Dependencies instead", new Object[]{ext, jar});
                }
                if (pe == null) {
                    pe = new HashSet<File>();
                }
                pe.add(extfile);
                l = LocaleVariants.findLocaleVariantsOf(extfile, this.getCodeNameBase());
                if (l.isEmpty()) continue;
                if (le == null) {
                    le = new HashSet<File>();
                }
                le.addAll(l);
            }
        }
        this.localeExtensions = le;
        this.plainExtensions = pe;
        if (Util.err.isLoggable(Level.FINE)) {
            Util.err.log(Level.FINE, "localeVariants of {0}: {1}", new Object[]{jar, this.localeVariants});
            Util.err.log(Level.FINE, "plainExtensions of {0}: {1}", new Object[]{jar, this.plainExtensions});
            Util.err.log(Level.FINE, "localeExtensions of {0}: {1}", new Object[]{jar, this.localeExtensions});
        }
        if ((bogoOwners = extensionOwners.get(jar)) != null) {
            Util.err.log(Level.WARNING, "module {0} was incorrectly placed in the Class-Path of other JARs {1}; please use OpenIDE-Module-Module-Dependencies instead", new Object[]{jar, bogoOwners});
        }
    }

    public StandardModuleData(ObjectInput dis) throws IOException {
        super(dis);
        this.localeVariants = StandardModuleData.readFiles(dis);
        this.localeExtensions = StandardModuleData.readFiles(dis);
        this.plainExtensions = StandardModuleData.readFiles(dis);
    }

    @Override
    void write(ObjectOutput dos) throws IOException {
        super.write(dos);
        StandardModuleData.writeFiles(dos, this.localeVariants);
        StandardModuleData.writeFiles(dos, this.localeExtensions);
        StandardModuleData.writeFiles(dos, this.plainExtensions);
    }

    private static Set<File> readFiles(DataInput is) throws IOException {
        int size = is.readInt();
        HashSet<File> set = new HashSet<File>();
        while (size-- > 0) {
            set.add(new File(Stamps.readRelativePath(is)));
        }
        return set;
    }

    private static void writeFiles(DataOutput os, Set<File> files) throws IOException {
        if (files == null) {
            os.writeInt(0);
            return;
        }
        os.writeInt(files.size());
        for (File f : files) {
            Stamps.writeRelativePath(f.getPath(), os);
        }
    }

    final void addCp(List<File> classp) {
        if (this.localeVariants != null) {
            classp.addAll(this.localeVariants);
        }
        if (this.localeExtensions != null) {
            classp.addAll(this.localeExtensions);
        }
        if (this.plainExtensions != null) {
            classp.addAll(this.plainExtensions);
        }
    }
}

