/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractDiscreteDistribution;
import cern.jet.random.Stack;
import cern.jet.random.engine.RandomEngine;

public class EmpiricalWalker
extends AbstractDiscreteDistribution {
    protected int K;
    protected int[] A;
    protected double[] F;
    protected double[] cdf;

    public EmpiricalWalker(double[] dArray, int n, RandomEngine randomEngine) {
        this.setRandomGenerator(randomEngine);
        this.setState(dArray, n);
        this.setState2(dArray);
    }

    public double cdf(int n) {
        if (n < 0) {
            return 0.0;
        }
        if (n >= this.cdf.length - 1) {
            return 1.0;
        }
        return this.cdf[n];
    }

    public Object clone() {
        EmpiricalWalker empiricalWalker = (EmpiricalWalker)super.clone();
        if (this.cdf != null) {
            empiricalWalker.cdf = (double[])this.cdf.clone();
        }
        if (this.A != null) {
            empiricalWalker.A = (int[])this.A.clone();
        }
        if (this.F != null) {
            empiricalWalker.F = (double[])this.F.clone();
        }
        return empiricalWalker;
    }

    public int nextInt() {
        int n = 0;
        double d = this.randomGenerator.raw();
        n = (int)(d *= (double)this.K);
        d -= (double)n;
        double d2 = this.F[n];
        if (d2 == 1.0) {
            return n;
        }
        if (d < d2) {
            return n;
        }
        return this.A[n];
    }

    public double pdf(int n) {
        if (n < 0 || n >= this.cdf.length - 1) {
            return 0.0;
        }
        return this.cdf[n - 1] - this.cdf[n];
    }

    public void setState(double[] dArray, int n) {
        int n2;
        if (dArray == null || dArray.length == 0) {
            throw new IllegalArgumentException("Non-existing pdf");
        }
        int n3 = dArray.length;
        this.cdf = new double[n3 + 1];
        this.cdf[0] = 0.0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (dArray[n2] < 0.0) {
                throw new IllegalArgumentException("Negative probability");
            }
            this.cdf[n2 + 1] = this.cdf[n2] + dArray[n2];
        }
        if (this.cdf[n3] <= 0.0) {
            throw new IllegalArgumentException("At leat one probability must be > 0.0");
        }
        n2 = 0;
        while (n2 < n3 + 1) {
            int n4 = n2++;
            this.cdf[n4] = this.cdf[n4] / this.cdf[n3];
        }
    }

    public void setState2(double[] dArray) {
        int n;
        int n2;
        int n3 = dArray.length;
        double d = 0.0;
        for (n2 = 0; n2 < n3; ++n2) {
            d += dArray[n2];
        }
        this.K = n3;
        this.F = new double[n3];
        this.A = new int[n3];
        double[] dArray2 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray2[n2] = dArray[n2] / d;
        }
        double d2 = 1.0 / (double)n3;
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (dArray2[n2] < d2) {
                ++n4;
                continue;
            }
            ++n5;
        }
        Stack stack = new Stack(n5);
        Stack stack2 = new Stack(n4);
        for (n2 = 0; n2 < n3; ++n2) {
            if (dArray2[n2] < d2) {
                stack2.push(n2);
                continue;
            }
            stack.push(n2);
        }
        while (stack2.size() > 0) {
            int n6 = stack2.pop();
            if (stack.size() == 0) {
                this.A[n6] = n6;
                this.F[n6] = 1.0;
                break;
            }
            this.A[n6] = n = stack.pop();
            this.F[n6] = (double)n3 * dArray2[n6];
            double d3 = d2 - dArray2[n6];
            int n7 = n6;
            dArray2[n7] = dArray2[n7] + d3;
            int n8 = n;
            dArray2[n8] = dArray2[n8] - d3;
            if (dArray2[n] < d2) {
                stack2.push(n);
                continue;
            }
            if (dArray2[n] > d2) {
                stack.push(n);
                continue;
            }
            this.A[n] = n;
            this.F[n] = 1.0;
        }
        while (stack.size() > 0) {
            this.A[n] = n = stack.pop();
            this.F[n] = 1.0;
        }
    }

    public String toString() {
        Object var1_1 = null;
        return this.getClass().getName() + "(" + (this.cdf != null ? this.cdf.length : 0) + ")";
    }
}

