/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.type.ArtifactTypeContainer;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ArtifactDependencyResolver;
import org.gradle.api.internal.artifacts.GlobalDependencyResolutionRules;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BuildDependenciesVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DefaultResolvedArtifactsBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DependencyArtifactsVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ParallelResolveArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.transform.VariantSelector;
import org.gradle.api.internal.artifacts.type.ArtifactTypeRegistry;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.tasks.TaskDependencies;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.model.VariantMetadata;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.language.base.internal.resolve.LibraryResolveException;
import org.gradle.platform.base.internal.BinarySpecInternal;

public class DependencyResolvingClasspath
extends AbstractFileCollection {
    private final GlobalDependencyResolutionRules globalRules = GlobalDependencyResolutionRules.NO_OP;
    private final List<ResolutionAwareRepository> remoteRepositories;
    private final BinarySpecInternal binary;
    private final ArtifactDependencyResolver dependencyResolver;
    private final ResolveContext resolveContext;
    private final AttributesSchemaInternal attributesSchema;
    private final BuildOperationExecutor buildOperationExecutor;
    private final String descriptor;
    private ResolveResult resolveResult;

    public DependencyResolvingClasspath(BinarySpecInternal binarySpec, String descriptor, ArtifactDependencyResolver dependencyResolver, List<ResolutionAwareRepository> remoteRepositories, ResolveContext resolveContext, AttributesSchemaInternal attributesSchema, BuildOperationExecutor buildOperationExecutor) {
        this.binary = binarySpec;
        this.descriptor = descriptor;
        this.dependencyResolver = dependencyResolver;
        this.remoteRepositories = remoteRepositories;
        this.resolveContext = resolveContext;
        this.attributesSchema = attributesSchema;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    public String getDisplayName() {
        return "Classpath for " + this.descriptor;
    }

    public Set<File> getFiles() {
        this.ensureResolved(true);
        final LinkedHashSet<File> result = new LinkedHashSet<File>();
        ParallelResolveArtifactSet artifacts = ParallelResolveArtifactSet.wrap((ResolvedArtifactSet)this.resolveResult.artifactsResults.getArtifacts(), (BuildOperationExecutor)this.buildOperationExecutor);
        artifacts.visit(new ArtifactVisitor(){

            public void visitArtifact(AttributeContainer variant, ResolvableArtifact artifact) {
                result.add(artifact.getFile());
            }

            public void visitFailure(Throwable failure) {
                throw UncheckedException.throwAsUncheckedException((Throwable)failure);
            }

            public boolean includeFiles() {
                return true;
            }

            public boolean requireArtifactFiles() {
                return true;
            }

            public void visitFile(ComponentArtifactIdentifier artifactIdentifier, AttributeContainer variant, File file) {
                result.add(file);
            }
        });
        return result;
    }

    public TaskDependency getBuildDependencies() {
        this.ensureResolved(false);
        final ArrayList taskDependencies = new ArrayList();
        final ArrayList failures = new ArrayList();
        this.resolveResult.artifactsResults.getArtifacts().collectBuildDependencies(new BuildDependenciesVisitor(){

            public void visitDependency(Object dep) {
                taskDependencies.add(dep);
            }

            public void visitFailure(Throwable failure) {
                failures.add(failure);
            }
        });
        if (!failures.isEmpty()) {
            throw new ResolveException(this.getDisplayName(), failures);
        }
        return TaskDependencies.of(taskDependencies);
    }

    private void ensureResolved(boolean failFast) {
        if (this.resolveResult == null) {
            this.resolveResult = this.resolve();
        }
        if (failFast) {
            this.failOnUnresolvedDependency(this.resolveResult.notFound);
        }
    }

    private ResolveResult resolve() {
        ResolveResult result = new ResolveResult();
        this.dependencyResolver.resolve(this.resolveContext, this.remoteRepositories, this.globalRules, Specs.satisfyAll(), (DependencyGraphVisitor)result, (DependencyArtifactsVisitor)result, this.attributesSchema, new ArtifactTypeRegistry(){

            public ImmutableAttributes mapAttributesFor(File file) {
                return ImmutableAttributes.EMPTY;
            }

            public ImmutableAttributes mapAttributesFor(VariantMetadata variant) {
                return variant.getAttributes().asImmutable();
            }

            public ArtifactTypeContainer create() {
                throw new UnsupportedOperationException();
            }
        });
        return result;
    }

    private void failOnUnresolvedDependency(List<Throwable> notFound) {
        if (!notFound.isEmpty()) {
            throw new LibraryResolveException(String.format("Could not resolve all dependencies for '%s' %s", this.binary.getDisplayName(), this.descriptor), notFound);
        }
    }

    class ResolveResult
    implements DependencyGraphVisitor,
    DependencyArtifactsVisitor {
        public final List<Throwable> notFound = new LinkedList<Throwable>();
        public DefaultResolvedArtifactsBuilder artifactsBuilder = new DefaultResolvedArtifactsBuilder(true, ResolutionStrategy.SortOrder.DEFAULT);
        public SelectedArtifactResults artifactsResults;

        ResolveResult() {
        }

        public void start(DependencyGraphNode root) {
        }

        public void visitNode(DependencyGraphNode node) {
            for (DependencyGraphEdge dependency : node.getOutgoingEdges()) {
                ModuleVersionResolveException failure = dependency.getFailure();
                if (failure == null) continue;
                this.notFound.add((Throwable)failure);
            }
            this.artifactsBuilder.visitNode(node);
        }

        public void visitSelector(DependencyGraphSelector selector) {
        }

        public void visitEdges(DependencyGraphNode node) {
        }

        public void finish(DependencyGraphNode root) {
        }

        public void startArtifacts(DependencyGraphNode root) {
        }

        public void visitArtifacts(DependencyGraphNode from, LocalFileDependencyMetadata fileDependency, int artifactSetId, ArtifactSet artifactSet) {
            this.artifactsBuilder.visitArtifacts(from, fileDependency, artifactSetId, artifactSet);
        }

        public void visitArtifacts(DependencyGraphNode from, DependencyGraphNode to, int artifactSetId, ArtifactSet artifacts) {
            this.artifactsBuilder.visitArtifacts(from, to, artifactSetId, artifacts);
        }

        public void finishArtifacts() {
            this.artifactsResults = this.artifactsBuilder.complete().select(Specs.satisfyAll(), new VariantSelector(){

                public ResolvedArtifactSet select(ResolvedVariantSet variants) {
                    return ((ResolvedVariant)variants.getVariants().iterator().next()).getArtifacts();
                }
            });
        }
    }
}

