/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental.sourceparser;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.api.specs.Spec;
import org.gradle.language.nativeplatform.internal.Include;
import org.gradle.language.nativeplatform.internal.IncludeDirectives;
import org.gradle.language.nativeplatform.internal.IncludeType;
import org.gradle.language.nativeplatform.internal.Macro;
import org.gradle.language.nativeplatform.internal.MacroFunction;
import org.gradle.util.CollectionUtils;

public class DefaultIncludeDirectives
implements IncludeDirectives {
    private final ImmutableList<Include> allIncludes;
    private final ImmutableList<Macro> macros;
    private final ImmutableList<MacroFunction> macroFunctions;

    public DefaultIncludeDirectives(ImmutableList<Include> allIncludes, ImmutableList<Macro> macros, ImmutableList<MacroFunction> macroFunctions) {
        this.allIncludes = allIncludes;
        this.macros = macros;
        this.macroFunctions = macroFunctions;
    }

    public List<Include> getQuotedIncludes() {
        return CollectionUtils.filter(this.allIncludes, (Spec)new Spec<Include>(){

            public boolean isSatisfiedBy(Include element) {
                return element.getType() == IncludeType.QUOTED;
            }
        });
    }

    public List<Include> getSystemIncludes() {
        return CollectionUtils.filter(this.allIncludes, (Spec)new Spec<Include>(){

            public boolean isSatisfiedBy(Include element) {
                return element.getType() == IncludeType.SYSTEM;
            }
        });
    }

    public List<Include> getMacroIncludes() {
        return CollectionUtils.filter(this.allIncludes, (Spec)new Spec<Include>(){

            public boolean isSatisfiedBy(Include element) {
                return element.getType() == IncludeType.MACRO;
            }
        });
    }

    public List<Include> getAll() {
        return this.allIncludes;
    }

    public List<Include> getIncludesOnly() {
        return CollectionUtils.filter(this.allIncludes, (Spec)new Spec<Include>(){

            public boolean isSatisfiedBy(Include element) {
                return !element.isImport();
            }
        });
    }

    public List<Macro> getMacros() {
        return this.macros;
    }

    public List<MacroFunction> getMacrosFunctions() {
        return this.macroFunctions;
    }

    public IncludeDirectives discardImports() {
        return new DefaultIncludeDirectives((ImmutableList<Include>)ImmutableList.copyOf(this.getIncludesOnly()), this.macros, this.macroFunctions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultIncludeDirectives that = (DefaultIncludeDirectives)o;
        return this.allIncludes.equals(that.allIncludes) && this.macros.equals(that.macros) && this.macroFunctions.equals(that.macroFunctions);
    }

    public int hashCode() {
        return this.allIncludes.hashCode() ^ this.macros.hashCode() ^ this.macroFunctions.hashCode();
    }
}

