/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.coerce;

import org.codehaus.groovy.reflection.CachedClass;
import org.gradle.api.internal.coerce.MethodArgumentsTransformer;
import org.gradle.api.internal.coerce.PropertySetTransformer;
import org.gradle.internal.typeconversion.EnumFromCharSequenceNotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringToEnumTransformer
implements MethodArgumentsTransformer,
PropertySetTransformer {
    public static final StringToEnumTransformer INSTANCE = new StringToEnumTransformer();

    @Override
    public Object[] transform(CachedClass[] types, Object[] args) {
        boolean needsTransform = false;
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            Class type = types[i].getTheClass();
            if (type.isInstance(arg) || arg == null) continue;
            if (!(arg instanceof CharSequence) || !type.isEnum()) {
                return args;
            }
            needsTransform = true;
        }
        if (!needsTransform) {
            return args;
        }
        Object[] transformed = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            Class type = types[i].getTheClass();
            transformed[i] = type.isEnum() && arg instanceof CharSequence ? StringToEnumTransformer.toEnumValue(type, (CharSequence)arg) : args[i];
        }
        return transformed;
    }

    @Override
    public boolean canTransform(Object[] args) {
        for (Object arg : args) {
            if (!(arg instanceof CharSequence)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object transformValue(Class<?> type, Object value) {
        if (value instanceof CharSequence && type.isEnum()) {
            Class<?> enumType = type;
            return StringToEnumTransformer.toEnumValue(enumType, (CharSequence)value);
        }
        return value;
    }

    public static <T extends Enum<T>> T toEnumValue(Class<T> enumType, CharSequence charSequence) {
        return (T)((Enum)NotationParserBuilder.toType(enumType).noImplicitConverters().fromCharSequence(new EnumFromCharSequenceNotationParser<T>(enumType)).toComposite().parseNotation((Object)charSequence));
    }
}

