/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.Closeable;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.GeneratedGradleJarCache;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGeneratedGradleJarCache
implements GeneratedGradleJarCache,
Closeable {
    private final PersistentCache cache;
    private final String gradleVersion;

    public DefaultGeneratedGradleJarCache(CacheRepository cacheRepository, String gradleVersion) {
        this.cache = cacheRepository.cache("generated-gradle-jars").withDisplayName("Generated Gradle JARs cache").withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.None)).open();
        this.gradleVersion = gradleVersion;
    }

    public File get(String identifier, final Action<File> creator) {
        final File jarFile = this.jarFile(identifier);
        if (!jarFile.exists()) {
            this.cache.useCache(new Runnable(){

                public void run() {
                    if (!jarFile.exists()) {
                        creator.execute((Object)jarFile);
                    }
                }
            });
        }
        return jarFile;
    }

    @Override
    public void close() {
        this.cache.close();
    }

    private File jarFile(String identifier) {
        return new File(this.cache.getBaseDir(), "gradle-" + identifier + "-" + this.gradleVersion + ".jar");
    }
}

