/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.file.BasicFileResolver;
import org.gradle.internal.buildoption.BooleanBuildOption;
import org.gradle.internal.buildoption.BooleanCommandLineOptionConfiguration;
import org.gradle.internal.buildoption.BuildOption;
import org.gradle.internal.buildoption.CommandLineOptionConfiguration;
import org.gradle.internal.buildoption.EnabledOnlyBooleanBuildOption;
import org.gradle.internal.buildoption.ListBuildOption;
import org.gradle.internal.buildoption.Origin;
import org.gradle.internal.buildoption.StringBuildOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartParameterBuildOptions {
    private static List<BuildOption<StartParameterInternal>> options;

    public static List<BuildOption<StartParameterInternal>> get() {
        return options;
    }

    private StartParameterBuildOptions() {
    }

    static {
        ArrayList<Object> options = new ArrayList<Object>();
        options.add((Object)new ProjectCacheDirOption());
        options.add((Object)new RerunTasksOption());
        options.add((Object)new RecompileScriptsOption());
        options.add((Object)new ProfileOption());
        options.add((Object)new ContinueOption());
        options.add((Object)new OfflineOption());
        options.add((Object)new RefreshDependenciesOption());
        options.add((Object)new DryRunOption());
        options.add((Object)new ContinuousOption());
        options.add((Object)new NoProjectDependenciesRebuildOption());
        options.add((Object)new BuildFileOption());
        options.add((Object)new SettingsFileOption());
        options.add((Object)new InitScriptOption());
        options.add((Object)new ExcludeTaskOption());
        options.add((Object)new IncludeBuildOption());
        options.add((Object)new ConfigureOnDemandOption());
        options.add((Object)new BuildCacheOption());
        options.add((Object)new BuildScanOption());
        StartParameterBuildOptions.options = Collections.unmodifiableList(options);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BuildScanOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String LONG_OPTION = "scan";

        public BuildScanOption() {
            super(null, new BooleanCommandLineOptionConfiguration[]{BooleanCommandLineOptionConfiguration.create((String)LONG_OPTION, (String)"Creates a build scan. Gradle will emit a warning if the build scan plugin has not been applied. (https://gradle.com/build-scans)", (String)"Disables the creation of a build scan. For more information about build scans, please visit https://gradle.com/build-scans.").incubating()});
        }

        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            if (value) {
                settings.setBuildScan(true);
            } else {
                settings.setNoBuildScan(true);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BuildCacheOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String GRADLE_PROPERTY = "org.gradle.caching";

        public BuildCacheOption() {
            super(GRADLE_PROPERTY, new BooleanCommandLineOptionConfiguration[]{BooleanCommandLineOptionConfiguration.create((String)"build-cache", (String)"Enables the Gradle build cache. Gradle will try to reuse outputs from previous builds.", (String)"Disables the Gradle build cache.").incubating()});
        }

        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            settings.setBuildCacheEnabled(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfigureOnDemandOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String GRADLE_PROPERTY = "org.gradle.configureondemand";

        public ConfigureOnDemandOption() {
            super(GRADLE_PROPERTY, new BooleanCommandLineOptionConfiguration[]{BooleanCommandLineOptionConfiguration.create((String)"configure-on-demand", (String)"Configure necessary projects only. Gradle will attempt to reduce configuration time for large multi-project builds.", (String)"Disables the use of configuration on demand.").incubating()});
        }

        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            settings.setConfigureOnDemand(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IncludeBuildOption
    extends ListBuildOption<StartParameterInternal> {
        public IncludeBuildOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"include-build", (String)"Include the specified build in the composite.").incubating()});
        }

        public void applyTo(List<String> values, StartParameterInternal settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            for (String includedBuild : values) {
                settings.includeBuild((File)resolver.transform(includedBuild));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExcludeTaskOption
    extends ListBuildOption<StartParameterInternal> {
        public ExcludeTaskOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"exclude-task", (String)"x", (String)"Specify a task to be excluded from execution.")});
        }

        public void applyTo(List<String> values, StartParameterInternal settings, Origin origin) {
            settings.setExcludedTaskNames(values);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InitScriptOption
    extends ListBuildOption<StartParameterInternal> {
        public InitScriptOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"init-script", (String)"I", (String)"Specify an initialization script.")});
        }

        public void applyTo(List<String> values, StartParameterInternal settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            for (String script : values) {
                settings.addInitScript((File)resolver.transform(script));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SettingsFileOption
    extends StringBuildOption<StartParameterInternal> {
        public SettingsFileOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"settings-file", (String)"c", (String)"Specify the settings file.")});
        }

        public void applyTo(String value, StartParameterInternal settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            settings.setSettingsFile((File)resolver.transform(value));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BuildFileOption
    extends StringBuildOption<StartParameterInternal> {
        public BuildFileOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"build-file", (String)"b", (String)"Specify the build file.")});
        }

        public void applyTo(String value, StartParameterInternal settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            settings.setBuildFile((File)resolver.transform(value));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NoProjectDependenciesRebuildOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        private static final String LONG_OPTION = "no-rebuild";
        private static final String SHORT_OPTION = "a";

        public NoProjectDependenciesRebuildOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)LONG_OPTION, (String)SHORT_OPTION, (String)"Do not rebuild project dependencies.").deprecated()});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setBuildProjectDependencies(false);
            settings.addDeprecation(String.format("--%s/-%s", LONG_OPTION, SHORT_OPTION));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContinuousOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public ContinuousOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"continuous", (String)"t", (String)"Enables continuous build. Gradle does not exit and will re-execute tasks when task file inputs change.").incubating()});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setContinuous(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DryRunOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public DryRunOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"dry-run", (String)"m", (String)"Run the builds with all task actions disabled.")});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setDryRun(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RefreshDependenciesOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public RefreshDependenciesOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"refresh-dependencies", (String)"Refresh the state of dependencies.")});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setRefreshDependencies(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OfflineOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public OfflineOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"offline", (String)"Execute the build without accessing network resources.")});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setOffline(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContinueOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public ContinueOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"continue", (String)"Continue task execution after a task failure.")});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setContinueOnFailure(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProfileOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public ProfileOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"profile", (String)"Profile build execution time and generates a report in the <build_dir>/reports/profile directory.")});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setProfile(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RecompileScriptsOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        private static final String LONG_OPTION = "recompile-scripts";

        public RecompileScriptsOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)LONG_OPTION, (String)"Force build script recompiling.").deprecated()});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setRecompileScripts(true);
            settings.addDeprecation("--recompile-scripts");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RerunTasksOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public RerunTasksOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"rerun-tasks", (String)"Ignore previously cached task results.")});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setRerunTasks(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProjectCacheDirOption
    extends StringBuildOption<StartParameterInternal> {
        public ProjectCacheDirOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"project-cache-dir", (String)"Specify the project-specific cache directory. Defaults to .gradle in the root project directory.")});
        }

        public void applyTo(String value, StartParameterInternal settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            settings.setProjectCacheDir((File)resolver.transform(value));
        }
    }
}

