/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.Callable;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.intrinsics.JavaClassProperty;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class CallReceiver
extends StackValue {
    private final StackValue dispatchReceiver;
    private final StackValue extensionReceiver;
    private final Type secondReceiverType;

    private CallReceiver(@NotNull StackValue dispatchReceiver, @NotNull StackValue extensionReceiver, @NotNull Type type2, @Nullable Type secondReceiverType) {
        if (dispatchReceiver == null) {
            CallReceiver.$$$reportNull$$$0(0);
        }
        if (extensionReceiver == null) {
            CallReceiver.$$$reportNull$$$0(1);
        }
        if (type2 == null) {
            CallReceiver.$$$reportNull$$$0(2);
        }
        super(type2, dispatchReceiver.canHaveSideEffects() || extensionReceiver.canHaveSideEffects());
        this.dispatchReceiver = dispatchReceiver;
        this.extensionReceiver = extensionReceiver;
        this.secondReceiverType = secondReceiverType;
    }

    public StackValue withoutReceiverArgument() {
        return new CallReceiver(this.dispatchReceiver, CallReceiver.none(), this.type, this.secondReceiverType);
    }

    public static StackValue generateCallReceiver(@NotNull ResolvedCall<?> resolvedCall2, @NotNull ExpressionCodegen codegen, @Nullable Callable callableMethod, @Nullable ReceiverParameterDescriptor dispatchReceiverParameter, @NotNull StackValue dispatchReceiver, @Nullable ReceiverParameterDescriptor extensionReceiverParameter, @NotNull StackValue extensionReceiver) {
        Type type2;
        if (resolvedCall2 == null) {
            CallReceiver.$$$reportNull$$$0(3);
        }
        if (codegen == null) {
            CallReceiver.$$$reportNull$$$0(4);
        }
        if (dispatchReceiver == null) {
            CallReceiver.$$$reportNull$$$0(5);
        }
        if (extensionReceiver == null) {
            CallReceiver.$$$reportNull$$$0(6);
        }
        KotlinTypeMapper typeMapper = codegen.typeMapper;
        GenerationState state2 = codegen.getState();
        Type secondReceiverType = null;
        if (extensionReceiverParameter != null) {
            type2 = CallReceiver.calcExtensionReceiverType(resolvedCall2, extensionReceiverParameter, typeMapper, callableMethod, state2);
            if (dispatchReceiverParameter != null) {
                secondReceiverType = CallReceiver.calcDispatchReceiverType(resolvedCall2, dispatchReceiverParameter, typeMapper, callableMethod);
            }
        } else {
            type2 = dispatchReceiverParameter != null ? CallReceiver.calcDispatchReceiverType(resolvedCall2, dispatchReceiverParameter, typeMapper, callableMethod) : (CallReceiver.isLocalFunCall(callableMethod) ? callableMethod.getGenerateCalleeType() : Type.VOID_TYPE);
        }
        assert (type2 != null) : "Could not map receiver type for " + resolvedCall2;
        return new CallReceiver(dispatchReceiver, extensionReceiver, type2, secondReceiverType);
    }

    private static Type calcDispatchReceiverType(@NotNull ResolvedCall<?> resolvedCall2, @Nullable ReceiverParameterDescriptor dispatchReceiver, @NotNull KotlinTypeMapper typeMapper, @Nullable Callable callableMethod) {
        if (resolvedCall2 == null) {
            CallReceiver.$$$reportNull$$$0(7);
        }
        if (typeMapper == null) {
            CallReceiver.$$$reportNull$$$0(8);
        }
        if (dispatchReceiver == null) {
            return null;
        }
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        if (CodegenUtilKt.isJvmStaticInObjectOrClass(descriptor2)) {
            return Type.VOID_TYPE;
        }
        if (callableMethod != null) {
            return callableMethod.getDispatchReceiverType();
        }
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        if (container2 instanceof ClassDescriptor) {
            return typeMapper.mapClass((ClassDescriptor)container2);
        }
        return typeMapper.mapType(dispatchReceiver);
    }

    private static Type calcExtensionReceiverType(@NotNull ResolvedCall<?> resolvedCall2, @Nullable ReceiverParameterDescriptor extensionReceiver, @NotNull KotlinTypeMapper typeMapper, @Nullable Callable callableMethod, @NotNull GenerationState state2) {
        if (resolvedCall2 == null) {
            CallReceiver.$$$reportNull$$$0(9);
        }
        if (typeMapper == null) {
            CallReceiver.$$$reportNull$$$0(10);
        }
        if (state2 == null) {
            CallReceiver.$$$reportNull$$$0(11);
        }
        if (extensionReceiver == null) {
            return null;
        }
        Object descriptor2 = resolvedCall2.getCandidateDescriptor();
        if (descriptor2 instanceof PropertyDescriptor && state2.getIntrinsics().getIntrinsic((PropertyDescriptor)descriptor2) != JavaClassProperty.INSTANCE) {
            ReceiverParameterDescriptor receiverCandidate = descriptor2.getExtensionReceiverParameter();
            assert (receiverCandidate != null);
            return typeMapper.mapType(receiverCandidate.getType());
        }
        return callableMethod != null ? callableMethod.getExtensionReceiverType() : typeMapper.mapType(extensionReceiver.getType());
    }

    @Override
    public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
        boolean hasExtensionReceiver;
        if (type2 == null) {
            CallReceiver.$$$reportNull$$$0(12);
        }
        if (v == null) {
            CallReceiver.$$$reportNull$$$0(13);
        }
        StackValue currentExtensionReceiver = this.extensionReceiver;
        boolean bl = hasExtensionReceiver = this.extensionReceiver != CallReceiver.none();
        if (this.extensionReceiver instanceof StackValue.SafeCall) {
            currentExtensionReceiver.put(currentExtensionReceiver.type, v);
            currentExtensionReceiver = StackValue.onStack(currentExtensionReceiver.type);
        }
        Type dispatchReceiverType = this.secondReceiverType != null ? this.secondReceiverType : (hasExtensionReceiver ? this.dispatchReceiver.type : type2);
        this.dispatchReceiver.put(dispatchReceiverType, v);
        currentExtensionReceiver.moveToTopOfStack(hasExtensionReceiver ? type2 : currentExtensionReceiver.type, v, dispatchReceiverType.getSize());
    }

    @Override
    public void dup(@NotNull InstructionAdapter v, boolean withReceiver) {
        if (v == null) {
            CallReceiver.$$$reportNull$$$0(14);
        }
        AsmUtil.dup(v, this.extensionReceiver.type, this.dispatchReceiver.type);
    }

    @NotNull
    public StackValue getDispatchReceiver() {
        StackValue stackValue = this.dispatchReceiver;
        if (stackValue == null) {
            CallReceiver.$$$reportNull$$$0(15);
        }
        return stackValue;
    }

    @NotNull
    public StackValue getExtensionReceiver() {
        StackValue stackValue = this.extensionReceiver;
        if (stackValue == null) {
            CallReceiver.$$$reportNull$$$0(16);
        }
        return stackValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dispatchReceiver";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionReceiver";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedCall";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codegen";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/CallReceiver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/CallReceiver";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDispatchReceiver";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionReceiver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateCallReceiver";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "calcDispatchReceiverType";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "calcExtensionReceiverType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "putSelector";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "dup";
                break;
            }
            case 15: 
            case 16: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

