/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.editor.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.editor.event.DocumentEvent;
import org.jetbrains.kotlin.com.intellij.openapi.editor.ex.DocumentEx;
import org.jetbrains.kotlin.com.intellij.openapi.editor.ex.RangeMarkerEx;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.LineSet;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.util.text.ImmutableCharSequence;

public class FrozenDocument
implements DocumentEx {
    private final ImmutableCharSequence myText;
    @Nullable
    private volatile LineSet myLineSet;
    private final long myStamp;
    private volatile SoftReference<String> myTextString;

    /*
     * WARNING - void declaration
     */
    FrozenDocument(@NotNull ImmutableCharSequence text2, @Nullable LineSet lineSet, long stamp, @Nullable String string) {
        void textString;
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/FrozenDocument", "<init>"));
        }
        this.myText = text2;
        this.myLineSet = lineSet;
        this.myStamp = stamp;
        this.myTextString = textString == null ? null : new SoftReference<void>(textString);
    }

    @NotNull
    private LineSet getLineSet() {
        LineSet lineSet = this.myLineSet;
        if (lineSet == null) {
            this.myLineSet = lineSet = LineSet.createLineSet(this.myText);
        }
        LineSet lineSet2 = lineSet;
        if (lineSet2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/FrozenDocument", "getLineSet"));
        }
        return lineSet2;
    }

    public FrozenDocument applyEvent(DocumentEvent event, int newStamp) {
        int offset2 = event.getOffset();
        int oldEnd = offset2 + event.getOldLength();
        ImmutableCharSequence newText = this.myText.delete(offset2, oldEnd).insert(offset2, event.getNewFragment());
        LineSet newLineSet = this.getLineSet().update(this.myText, offset2, oldEnd, event.getNewFragment(), event.isWholeTextReplaced());
        return new FrozenDocument(newText, newLineSet, newStamp, null);
    }

    @Override
    public void setModificationStamp(long modificationStamp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/FrozenDocument", "removeRangeMarker"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public String getText() {
        String s = SoftReference.dereference(this.myTextString);
        if (s == null) {
            s = this.myText.toString();
            this.myTextString = new SoftReference<String>(s);
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/FrozenDocument", "getText"));
        }
        return string;
    }

    @Override
    @NotNull
    public CharSequence getCharsSequence() {
        ImmutableCharSequence immutableCharSequence = this.myText;
        if (immutableCharSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/FrozenDocument", "getCharsSequence"));
        }
        return immutableCharSequence;
    }

    @Override
    @NotNull
    public CharSequence getImmutableCharSequence() {
        ImmutableCharSequence immutableCharSequence = this.myText;
        if (immutableCharSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/FrozenDocument", "getImmutableCharSequence"));
        }
        return immutableCharSequence;
    }

    @Override
    public int getLineCount() {
        return this.getLineSet().getLineCount();
    }

    @Override
    public int getLineNumber(int offset2) {
        return this.getLineSet().findLineIndex(offset2);
    }

    @Override
    public int getLineStartOffset(int line) {
        if (line == 0) {
            return 0;
        }
        return this.getLineSet().getLineStart(line);
    }

    @Override
    public int getLineEndOffset(int line) {
        if (this.getTextLength() == 0 && line == 0) {
            return 0;
        }
        int result2 = this.getLineSet().getLineEnd(line) - this.getLineSeparatorLength(line);
        assert (result2 >= 0);
        return result2;
    }

    @Override
    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/FrozenDocument", "replaceString"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public long getModificationStamp() {
        return this.myStamp;
    }

    @Override
    public void setReadOnly(boolean isReadOnly) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setText(@NotNull CharSequence text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/FrozenDocument", "setText"));
        }
        throw new UnsupportedOperationException();
    }

    public int getLineSeparatorLength(int line) {
        return this.getLineSet().getSeparatorLength(line);
    }

    @Override
    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/FrozenDocument", "getUserData"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/FrozenDocument", "putUserData"));
        }
        throw new UnsupportedOperationException();
    }
}

