/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.codeStyle;

import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.formatting.FormattingMode;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Computable;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.ChangedRangesInfo;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.FormattingModeAwareIndentAdjuster;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.Indent;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.ThrowableRunnable;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public abstract class CodeStyleManager {
    public static CodeStyleManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/CodeStyleManager", "getInstance"));
        }
        return ServiceManager.getService(project, CodeStyleManager.class);
    }

    public static CodeStyleManager getInstance(@NotNull PsiManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/CodeStyleManager", "getInstance"));
        }
        return CodeStyleManager.getInstance(manager.getProject());
    }

    @NotNull
    public abstract Project getProject();

    @NotNull
    public abstract PsiElement reformat(@NotNull PsiElement var1) throws IncorrectOperationException;

    @NotNull
    public abstract PsiElement reformat(@NotNull PsiElement var1, boolean var2) throws IncorrectOperationException;

    public abstract PsiElement reformatRange(@NotNull PsiElement var1, int var2, int var3) throws IncorrectOperationException;

    public abstract PsiElement reformatRange(@NotNull PsiElement var1, int var2, int var3, boolean var4) throws IncorrectOperationException;

    public abstract void reformatText(@NotNull PsiFile var1, int var2, int var3) throws IncorrectOperationException;

    public abstract void reformatText(@NotNull PsiFile var1, @NotNull Collection<TextRange> var2) throws IncorrectOperationException;

    public abstract void reformatTextWithContext(@NotNull PsiFile var1, @NotNull ChangedRangesInfo var2) throws IncorrectOperationException;

    public void reformatTextWithContext(@NotNull PsiFile file, @NotNull Collection<TextRange> ranges2) throws IncorrectOperationException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/CodeStyleManager", "reformatTextWithContext"));
        }
        if (ranges2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/CodeStyleManager", "reformatTextWithContext"));
        }
        ArrayList<TextRange> rangesList = ContainerUtil.newArrayList(ranges2);
        this.reformatTextWithContext(file, new ChangedRangesInfo(rangesList, null));
    }

    public abstract void adjustLineIndent(@NotNull PsiFile var1, TextRange var2) throws IncorrectOperationException;

    public abstract int adjustLineIndent(@NotNull PsiFile var1, int var2) throws IncorrectOperationException;

    public abstract int adjustLineIndent(@NotNull Document var1, int var2);

    public abstract boolean isLineToBeIndented(@NotNull PsiFile var1, int var2);

    @Nullable
    public abstract String getLineIndent(@NotNull PsiFile var1, int var2);

    @Nullable
    public abstract String getLineIndent(@NotNull Document var1, int var2);

    public abstract Indent getIndent(String var1, FileType var2);

    public abstract String fillIndent(Indent var1, FileType var2);

    public abstract Indent zeroIndent();

    public abstract void reformatNewlyAddedElement(@NotNull ASTNode var1, @NotNull ASTNode var2) throws IncorrectOperationException;

    public abstract boolean isSequentialProcessingAllowed();

    public abstract void performActionWithFormatterDisabled(Runnable var1);

    public abstract <T extends Throwable> void performActionWithFormatterDisabled(ThrowableRunnable<T> var1) throws T;

    public abstract <T> T performActionWithFormatterDisabled(Computable<T> var1);

    public int getSpacing(@NotNull PsiFile file, int offset2) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/CodeStyleManager", "getSpacing"));
        }
        return -1;
    }

    public int getMinLineFeeds(@NotNull PsiFile file, int offset2) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/CodeStyleManager", "getMinLineFeeds"));
        }
        return -1;
    }

    public static FormattingMode getCurrentFormattingMode(@NotNull Project project) {
        CodeStyleManager instance;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/CodeStyleManager", "getCurrentFormattingMode"));
        }
        if (!project.isDisposed() && (instance = CodeStyleManager.getInstance(project)) instanceof FormattingModeAwareIndentAdjuster) {
            return ((FormattingModeAwareIndentAdjuster)((Object)instance)).getCurrentFormattingMode();
        }
        return FormattingMode.REFORMAT;
    }
}

