/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.ide.FileIconPatcher;
import org.jetbrains.kotlin.com.intellij.ide.FileIconProvider;
import org.jetbrains.kotlin.com.intellij.ide.presentation.VirtualFilePresentation;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.kotlin.com.intellij.openapi.project.DumbService;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.IconLoader;
import org.jetbrains.kotlin.com.intellij.openapi.util.Iconable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VFileProperty;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.WritingAccessProvider;
import org.jetbrains.kotlin.com.intellij.ui.IconDeferrer;
import org.jetbrains.kotlin.com.intellij.ui.LayeredIcon;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;
import org.jetbrains.kotlin.com.intellij.util.FileIconKey;
import org.jetbrains.kotlin.com.intellij.util.NullableFunction;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.PlatformIcons;

public class IconUtil {
    private static final Key<Boolean> PROJECT_WAS_EVER_INITIALIZED = Key.create("iconDeferrer:projectWasEverInitialized");
    private static final NullableFunction<FileIconKey, Icon> ICON_NULLABLE_FUNCTION = key -> {
        VirtualFile file = key.getFile();
        int flags = IconUtil.filterFileIconFlags(file, key.getFlags());
        Project project = key.getProject();
        if (!file.isValid() || project != null && (project.isDisposed() || !IconUtil.wasEverInitialized(project))) {
            return null;
        }
        Icon providersIcon = IconUtil.getProvidersIcon(file, flags, project);
        Icon icon = providersIcon == null ? VirtualFilePresentation.getIconImpl(file) : providersIcon;
        boolean dumb = project != null && DumbService.getInstance(project).isDumb();
        for (FileIconPatcher patcher : IconUtil.getPatchers()) {
            if (dumb && !DumbService.isDumbAware(patcher)) continue;
            icon = patcher.patchIcon(icon, file, flags & 0xFFFFFFFD, project);
        }
        if (file.is(VFileProperty.SYMLINK)) {
            icon = new LayeredIcon(icon, PlatformIcons.SYMLINK_ICON);
        }
        if (!(!BitUtil.isSet(flags, 2) || file.isWritable() && WritingAccessProvider.isPotentiallyWritable(file, project))) {
            icon = new LayeredIcon(icon, PlatformIcons.LOCKED_ICON);
        }
        Iconable.LastComputedIcon.put(file, icon, flags);
        return icon;
    };

    private static boolean wasEverInitialized(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/util/IconUtil", "wasEverInitialized"));
        }
        Boolean was = project.getUserData(PROJECT_WAS_EVER_INITIALIZED);
        if (was == null) {
            if (project.isInitialized()) {
                was = true;
                project.putUserData(PROJECT_WAS_EVER_INITIALIZED, was);
            } else {
                was = false;
            }
        }
        return was;
    }

    private static int filterFileIconFlags(@NotNull VirtualFile file, int flags) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/util/IconUtil", "filterFileIconFlags"));
        }
        UserDataHolder fileTypeDataHolder = ObjectUtils.tryCast(file.getFileType(), UserDataHolder.class);
        int fileTypeFlagIgnoreMask = Iconable.ICON_FLAG_IGNORE_MASK.get(fileTypeDataHolder, 0);
        int flagIgnoreMask = Iconable.ICON_FLAG_IGNORE_MASK.get(file, fileTypeFlagIgnoreMask);
        return flags & ~flagIgnoreMask;
    }

    public static Icon getIcon(@NotNull VirtualFile file, int flags, @Nullable Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/util/IconUtil", "getIcon"));
        }
        Icon lastIcon = Iconable.LastComputedIcon.get(file, flags);
        Icon base = lastIcon != null ? lastIcon : VirtualFilePresentation.getIconImpl(file);
        return IconDeferrer.getInstance().defer(base, new FileIconKey(file, project, flags), ICON_NULLABLE_FUNCTION);
    }

    @Nullable
    private static Icon getProvidersIcon(@NotNull VirtualFile file, int flags, Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/util/IconUtil", "getProvidersIcon"));
        }
        for (FileIconProvider provider : IconUtil.getProviders()) {
            Icon icon = provider.getIcon(file, flags, project);
            if (icon == null) continue;
            return icon;
        }
        return null;
    }

    @NotNull
    private static FileIconProvider[] getProviders() {
        FileIconProvider[] fileIconProviderArray = FileIconProviderHolder.myProviders;
        if (fileIconProviderArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/IconUtil", "getProviders"));
        }
        return fileIconProviderArray;
    }

    @NotNull
    private static FileIconPatcher[] getPatchers() {
        FileIconPatcher[] fileIconPatcherArray = FileIconPatcherHolder.ourPatchers;
        if (fileIconPatcherArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/IconUtil", "getPatchers"));
        }
        return fileIconPatcherArray;
    }

    @NotNull
    public static Icon getAddIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("add.png");
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/IconUtil", "getAddIcon"));
        }
        return icon;
    }

    @NotNull
    public static Icon getRemoveIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("remove.png");
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/IconUtil", "getRemoveIcon"));
        }
        return icon;
    }

    @NotNull
    public static Icon getEditIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("edit.png");
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/IconUtil", "getEditIcon"));
        }
        return icon;
    }

    @NotNull
    public static Icon getAnalyzeIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("analyze.png");
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/IconUtil", "getAnalyzeIcon"));
        }
        return icon;
    }

    @NotNull
    private static Icon getToolbarDecoratorIcon(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/util/IconUtil", "getToolbarDecoratorIcon"));
        }
        Icon icon = IconLoader.getIcon(IconUtil.getToolbarDecoratorIconsFolder() + name);
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/IconUtil", "getToolbarDecoratorIcon"));
        }
        return icon;
    }

    @NotNull
    private static String getToolbarDecoratorIconsFolder() {
        String string = "/toolbarDecorator/" + (SystemInfo.isMac ? "mac/" : "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/IconUtil", "getToolbarDecoratorIconsFolder"));
        }
        return string;
    }

    private static class FileIconPatcherHolder {
        private static final FileIconPatcher[] ourPatchers = Extensions.getExtensions(FileIconPatcher.EP_NAME);
    }

    private static class FileIconProviderHolder {
        private static final FileIconProvider[] myProviders = Extensions.getExtensions(FileIconProvider.EP_NAME);
    }
}

