/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.org.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookupSwitchInsnNode
extends AbstractInsnNode {
    public LabelNode dflt;
    public List<Integer> keys;
    public List<LabelNode> labels;

    public LookupSwitchInsnNode(LabelNode dflt, int[] keys2, LabelNode[] labels2) {
        super(171);
        this.dflt = dflt;
        this.keys = new ArrayList<Integer>(keys2 == null ? 0 : keys2.length);
        this.labels = new ArrayList<LabelNode>(labels2 == null ? 0 : labels2.length);
        if (keys2 != null) {
            for (int i = 0; i < keys2.length; ++i) {
                this.keys.add(keys2[i]);
            }
        }
        if (labels2 != null) {
            this.labels.addAll(Arrays.asList(labels2));
        }
    }

    @Override
    public int getType() {
        return 12;
    }

    @Override
    public void accept(MethodVisitor mv) {
        int[] keys2 = new int[this.keys.size()];
        for (int i = 0; i < keys2.length; ++i) {
            keys2[i] = this.keys.get(i);
        }
        Label[] labels2 = new Label[this.labels.size()];
        for (int i = 0; i < labels2.length; ++i) {
            labels2[i] = this.labels.get(i).getLabel();
        }
        mv.visitLookupSwitchInsn(this.dflt.getLabel(), keys2, labels2);
        this.acceptAnnotations(mv);
    }

    @Override
    public AbstractInsnNode clone(Map<LabelNode, LabelNode> labels2) {
        LookupSwitchInsnNode clone = new LookupSwitchInsnNode(LookupSwitchInsnNode.clone(this.dflt, labels2), null, LookupSwitchInsnNode.clone(this.labels, labels2));
        clone.keys.addAll(this.keys);
        return clone.cloneAnnotations(this);
    }
}

