/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.annotations;

import java.util.Collection;
import java.util.List;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.MemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.BuiltInAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.EnumValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.StringValue;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import org.jetbrains.annotations.NotNull;

public final class AnnotationUtilKt {
    private static final Name DEPRECATED_MESSAGE_NAME = Name.identifier("message");
    private static final Name DEPRECATED_REPLACE_WITH_NAME = Name.identifier("replaceWith");
    private static final Name DEPRECATED_LEVEL_NAME = Name.identifier("level");
    private static final Name REPLACE_WITH_EXPRESSION_NAME = Name.identifier("expression");
    private static final Name REPLACE_WITH_IMPORTS_NAME = Name.identifier("imports");
    private static final FqName INLINE_ONLY_ANNOTATION_FQ_NAME = new FqName("kotlin.internal.InlineOnly");

    @NotNull
    public static final AnnotationDescriptor createDeprecatedAnnotation(@NotNull KotlinBuiltIns $receiver, @NotNull String message, @NotNull String replaceWith, @NotNull String level) {
        BuiltInAnnotationDescriptor builtInAnnotationDescriptor;
        EnumValue enumValue;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)replaceWith, (String)"replaceWith");
        Intrinsics.checkParameterIsNotNull((Object)level, (String)"level");
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.replaceWith;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"KotlinBuiltIns.FQ_NAMES.replaceWith");
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to((Object)REPLACE_WITH_EXPRESSION_NAME, (Object)new StringValue(replaceWith, $receiver));
        List list = CollectionsKt.emptyList();
        SimpleType simpleType2 = $receiver.getArrayType(Variance.INVARIANT, $receiver.getStringType());
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"getArrayType(Variance.INVARIANT, stringType)");
        pairArray[1] = TuplesKt.to((Object)REPLACE_WITH_IMPORTS_NAME, (Object)new ArrayValue(list, simpleType2, $receiver));
        BuiltInAnnotationDescriptor replaceWithAnnotation = new BuiltInAnnotationDescriptor($receiver, fqName2, MapsKt.mapOf((Pair[])pairArray));
        KotlinBuiltIns kotlinBuiltIns = $receiver;
        FqName fqName3 = KotlinBuiltIns.FQ_NAMES.deprecated;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"KotlinBuiltIns.FQ_NAMES.deprecated");
        Pair[] pairArray2 = new Pair[3];
        pairArray2[0] = TuplesKt.to((Object)DEPRECATED_MESSAGE_NAME, (Object)new StringValue(message, $receiver));
        pairArray2[1] = TuplesKt.to((Object)DEPRECATED_REPLACE_WITH_NAME, (Object)new AnnotationValue(replaceWithAnnotation));
        Name name = DEPRECATED_LEVEL_NAME;
        ClassDescriptor classDescriptor = $receiver.getDeprecationLevelEnumEntry(level);
        if (classDescriptor == null) {
            String string = "Deprecation level " + level + " not found";
            EnumValue enumValue2 = enumValue;
            EnumValue enumValue3 = enumValue;
            Name name2 = name;
            int n = 2;
            Pair[] pairArray3 = pairArray2;
            Pair[] pairArray4 = pairArray2;
            FqName fqName4 = fqName3;
            KotlinBuiltIns kotlinBuiltIns2 = kotlinBuiltIns;
            BuiltInAnnotationDescriptor builtInAnnotationDescriptor2 = builtInAnnotationDescriptor;
            BuiltInAnnotationDescriptor builtInAnnotationDescriptor3 = builtInAnnotationDescriptor;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        enumValue = new EnumValue(classDescriptor);
        pairArray2[2] = TuplesKt.to((Object)name, (Object)enumValue);
        builtInAnnotationDescriptor = new BuiltInAnnotationDescriptor(kotlinBuiltIns, fqName3, MapsKt.mapOf((Pair[])pairArray2));
        return builtInAnnotationDescriptor;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ AnnotationDescriptor createDeprecatedAnnotation$default(KotlinBuiltIns kotlinBuiltIns, String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            string3 = "WARNING";
        }
        return AnnotationUtilKt.createDeprecatedAnnotation(kotlinBuiltIns, string, string2, string3);
    }

    public static final boolean isInlineOnlyOrReifiable(@NotNull MemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof CallableMemberDescriptor && (AnnotationUtilKt.isReifiable((CallableMemberDescriptor)$receiver) || AnnotationUtilKt.isReifiable(DescriptorUtils.getDirectMember((CallableMemberDescriptor)$receiver)) || AnnotationUtilKt.isInlineOnly($receiver));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isEffectivelyInlineOnly(@NotNull MemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (AnnotationUtilKt.isInlineOnlyOrReifiable($receiver)) return true;
        MemberDescriptor $receiver$iv = $receiver;
        MemberDescriptor memberDescriptor = $receiver$iv;
        if (!(memberDescriptor instanceof FunctionDescriptor)) {
            memberDescriptor = null;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)memberDescriptor;
        if (functionDescriptor == null) return false;
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        FunctionDescriptor it = functionDescriptor2;
        if (!it.isSuspend()) return false;
        if (!it.isInline()) return false;
        return true;
    }

    public static final boolean isInlineOnly(@NotNull MemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (!($receiver instanceof FunctionDescriptor) || !AnnotationUtilKt.hasInlineOnlyAnnotation((CallableMemberDescriptor)$receiver) && !AnnotationUtilKt.hasInlineOnlyAnnotation(DescriptorUtils.getDirectMember((CallableMemberDescriptor)$receiver))) {
            return false;
        }
        boolean bl = ((FunctionDescriptor)$receiver).isInline();
        if (_Assertions.ENABLED && !bl) {
            String string = "Function is not inline: " + $receiver;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return true;
    }

    private static final boolean isReifiable(@NotNull CallableMemberDescriptor $receiver) {
        boolean bl;
        block3: {
            Iterable $receiver$iv = $receiver.getTypeParameters();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                    if (!it.isReified()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean hasInlineOnlyAnnotation(@NotNull CallableMemberDescriptor $receiver) {
        return $receiver.getAnnotations().hasAnnotation(INLINE_ONLY_ANNOTATION_FQ_NAME);
    }
}

