/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;

class IncrementalCompilationInitializer {
    private final FileOperations fileOperations;

    public IncrementalCompilationInitializer(FileOperations fileOperations) {
        this.fileOperations = fileOperations;
    }

    public void initializeCompilation(JavaCompileSpec spec, Collection<String> staleClasses) {
        if (staleClasses.isEmpty()) {
            spec.setSource((FileCollection)new SimpleFileCollection(new File[0]));
            return;
        }
        Factory patternSetFactory = this.fileOperations.getFileResolver().getPatternSetFactory();
        PatternSet classesToDelete = (PatternSet)patternSetFactory.create();
        PatternSet sourceToCompile = (PatternSet)patternSetFactory.create();
        this.preparePatterns(staleClasses, classesToDelete, sourceToCompile);
        spec.setSource((FileCollection)spec.getSource().getAsFileTree().matching((PatternFilterable)sourceToCompile));
        ArrayList classpath = Lists.newArrayList((Iterable)spec.getCompileClasspath());
        classpath.add(spec.getDestinationDir());
        spec.setCompileClasspath(classpath);
        FileTree deleteMe = this.fileOperations.fileTree((Object)spec.getDestinationDir()).matching((PatternFilterable)classesToDelete);
        this.fileOperations.delete(new Object[]{deleteMe});
    }

    void preparePatterns(Collection<String> staleClasses, PatternSet classesToDelete, PatternSet sourceToCompile) {
        assert (!staleClasses.isEmpty());
        for (String staleClass : staleClasses) {
            String path = staleClass.replaceAll("\\.", "/");
            classesToDelete.include(new String[]{path.concat(".class")});
            classesToDelete.include(new String[]{path.concat("$*.class")});
            sourceToCompile.include(new String[]{path.concat(".java")});
            sourceToCompile.include(new String[]{path.concat("$*.java")});
        }
    }
}

