/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import org.gradle.api.internal.artifacts.ivyservice.modulecache.MissingModuleCacheEntry;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.component.model.ModuleSource;

class ModuleMetadataCacheEntry {
    static final byte TYPE_MISSING = 0;
    static final byte TYPE_PRESENT = 1;
    final byte type;
    final boolean isChanging;
    final long createTimestamp;
    final ModuleSource moduleSource;

    ModuleMetadataCacheEntry(byte type, boolean isChanging, long createTimestamp, ModuleSource moduleSource) {
        this.type = type;
        this.isChanging = isChanging;
        this.createTimestamp = createTimestamp;
        this.moduleSource = moduleSource;
    }

    public static ModuleMetadataCacheEntry forMissingModule(long createTimestamp) {
        return new MissingModuleCacheEntry(createTimestamp);
    }

    public static ModuleMetadataCacheEntry forMetaData(ModuleComponentResolveMetadata metaData, long createTimestamp) {
        return new ModuleMetadataCacheEntry(1, metaData.isChanging(), createTimestamp, metaData.getSource());
    }

    public boolean isMissing() {
        return this.type == 0;
    }

    protected ModuleComponentResolveMetadata configure(MutableModuleComponentResolveMetadata input) {
        input.setChanging(this.isChanging);
        input.setSource(this.moduleSource);
        return input.asImmutable();
    }
}

