/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.javascript.coffeescript;

import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.plugins.javascript.base.JavaScriptExtension;
import org.gradle.plugins.javascript.coffeescript.CoffeeScriptCompile;
import org.gradle.plugins.javascript.coffeescript.CoffeeScriptExtension;
import org.gradle.plugins.javascript.rhino.RhinoExtension;
import org.gradle.plugins.javascript.rhino.RhinoPlugin;

public class CoffeeScriptBasePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(RhinoPlugin.class);
        JavaScriptExtension jsExtension = (JavaScriptExtension)project.getExtensions().getByType(JavaScriptExtension.class);
        ExtensionContainer extensionContainer = ((ExtensionAware)jsExtension).getExtensions();
        final CoffeeScriptExtension csExtension = (CoffeeScriptExtension)extensionContainer.create("coffeeScript", CoffeeScriptExtension.class, new Object[0]);
        final Configuration jsConfiguration = this.addJsConfiguration(project.getConfigurations(), project.getDependencies(), csExtension);
        ConventionMapping conventionMapping = ((IConventionAware)csExtension).getConventionMapping();
        conventionMapping.map("js", (Callable)new Callable<Configuration>(){

            @Override
            public Configuration call() {
                return jsConfiguration;
            }
        });
        conventionMapping.map("version", (Callable)new Callable<String>(){

            @Override
            public String call() {
                return "1.3.3";
            }
        });
        final RhinoExtension rhinoExtension = (RhinoExtension)extensionContainer.getByType(RhinoExtension.class);
        project.getTasks().withType(CoffeeScriptCompile.class, (Action)new Action<CoffeeScriptCompile>(){

            public void execute(CoffeeScriptCompile task) {
                task.getConventionMapping().map("rhinoClasspath", (Callable)new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() {
                        return rhinoExtension.getClasspath();
                    }
                });
                task.getConventionMapping().map("coffeeScriptJs", (Callable)new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() {
                        return csExtension.getJs();
                    }
                });
            }
        });
    }

    private Configuration addJsConfiguration(ConfigurationContainer configurations, final DependencyHandler dependencies, final CoffeeScriptExtension extension) {
        Configuration configuration = (Configuration)configurations.create("coffeeScriptBasePluginJs");
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet configDependencies) {
                String notation = "org.coffeescript:coffee-script-js:" + extension.getVersion() + "@js";
                Dependency dependency = dependencies.create((Object)notation);
                configDependencies.add((Object)dependency);
            }
        });
        return configuration;
    }
}

