/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

class WorkQueue {
    private static final ScheduledThreadPoolExecutor executor;
    static final Object executorKiller;

    WorkQueue() {
    }

    static ScheduledThreadPoolExecutor getExecutor() {
        return executor;
    }

    static {
        int threads = 1;
        executor = new ScheduledThreadPoolExecutor(threads, new ThreadFactory(){
            private final ThreadFactory baseFactory = Executors.defaultThreadFactory();

            @Override
            public Thread newThread(Runnable taskBody) {
                Thread thr = this.baseFactory.newThread(taskBody);
                thr.setName("JGit-WorkQueue");
                thr.setDaemon(true);
                return thr;
            }
        });
        executor.setRemoveOnCancelPolicy(true);
        executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        executor.prestartAllCoreThreads();
        executor.setThreadFactory(Executors.defaultThreadFactory());
        executorKiller = new Object(){

            protected void finalize() {
                executor.shutdownNow();
            }
        };
    }
}

