/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.io.IOException;
import org.simpleframework.http.core.BodyConsumer;
import org.simpleframework.http.core.Consumer;
import org.simpleframework.http.core.PartFactory;
import org.simpleframework.http.core.PartHeaderConsumer;
import org.simpleframework.http.core.PartList;
import org.simpleframework.http.core.SegmentConsumer;
import org.simpleframework.transport.Cursor;
import org.simpleframework.util.buffer.Allocator;

class PartConsumer
implements Consumer {
    private SegmentConsumer header;
    private BodyConsumer body;
    private PartFactory factory;
    private Consumer current;
    private PartList list;
    private byte[] terminal;

    public PartConsumer(Allocator allocator, PartList list, byte[] terminal) {
        this.header = new PartHeaderConsumer(allocator);
        this.factory = new PartFactory(allocator, this.header);
        this.terminal = terminal;
        this.current = this.header;
        this.list = list;
    }

    private BodyConsumer getConsumer() throws IOException {
        return this.factory.getInstance(this.list, this.terminal);
    }

    public void consume(Cursor cursor) throws IOException {
        while (cursor.isReady()) {
            if (this.header.isFinished()) {
                if (this.body == null) {
                    this.body = this.getConsumer();
                    this.current = this.body;
                } else if (this.body.isFinished()) break;
            }
            this.current.consume(cursor);
        }
    }

    public boolean isFinished() {
        if (this.body != null) {
            return this.body.isFinished();
        }
        return false;
    }
}

