/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import java.util.Arrays;
import java.util.Collections;
import org.gradle.api.Transformer;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.internal.consumer.AbstractLongRunningOperation;
import org.gradle.tooling.internal.consumer.BlockingResultHandler;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.ExceptionTransformer;
import org.gradle.tooling.internal.consumer.async.AsyncConsumerActionExecutor;
import org.gradle.tooling.internal.consumer.connection.ConsumerAction;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.model.Launchable;
import org.gradle.tooling.model.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBuildLauncher
extends AbstractLongRunningOperation<DefaultBuildLauncher>
implements BuildLauncher {
    protected final AsyncConsumerActionExecutor connection;

    public DefaultBuildLauncher(AsyncConsumerActionExecutor connection, ConnectionParameters parameters) {
        super(parameters);
        this.operationParamsBuilder.setEntryPoint("BuildLauncher API");
        this.operationParamsBuilder.setTasks(Collections.<String>emptyList());
        this.connection = connection;
    }

    @Override
    protected DefaultBuildLauncher getThis() {
        return this;
    }

    @Override
    public BuildLauncher forTasks(String ... tasks) {
        this.operationParamsBuilder.setTasks(Arrays.asList(tasks));
        return this;
    }

    @Override
    public BuildLauncher forTasks(Task ... tasks) {
        this.forTasks(Arrays.asList(tasks));
        return this;
    }

    @Override
    public BuildLauncher forTasks(Iterable<? extends Task> tasks) {
        this.forLaunchables(tasks);
        return this;
    }

    @Override
    public BuildLauncher forLaunchables(Launchable ... launchables) {
        return this.forLaunchables(Arrays.asList(launchables));
    }

    @Override
    public BuildLauncher forLaunchables(Iterable<? extends Launchable> launchables) {
        this.preprocessLaunchables(launchables);
        this.operationParamsBuilder.setLaunchables(launchables);
        return this;
    }

    protected void preprocessLaunchables(Iterable<? extends Launchable> launchables) {
    }

    @Override
    public void run() {
        BlockingResultHandler<Void> handler = new BlockingResultHandler<Void>(Void.class);
        this.run(handler);
        handler.getResult();
    }

    @Override
    public void run(ResultHandler<? super Void> handler) {
        final ConsumerOperationParameters operationParameters = this.getConsumerOperationParameters();
        this.connection.run(new ConsumerAction<Void>(){

            @Override
            public ConsumerOperationParameters getParameters() {
                return operationParameters;
            }

            @Override
            public Void run(ConsumerConnection connection) {
                Void sink = connection.run(Void.class, operationParameters);
                return sink;
            }
        }, new ResultHandlerAdapter(handler));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultHandlerAdapter
    extends org.gradle.tooling.internal.consumer.ResultHandlerAdapter<Void> {
        public ResultHandlerAdapter(ResultHandler<? super Void> handler) {
            super(handler, new ExceptionTransformer(new Transformer<String, Throwable>(){

                public String transform(Throwable throwable) {
                    return String.format("Could not execute build using %s.", DefaultBuildLauncher.this.connection.getDisplayName());
                }
            }));
        }
    }
}

