/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality.internal.findbugs;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.util.VersionNumber;

public class FindBugsClasspathValidator {
    private final JavaVersion javaVersion;

    public FindBugsClasspathValidator(JavaVersion javaVersion) {
        this.javaVersion = javaVersion;
    }

    public void validateClasspath(Iterable<String> fileNamesOnClasspath) {
        boolean findbugs2orLess;
        VersionNumber v = this.getFindbugsVersion(fileNamesOnClasspath);
        boolean java8orMore = this.javaVersion.compareTo((Enum)JavaVersion.VERSION_1_7) > 0;
        boolean bl = findbugs2orLess = v.getMajor() < 3;
        if (java8orMore && findbugs2orLess) {
            throw new FindBugsVersionTooLowException("The version of FindBugs (" + v + ") inferred from FindBugs classpath is too low to work with currently used Java version (" + this.javaVersion + ")." + " Please use higher version of FindBugs. Inspected FindBugs classpath: " + fileNamesOnClasspath);
        }
    }

    private VersionNumber getFindbugsVersion(Iterable<String> classpath) {
        for (String f : classpath) {
            Matcher m = Pattern.compile("findbugs-(\\d+.*)\\.jar").matcher(f);
            if (!m.matches()) continue;
            return VersionNumber.parse((String)m.group(1));
        }
        throw new GradleException("Unable to infer the version of FindBugs from currently specified FindBugs classpath: " + classpath);
    }

    static class FindBugsVersionTooLowException
    extends GradleException {
        FindBugsVersionTooLowException(String message) {
            super(message);
        }
    }
}

