/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jta.narayana;

import com.arjuna.ats.jta.recovery.XAResourceRecoveryHelper;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.springframework.boot.jta.XADataSourceWrapper;
import org.springframework.boot.jta.narayana.DataSourceXAResourceRecoveryHelper;
import org.springframework.boot.jta.narayana.NarayanaDataSourceBean;
import org.springframework.boot.jta.narayana.NarayanaProperties;
import org.springframework.boot.jta.narayana.NarayanaRecoveryManagerBean;
import org.springframework.util.Assert;

public class NarayanaXADataSourceWrapper
implements XADataSourceWrapper {
    private final NarayanaRecoveryManagerBean recoveryManager;
    private final NarayanaProperties properties;

    public NarayanaXADataSourceWrapper(NarayanaRecoveryManagerBean recoveryManager, NarayanaProperties properties) {
        Assert.notNull((Object)recoveryManager, (String)"RecoveryManager must not be null");
        Assert.notNull((Object)properties, (String)"Properties must not be null");
        this.recoveryManager = recoveryManager;
        this.properties = properties;
    }

    @Override
    public DataSource wrapDataSource(XADataSource dataSource) {
        XAResourceRecoveryHelper recoveryHelper = this.getRecoveryHelper(dataSource);
        this.recoveryManager.registerXAResourceRecoveryHelper(recoveryHelper);
        return new NarayanaDataSourceBean(dataSource);
    }

    private XAResourceRecoveryHelper getRecoveryHelper(XADataSource dataSource) {
        if (this.properties.getRecoveryDbUser() == null && this.properties.getRecoveryDbPass() == null) {
            return new DataSourceXAResourceRecoveryHelper(dataSource);
        }
        return new DataSourceXAResourceRecoveryHelper(dataSource, this.properties.getRecoveryDbUser(), this.properties.getRecoveryDbPass());
    }
}

