/*
 * Decompiled with CFR 0.152.
 */
package org.grails.io.watch;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.grails.io.watch.DirectoryWatcher;

abstract class AbstractDirectoryWatcher
implements Runnable {
    private List<DirectoryWatcher.FileChangeListener> listeners = new ArrayList<DirectoryWatcher.FileChangeListener>();
    protected volatile boolean active = true;
    protected long sleepTime = 1000L;

    AbstractDirectoryWatcher() {
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    public void addListener(DirectoryWatcher.FileChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(DirectoryWatcher.FileChangeListener listener) {
        this.listeners.remove(listener);
    }

    public abstract void addWatchFile(File var1);

    public abstract void addWatchDirectory(File var1, List<String> var2);

    protected void fireOnChange(File file) {
        for (DirectoryWatcher.FileChangeListener listener : this.listeners) {
            listener.onChange(file);
        }
    }

    protected void fireOnNew(File file) {
        for (DirectoryWatcher.FileChangeListener listener : this.listeners) {
            listener.onNew(file);
        }
    }

    protected boolean isValidDirectoryToMonitor(File file) {
        return file.isDirectory() && !file.isHidden() && !file.getName().startsWith(".");
    }

    protected boolean isValidFileToMonitor(File file, Collection<String> fileExtensions) {
        String name = file.getName();
        String path = file.getAbsolutePath();
        boolean isSvnFile = path.indexOf(File.separator + ".svn" + File.separator) > 0;
        return !isSvnFile && !file.isDirectory() && !file.isHidden() && !file.getName().startsWith(".") && (fileExtensions.contains("*") || fileExtensions.contains(AbstractDirectoryWatcher.getFilenameExtension(name)));
    }

    public static String getFilenameExtension(String path) {
        if (path == null) {
            return null;
        }
        int extIndex = path.lastIndexOf(".");
        if (extIndex == -1) {
            return null;
        }
        return path.substring(extIndex + 1);
    }
}

