/*
 * Copyright 2006-2007 Graeme Rocher
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package grails.plugins;

import org.springframework.beans.factory.Aware;

/**
 * For implementors interested in obtaining a reference to the Grails PluginManager instance.
 *
 * @see GrailsPluginManager
 *
 * @author Graeme Rocher
 * @since 0.6
 */
public interface PluginManagerAware extends Aware {

    /**
     * Sets the plug-in manager on this instance
     *
     * @param pluginManager The PluginManager
     */
    void setPluginManager(GrailsPluginManager pluginManager);
}
