/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import org.jmol.adapter.readers.cif.CifReader;
import org.jmol.adapter.readers.cif.MMCifValidationParser;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Structure;
import org.jmol.c.STR;
import org.jmol.java.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.Logger;

public class MMCifReader
extends CifReader {
    protected boolean isBiomolecule;
    private boolean byChain;
    private boolean bySymop;
    private Map<String, P3> chainAtomMap;
    private Map<String, int[]> chainAtomCounts;
    protected Lst<Map<String, Object>> vBiomolecules;
    private Map<String, M4> htBiomts;
    protected Map<String, Map<String, Object>> htSites;
    protected Map<String, String> htHetero;
    private Map<String, Lst<Object[]>> htBondMap;
    private Map<String, BS> assemblyIdAtoms;
    private int thisChain = -1;
    private int modelIndex = 0;
    private P3 chainSum;
    private int[] chainAtomCount;
    private boolean isLigandBondBug;
    M4 mident;
    private boolean requiresSorting;
    private static final byte OPER_ID = 12;
    private static final byte OPER_XYZ = 13;
    private static final String FAMILY_NCS_CAT = "_struct_ncs_oper.";
    private static final String FAMILY_NCS = "_struct_ncs_oper";
    private static final String[] ncsoperFields = new String[]{"*_matrix[1][1]", "*_matrix[1][2]", "*_matrix[1][3]", "*_vector[1]", "*_matrix[2][1]", "*_matrix[2][2]", "*_matrix[2][3]", "*_vector[2]", "*_matrix[3][1]", "*_matrix[3][2]", "*_matrix[3][3]", "*_vector[3]", "*_id", "*_symmetry_operation"};
    private static final String FAMILY_OPER_CAT = "_pdbx_struct_oper_list.";
    private static final String FAMILY_OPER = "_pdbx_struct_oper_list";
    private static final String[] operFields = new String[]{"*_matrix[1][1]", "*_matrix[1][2]", "*_matrix[1][3]", "*_vector[1]", "*_matrix[2][1]", "*_matrix[2][2]", "*_matrix[2][3]", "*_vector[2]", "*_matrix[3][1]", "*_matrix[3][2]", "*_matrix[3][3]", "*_vector[3]", "*_id", "*_symmetry_operation"};
    private static final byte ASSEM_ID = 0;
    private static final byte ASSEM_OPERS = 1;
    private static final byte ASSEM_LIST = 2;
    private static final String FAMILY_ASSEM_CAT = "_pdbx_struct_assembly_gen.";
    private static final String[] assemblyFields = new String[]{"_pdbx_struct_assembly_gen_assembly_id", "_pdbx_struct_assembly_gen_oper_expression", "_pdbx_struct_assembly_gen_asym_id_list"};
    private static final String FAMILY_SEQUENCEDIF_CAT = "_struct_ref_seq_dif.";
    private static final byte STRUCT_REF_G3 = 0;
    private static final byte STRUCT_REF_G1 = 1;
    private static final String[] structRefFields = new String[]{"_struct_ref_seq_dif_mon_id", "_struct_ref_seq_dif_db_mon_id"};
    private static final byte CHEM_COMP_ID = 0;
    private static final byte CHEM_COMP_NAME = 1;
    private static final String FAMILY_CHEMCOMP_CAT = "_chem_comp.";
    private static final String[] chemCompFields = new String[]{"_chem_comp_id", "_chem_comp_name"};
    private static final byte CONF_TYPE_ID = 0;
    private static final byte BEG_ASYM_ID = 1;
    private static final byte BEG_SEQ_ID = 2;
    private static final byte BEG_INS_CODE = 3;
    private static final byte END_ASYM_ID = 4;
    private static final byte END_SEQ_ID = 5;
    private static final byte END_INS_CODE = 6;
    private static final byte STRUCT_ID = 7;
    private static final byte SERIAL_NO = 8;
    private static final byte HELIX_CLASS = 9;
    private static final String FAMILY_STRUCTCONF_CAT = "_struct_conf.";
    private static final String FAMILY_STRUCTCONF = "_struct_conf";
    private static final String[] structConfFields = new String[]{"*_conf_type_id", "*_beg_auth_asym_id", "*_beg_auth_seq_id", "*_pdbx_beg_pdb_ins_code", "*_end_auth_asym_id", "*_end_auth_seq_id", "*_pdbx_end_pdb_ins_code", "*_id", "*_pdbx_pdb_helix_id", "*_pdbx_pdb_helix_class"};
    private static final byte SHEET_ID = 0;
    private static final byte STRAND_ID = 7;
    private static final String FAMILY_SHEET_CAT = "_struct_sheet_range.";
    private static final String FAMILY_SHEET = "_struct_sheet_range";
    private static final String[] structSheetRangeFields = new String[]{"*_sheet_id", "*_beg_auth_asym_id", "*_beg_auth_seq_id", "*_pdbx_beg_pdb_ins_code", "*_end_auth_asym_id", "*_end_auth_seq_id", "*_pdbx_end_pdb_ins_code", "*_id"};
    private static final byte SITE_ID = 0;
    private static final byte SITE_COMP_ID = 1;
    private static final byte SITE_ASYM_ID = 2;
    private static final byte SITE_SEQ_ID = 3;
    private static final byte SITE_INS_CODE = 4;
    private static final String FAMILY_STRUCSITE_CAT = "_struct_site_gen.";
    private static final String FAMILY_STRUCSITE = "_struct_site_gen";
    private static final String[] structSiteFields = new String[]{"*_site_id", "*_auth_comp_id", "*_auth_asym_id", "*_auth_seq_id", "*_label_alt_id"};
    private static final byte STRUCT_CONN_ASYM1 = 0;
    private static final byte STRUCT_CONN_SEQ1 = 1;
    private static final byte STRUCT_CONN_COMP1 = 2;
    private static final byte STRUCT_CONN_ATOM1 = 3;
    private static final byte STRUCT_CONN_ALT1 = 4;
    private static final byte STRUCT_CONN_SYMM1 = 5;
    private static final byte STRUCT_CONN_ASYM2 = 6;
    private static final byte STRUCT_CONN_SEQ2 = 7;
    private static final byte STRUCT_CONN_COMP2 = 8;
    private static final byte STRUCT_CONN_ATOM2 = 9;
    private static final byte STRUCT_CONN_ALT2 = 10;
    private static final byte STRUCT_CONN_SYMM2 = 11;
    private static final byte STRUCT_CONN_TYPE = 12;
    private static final byte STRUCT_CONN_ORDER = 13;
    private static final String FAMILY_STRUCTCONN_CAT = "_struct_conn.";
    private static final String FAMILY_STRUCTCONN = "_struct_conn";
    private static final String[] structConnFields = new String[]{"*_ptnr1_auth_asym_id", "*_ptnr1_auth_seq_id", "*_ptnr1_auth_comp_id", "*_ptnr1_label_atom_id", "*_pdbx_ptnr1_label_alt_id", "*_ptnr1_symmetry", "*_ptnr2_auth_asym_id", "*_ptnr2_auth_seq_id", "*_ptnr2_auth_comp_id", "*_ptnr2_label_atom_id", "*_pdbx_ptnr2_label_alt_id", "*_ptnr2_symmetry", "*_conn_type_id", "*_pdbx_value_order"};
    private Lst<Object[]> structConnMap;
    private String structConnList = "";
    private boolean doSetBonds;
    private static final byte CHEM_COMP_BOND_ID = 0;
    private static final byte CHEM_COMP_BOND_ATOM_ID_1 = 1;
    private static final byte CHEM_COMP_BOND_ATOM_ID_2 = 2;
    private static final byte CHEM_COMP_BOND_VALUE_ORDER = 3;
    private static final byte CHEM_COMP_BOND_AROMATIC_FLAG = 4;
    private static final String FAMILY_COMPBOND_CAT = "_chem_comp_bond.";
    private static final String FAMILY_COMPBOND = "_chem_comp_bond";
    private static final String[] chemCompBondFields = new String[]{"*_comp_id", "*_atom_id_1", "*_atom_id_2", "*_value_order", "*_pdbx_aromatic_flag"};
    private String modelStrings = "";
    protected boolean done;

    @Override
    protected void initSubclass() {
        this.setIsPDB();
        this.mident = M4.newM4(null);
        this.isMMCIF = true;
        if (this.isDSSP1) {
            this.asc.setInfo("isDSSP1", (Object)Boolean.TRUE);
        }
        if (this.htParams.containsKey("isMutate")) {
            this.asc.setInfo("isMutate", (Object)Boolean.TRUE);
        }
        this.doSetBonds = this.checkFilterKey("ADDBONDS");
        this.byChain = this.checkFilterKey("BYCHAIN");
        if (this.checkFilterKey("BIOMOLECULE")) {
            this.filter = PT.rep((String)this.filter, (String)"BIOMOLECULE", (String)"ASSEMBLY");
        }
        this.isBiomolecule = this.checkFilterKey("ASSEMBLY");
        if (this.isBiomolecule) {
            this.filter = this.filter.replace(':', ' ');
            this.bySymop = this.checkFilterKey("BYSYMOP");
        }
        boolean bl = this.isCourseGrained = this.byChain || this.bySymop;
        if (this.isCourseGrained) {
            this.chainAtomMap = new Hashtable<String, P3>();
            this.chainAtomCounts = new Hashtable<String, int[]>();
        }
        this.isLigandBondBug = this.stateScriptVersionInt >= 140204 && this.stateScriptVersionInt <= 140208 || this.stateScriptVersionInt >= 140304 && this.stateScriptVersionInt <= 140308;
    }

    @Override
    protected void processSubclassEntry() throws Exception {
        if (this.key0.startsWith(FAMILY_ASSEM_CAT) || this.key0.startsWith(FAMILY_STRUCTCONN_CAT) || this.key0.startsWith(FAMILY_SEQUENCEDIF_CAT) || this.key0.startsWith(FAMILY_STRUCTCONF_CAT) || this.key0.startsWith(FAMILY_SHEET_CAT)) {
            this.processSubclassLoopBlock();
        } else if (this.key.equals("_rna3d")) {
            this.addedData = this.data;
            this.addedDataKey = this.key;
        } else if (this.key.equals("_dssr")) {
            this.dssr = this.vwr.parseJSONMap(this.reader.readLine());
            this.reader.readLine();
        }
    }

    @Override
    protected boolean processSubclassLoopBlock() throws Exception {
        if (this.key0.startsWith(FAMILY_NCS_CAT)) {
            return this.processStructOperListBlock(true);
        }
        if (this.key0.startsWith(FAMILY_OPER_CAT)) {
            return this.processStructOperListBlock(false);
        }
        if (this.key0.startsWith(FAMILY_ASSEM_CAT)) {
            return this.processAssemblyGenBlock();
        }
        if (this.key0.startsWith(FAMILY_SEQUENCEDIF_CAT)) {
            return this.processSequence();
        }
        if (this.isCourseGrained) {
            return false;
        }
        if (this.key0.startsWith(FAMILY_STRUCSITE_CAT)) {
            return this.processStructSiteBlock();
        }
        if (this.key0.startsWith(FAMILY_CHEMCOMP_CAT)) {
            return this.processChemCompLoopBlock();
        }
        if (this.key0.startsWith(FAMILY_STRUCTCONF_CAT)) {
            return this.processStructConfLoopBlock();
        }
        if (this.key0.startsWith(FAMILY_SHEET_CAT)) {
            return this.processStructSheetRangeLoopBlock();
        }
        if (this.isLigandBondBug) {
            return false;
        }
        if (this.key0.startsWith(FAMILY_COMPBOND_CAT)) {
            return this.processCompBondLoopBlock();
        }
        if (this.key0.startsWith(FAMILY_STRUCTCONN_CAT)) {
            return this.processStructConnLoopBlock();
        }
        return false;
    }

    protected void sortAssemblyModels() {
        int natoms = this.asc.ac;
        int lastSet = -1;
        Atom[] atoms = this.asc.atoms;
        Atom[] newAtoms = new Atom[natoms];
        String[] ids = PT.split((String)("," + this.modelStrings + ","), (String)",,");
        BS bsAtomsNew = this.asc.bsAtoms == null ? null : BS.newN((int)this.asc.bsAtoms.size());
        int n = 0;
        for (int im = 1; im < ids.length; ++im) {
            String sModel = ids[im];
            int modelIndex = -1;
            for (int is = 0; is < this.asc.atomSetCount; ++is) {
                int ia0 = this.asc.getAtomSetAtomIndex(is);
                int ia1 = ia0 + this.asc.getAtomSetAtomCount(is);
                String am = "" + this.modelMap.get("_" + is);
                if (!am.equals(sModel)) continue;
                if (modelIndex < 0 && (modelIndex = is) > lastSet) {
                    lastSet = is;
                }
                for (int i = ia0; i < ia1; ++i) {
                    if (bsAtomsNew != null && !this.asc.bsAtoms.get(i)) continue;
                    if (bsAtomsNew != null) {
                        bsAtomsNew.set(n);
                    }
                    atoms[i].atomSetIndex = modelIndex;
                    newAtoms[n++] = atoms[i];
                }
            }
        }
        this.asc.atoms = newAtoms;
        this.asc.bsAtoms = bsAtomsNew;
        if (++lastSet < this.asc.atomSetCount) {
            this.asc.atomSetCount = lastSet;
        }
    }

    @Override
    protected boolean finalizeSubclass() throws Exception {
        boolean haveBiomolecule;
        if (this.byChain && !this.isBiomolecule) {
            for (String id : this.chainAtomMap.keySet()) {
                this.createParticle(id);
            }
        }
        boolean bl = haveBiomolecule = this.isBiomolecule && this.vBiomolecules != null && this.vBiomolecules.size() > 0;
        if (!this.isCourseGrained && this.asc.ac == this.nAtoms) {
            this.asc.removeCurrentAtomSet();
        } else {
            if (!(this.dssr == null && this.validation == null && this.addedData == null || this.isCourseGrained || this.requiresSorting)) {
                MMCifValidationParser vs = ((MMCifValidationParser)this.getInterface("org.jmol.adapter.readers.cif.MMCifValidationParser")).set(this);
                String note = null;
                if (this.addedData == null) {
                    if (this.validation != null || this.dssr != null) {
                        note = vs.finalizeValidations(this.vwr, this.modelMap);
                    }
                } else if (this.addedDataKey.equals("_rna3d")) {
                    note = vs.finalizeRna3d(this.modelMap);
                }
                if (note != null) {
                    this.appendLoadNote(note);
                }
            }
            this.setHetero();
            if (this.doSetBonds) {
                this.setBonds();
            }
        }
        if (this.asc.ac == 0 && !this.isCourseGrained) {
            return false;
        }
        String spaceGroup = this.sgName;
        if (this.htSites != null) {
            this.addSites(this.htSites);
        }
        if (haveBiomolecule) {
            this.asc.setCurrentModelInfo("biomolecules", this.vBiomolecules);
            this.setBiomolecules();
            if (this.thisBiomolecule != null) {
                if (this.iHaveFractionalCoordinates) {
                    this.fractionalizeCoordinates(false);
                }
                this.asc.getXSymmetry().applySymmetryBio(this.thisBiomolecule, this.applySymmetryToBonds, this.filter);
                this.asc.xtalSymmetry = null;
            }
            this.doCheckUnitCell &= this.iHaveUnitCell && this.doApplySymmetry;
            if (this.doCheckUnitCell) {
                this.ignoreFileSpaceGroupName = true;
                this.sgName = spaceGroup;
                this.fractionalizeCoordinates(true);
                this.asc.setModelInfoForSet("biosymmetry", null, this.asc.iSet);
                this.asc.setModelInfoForSet("biosymmetryCount", null, this.asc.iSet);
                this.asc.checkSpecial = false;
                if (this.byChain) {
                    return true;
                }
            }
        }
        if (this.latticeCells != null && this.latticeCells[0] != 0) {
            this.addJmolScript("unitcell;axes on;axes unitcell;");
        }
        if (this.requiresSorting) {
            this.sortAssemblyModels();
        }
        return true;
    }

    @Override
    protected boolean checkSubclassSymmetry() {
        this.asc.checkSpecial = false;
        int modelIndex = this.asc.iSet;
        this.asc.setCurrentModelInfo("PDB_CONECT_firstAtom_count_max", (Object)new int[]{this.asc.getAtomSetAtomIndex(modelIndex), this.asc.getAtomSetAtomCount(modelIndex), this.maxSerial});
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private void setBonds() {
        block12: {
            if (this.htBondMap == null) {
                return;
            }
            bsAtoms = this.asc.bsAtoms;
            if (bsAtoms == null) {
                bsAtoms = BSUtil.newBitSet2((int)0, (int)this.asc.ac);
            }
            atoms = this.asc.atoms;
            seqid = -1.0f;
            comp = null;
            map = null;
            i = bsAtoms.nextSetBit(0);
            while (i >= 0) {
                a = atoms[i];
                v0 = pt = a.vib == null ? (float)a.sequenceNumber : a.vib.x;
                if (pt == seqid) ** GOTO lbl-1000
                seqid = pt;
                if (comp != null) {
                    this.processBonds(this.htBondMap.get(comp), map, false);
                }
                map = new Hashtable<K, V>();
                comp = atoms[i].group3;
                if (!this.htBondMap.containsKey(comp)) {
                    comp = null;
                } else if (comp != null) {
                    map.put(a.atomName, a.index);
                }
                i = bsAtoms.nextSetBit(i + 1);
            }
            if (comp != null) {
                this.processBonds(this.htBondMap.get(comp), map, false);
            }
            if (this.structConnMap == null) break block12;
            map = new Hashtable<Object, Integer>();
            seqid = -1.0f;
            comp = null;
            i = bsAtoms.nextSetBit(0);
            while (i >= 0) {
                a = atoms[i];
                v1 = pt = a.vib == null ? (float)a.sequenceNumber : a.vib.x;
                if (pt == seqid) ** GOTO lbl45
                seqid = pt;
                ckey = a.chainID + a.group3 + seqid;
                if (this.structConnList.indexOf(ckey) < 0) {
                    comp = null;
                } else {
                    comp = ckey;
lbl45:
                    // 2 sources

                    if (comp != null) {
                        map.put(comp + a.atomName + a.altLoc, a.index);
                    }
                }
                i = bsAtoms.nextSetBit(i + 1);
            }
            this.processBonds(this.structConnMap, map, true);
        }
        this.appendLoadNote(this.asc.bondCount + " bonds added");
    }

    private void processBonds(Lst<Object[]> cmap, Map<Object, Integer> map, boolean isStructConn) {
        int n = cmap.size();
        for (int i = 0; i < n; ++i) {
            Integer i2;
            Object[] o = (Object[])cmap.get(i);
            Integer i1 = map.get(o[0]);
            if (i1 == null || (i2 = map.get(o[1])) == null) continue;
            if (this.debugging) {
                Logger.debug((String)((isStructConn ? FAMILY_STRUCTCONN : "_comp_bond") + " adding bond " + i1 + " " + i2 + " order=" + o[2]));
            }
            this.asc.addNewBondWithOrder(i1.intValue(), i2.intValue(), ((Integer)o[2]).intValue());
        }
    }

    private boolean processSequence() throws Exception {
        this.parseLoopParameters(structRefFields);
        while (this.parser.getData()) {
            String g3;
            String g1 = this.getField((byte)1).toLowerCase();
            if (this.isNull(g1) || g1.length() != 1 || this.isNull(g3 = this.getField((byte)0))) continue;
            if (this.htGroup1 == null) {
                this.htGroup1 = new Hashtable();
                this.asc.setInfo("htGroup1", this.htGroup1);
            }
            this.htGroup1.put(g3, g1);
        }
        return true;
    }

    private boolean processAssemblyGenBlock() throws Exception {
        this.parseLoopParameters(assemblyFields);
        while (this.parser.getData()) {
            String[] assem = new String[3];
            int count = 0;
            int n = this.parser.getColumnCount();
            for (int i = 0; i < n; ++i) {
                int p = this.fieldProperty(i);
                switch (p) {
                    case 0: 
                    case 1: 
                    case 2: {
                        ++count;
                        assem[p] = this.field;
                    }
                }
            }
            if (count != 3) continue;
            this.addAssembly(assem);
        }
        return true;
    }

    protected void addAssembly(String[] assem) throws Exception {
        String id = assem[0];
        String list = assem[2];
        String operators = assem[1];
        String name = "biomolecule " + id;
        Logger.info((String)(name + " operators " + operators + " ASYM_IDs " + list));
        this.appendLoadNote("found " + name + ": " + list);
        if (this.vBiomolecules == null) {
            this.vBiomolecules = new Lst();
        }
        Map<String, Object> info = null;
        int i = this.vBiomolecules.size();
        while (--i >= 0) {
            if (!((Map)this.vBiomolecules.get(i)).get("name").equals(name)) continue;
            info = (Map)this.vBiomolecules.get(i);
            break;
        }
        if (info == null) {
            info = new Hashtable<String, String>();
            info.put("name", name);
            int iMolecule = this.parseIntStr(id);
            info.put("molecule", iMolecule == Integer.MIN_VALUE ? id : Integer.valueOf(iMolecule));
            info.put("biomts", new Lst());
            info.put("chains", new Lst());
            info.put("assemblies", new Lst());
            info.put("operators", new Lst());
            this.vBiomolecules.addLast(info);
        }
        ((Lst)info.get("assemblies")).addLast((Object)("$" + list.replace(',', '$')));
        ((Lst)info.get("operators")).addLast((Object)this.decodeAssemblyOperators(operators));
        this.checkFilterAssembly(id, info);
    }

    protected void checkFilterAssembly(String id, Map<String, Object> info) {
        if (this.checkFilterKey("ASSEMBLY " + id + ";") || this.checkFilterKey("ASSEMBLY=" + id + ";")) {
            this.thisBiomolecule = info;
        }
    }

    private String decodeAssemblyOperators(String ops) {
        int pt = ops.indexOf(")(");
        if (pt >= 0) {
            return this.crossBinary(this.decodeAssemblyOperators(ops.substring(0, pt + 1)), this.decodeAssemblyOperators(ops.substring(pt + 1)));
        }
        if (ops.startsWith("(")) {
            if (ops.indexOf("-") >= 0) {
                ops = BS.unescape((String)("({" + ops.substring(1, ops.length() - 1).replace('-', ':').replace(',', ' ') + "})")).toJSON();
            }
            ops = PT.rep((String)ops, (String)" ", (String)"");
            ops = ops.substring(1, ops.length() - 1);
        }
        return ops;
    }

    private String crossBinary(String ops1, String ops2) {
        SB sb = new SB();
        String[] opsLeft = PT.split((String)ops1, (String)",");
        String[] opsRight = PT.split((String)ops2, (String)",");
        for (int i = 0; i < opsLeft.length; ++i) {
            for (int j = 0; j < opsRight.length; ++j) {
                sb.append(",").append(opsLeft[i]).append("|").append(opsRight[j]);
            }
        }
        return sb.toString().substring(1);
    }

    private boolean processStructOperListBlock(boolean isNCS) throws Exception {
        this.parseLoopParametersFor(isNCS ? FAMILY_NCS : FAMILY_OPER, isNCS ? ncsoperFields : operFields);
        float[] m = new float[16];
        m[15] = 1.0f;
        while (this.parser.getData()) {
            int count = 0;
            String id = null;
            String xyz = null;
            int n = this.parser.getColumnCount();
            block6: for (int i = 0; i < n; ++i) {
                int p = this.fieldProperty(i);
                switch (p) {
                    case -1: {
                        continue block6;
                    }
                    case 12: {
                        id = this.field;
                        continue block6;
                    }
                    case 13: {
                        xyz = this.field;
                        continue block6;
                    }
                    default: {
                        m[p] = this.parseFloatStr(this.field);
                        ++count;
                    }
                }
            }
            if (id == null || count != 12 && (xyz == null || this.symmetry == null)) continue;
            Logger.info((String)((isNCS ? "noncrystallographic symmetry operator " : "assembly operator ") + id + " " + xyz));
            M4 m4 = new M4();
            if (count != 12) {
                this.symmetry.getMatrixFromString(xyz, m, false, 0);
                m[3] = m[3] * (this.symmetry.getUnitCellInfoType(0) / 12.0f);
                m[7] = m[7] * (this.symmetry.getUnitCellInfoType(1) / 12.0f);
                m[11] = m[11] * (this.symmetry.getUnitCellInfoType(2) / 12.0f);
            }
            m4.setA(m);
            this.addMatrix(id, m4, isNCS);
        }
        return true;
    }

    protected void addMatrix(String id, M4 m4, boolean isNCS) {
        if (isNCS) {
            if (m4.equals((Object)this.mident)) {
                return;
            }
            m4.m33 = 0.0f;
            if (this.lstNCS == null) {
                this.lstNCS = new Lst();
            }
            this.lstNCS.addLast((Object)m4);
        } else {
            if (this.htBiomts == null) {
                this.htBiomts = new Hashtable<String, M4>();
            }
            this.htBiomts.put(id, m4);
        }
    }

    private boolean processChemCompLoopBlock() throws Exception {
        this.parseLoopParameters(chemCompFields);
        while (this.parser.getData()) {
            String hetName;
            String groupName = this.getField((byte)0);
            if (this.isNull(groupName) || this.isNull(hetName = this.getField((byte)1))) continue;
            this.addHetero(groupName, hetName, true, true);
        }
        return true;
    }

    protected void addHetero(String groupName, String hetName, boolean doCheck, boolean addNote) {
        if (doCheck && !this.vwr.getJBR().isHetero(groupName)) {
            return;
        }
        if (this.htHetero == null) {
            this.htHetero = new Hashtable<String, String>();
        }
        if (doCheck && this.htHetero.containsKey(groupName)) {
            return;
        }
        this.htHetero.put(groupName, hetName);
        if (addNote) {
            this.appendLoadNote(groupName + " = " + hetName);
        }
    }

    private boolean processStructConfLoopBlock() throws Exception {
        if (this.ignoreStructure) {
            this.parser.skipLoop(false);
            return false;
        }
        this.parseLoopParametersFor(FAMILY_STRUCTCONF, structConfFields);
        if (!this.checkAllFieldsPresent(structConfFields, -1, true)) {
            this.parser.skipLoop(true);
            return false;
        }
        while (this.parser.getData()) {
            Structure structure = new Structure(-1, STR.HELIX, STR.HELIX, null, 0, 0, null);
            String type = this.getField((byte)0);
            if (type.startsWith("TURN")) {
                structure.structureType = structure.substructureType = STR.TURN;
            } else if (!type.startsWith("HELX")) {
                structure.structureType = structure.substructureType = STR.NONE;
            } else {
                structure.substructureType = Structure.getHelixType((int)this.parseIntStr(this.getField((byte)9)));
            }
            structure.serialID = this.parseIntStr(this.getField((byte)8));
            structure.structureID = this.getField((byte)7);
            this.addStructure(structure);
        }
        return true;
    }

    private void addStructure(Structure structure) {
        structure.startChainStr = this.getField((byte)1);
        structure.startChainID = this.vwr.getChainID(structure.startChainStr, true);
        structure.startSequenceNumber = this.parseIntStr(this.getField((byte)2));
        structure.startInsertionCode = this.getField((byte)3).charAt(0);
        structure.endChainStr = this.getField((byte)4);
        structure.endChainID = this.vwr.getChainID(structure.endChainStr, true);
        structure.endSequenceNumber = this.parseIntStr(this.getField((byte)5));
        structure.endInsertionCode = this.getField((byte)6).charAt(0);
        this.asc.addStructure(structure);
    }

    private boolean processStructSheetRangeLoopBlock() throws Exception {
        if (this.ignoreStructure) {
            this.parser.skipLoop(false);
            return false;
        }
        this.parseLoopParametersFor(FAMILY_SHEET, structSheetRangeFields);
        if (!this.checkAllFieldsPresent(structSheetRangeFields, -1, true)) {
            this.parser.skipLoop(true);
            return false;
        }
        while (this.parser.getData()) {
            this.addStructure(new Structure(-1, STR.SHEET, STR.SHEET, this.getField((byte)0), this.parseIntStr(this.getField((byte)7)), 1, null));
        }
        return true;
    }

    private boolean processStructSiteBlock() throws Exception {
        this.parseLoopParametersFor(FAMILY_STRUCSITE, structSiteFields);
        Map<String, Object> htSite = null;
        this.htSites = new Hashtable<String, Map<String, Object>>();
        while (this.parser.getData()) {
            String resID;
            String seqNum = this.getField((byte)3);
            if (this.isNull(seqNum) || this.isNull(resID = this.getField((byte)1))) continue;
            String siteID = this.getField((byte)0);
            htSite = this.htSites.get(siteID);
            if (htSite == null) {
                htSite = new Hashtable<String, Object>();
                htSite.put("groups", "");
                this.htSites.put(siteID, htSite);
            }
            String insCode = this.getField((byte)4);
            String chainID = this.getField((byte)2);
            String group = "[" + resID + "]" + seqNum + (this.isNull(insCode) ? "" : "^" + insCode) + (this.isNull(chainID) ? "" : ":" + chainID);
            String groups = (String)htSite.get("groups");
            groups = groups + (groups.length() == 0 ? "" : ",") + group;
            htSite.put("groups", groups);
        }
        return true;
    }

    private void setBiomolecules() {
        if (this.assemblyIdAtoms == null && this.chainAtomCounts == null) {
            return;
        }
        BS bsAll = new BS();
        int i = this.vBiomolecules.size();
        while (--i >= 0) {
            Map biomolecule;
            this.setBiomolecule(biomolecule, (BS)((biomolecule = (Map)this.vBiomolecules.get(i)) == this.thisBiomolecule ? bsAll : null));
        }
        if (this.isBiomolecule && bsAll.cardinality() < this.asc.ac) {
            if (this.asc.bsAtoms != null) {
                this.asc.bsAtoms.and(bsAll);
            } else if (!this.isCourseGrained) {
                this.asc.bsAtoms = bsAll;
            }
        }
    }

    private int setBiomolecule(Map<String, Object> biomolecule, BS bsAll) {
        Lst biomtchains = (Lst)biomolecule.get("chains");
        Lst biomts = (Lst)biomolecule.get("biomts");
        Lst operators = (Lst)biomolecule.get("operators");
        Lst assemblies = (Lst)biomolecule.get("assemblies");
        P3 sum = new P3();
        int count = 0;
        BS bsAtoms = new BS();
        int nAtomsTotal = 0;
        boolean isBioCourse = this.isBiomolecule && this.isCourseGrained;
        int i = operators.size();
        while (--i >= 0) {
            int j;
            String[] ops = PT.split((String)((String)operators.get(i)), (String)",");
            String[] ids = PT.split((String)((String)assemblies.get(i)), (String)"$");
            String chainlist = "";
            int nAtoms = 0;
            for (j = 1; j < ids.length; ++j) {
                P3 asum;
                String id = ids[j];
                chainlist = chainlist + ":" + id + ";";
                if (this.assemblyIdAtoms != null) {
                    biomolecule.put("asemblyIdAtoms", this.assemblyIdAtoms);
                    BS bs = this.assemblyIdAtoms.get(id);
                    if (bs == null) continue;
                    bsAtoms.or(bs);
                    if (bsAll != null) {
                        bsAll.or(bs);
                    }
                    nAtoms += bs.cardinality();
                    continue;
                }
                if (!isBioCourse || (asum = this.chainAtomMap.get(id)) == null) continue;
                if (this.bySymop) {
                    sum.add((T3)asum);
                    count += this.chainAtomCounts.get(id)[0];
                    continue;
                }
                this.createParticle(id);
                ++nAtoms;
            }
            if (!this.isBiomolecule) continue;
            for (j = 0; j < ops.length; ++j) {
                M4 m = this.getOpMatrix(ops[j]);
                if (m == null) {
                    return 0;
                }
                if (m.equals((Object)this.mident)) {
                    biomts.add(0, (Object)this.mident);
                    biomtchains.add(0, (Object)chainlist);
                    continue;
                }
                biomts.addLast((Object)m);
                biomtchains.addLast((Object)chainlist);
            }
            if (this.bySymop && bsAll != null) {
                nAtoms = 1;
                Atom a1 = new Atom();
                a1.setT((T3)sum);
                a1.scale(1.0f / (float)count);
                a1.radius = 16.0f;
                this.asc.addAtom(a1);
            }
            nAtomsTotal += (nAtoms *= ops.length);
        }
        biomolecule.put("atomCount", nAtomsTotal);
        return nAtomsTotal;
    }

    private void createParticle(String id) {
        P3 asum = this.chainAtomMap.get(id);
        int c = this.chainAtomCounts.get(id)[0];
        Atom a = new Atom();
        a.setT((T3)asum);
        a.scale(1.0f / (float)c);
        a.elementSymbol = "Pt";
        this.setChainID(a, id);
        a.radius = 16.0f;
        this.asc.addAtom(a);
    }

    private M4 getOpMatrix(String ops) {
        if (this.htBiomts == null) {
            return M4.newM4(null);
        }
        int pt = ops.indexOf("|");
        if (pt >= 0) {
            M4 m = M4.newM4((M4)this.htBiomts.get(ops.substring(0, pt)));
            m.mul(this.htBiomts.get(ops.substring(pt + 1)));
            return m;
        }
        return this.htBiomts.get(ops);
    }

    private boolean processStructConnLoopBlock() throws Exception {
        this.parseLoopParametersFor(FAMILY_STRUCTCONN, structConnFields);
        while (this.parser.getData()) {
            String type;
            String sym2;
            String sym1 = this.getField((byte)5);
            if (!sym1.equals(sym2 = this.getField((byte)11)) || !this.isNull(sym1) && !sym1.equals("1_555") || !(type = this.getField((byte)12)).startsWith("covale") && !type.equals("disulf") && !type.equals("metalc")) continue;
            if (this.htBondMap == null) {
                this.htBondMap = new Hashtable<String, Lst<Object[]>>();
            }
            String key1 = this.vwr.getChainID(this.getField((byte)0), true) + this.getField((byte)2) + this.parseFloatStr(this.getField((byte)1)) + this.getField((byte)3) + this.getField((byte)4);
            String key2 = this.vwr.getChainID(this.getField((byte)6), true) + this.getField((byte)8) + this.parseFloatStr(this.getField((byte)7)) + this.getField((byte)9) + this.getField((byte)10);
            int order = this.getBondOrder(this.getField((byte)13));
            if (this.structConnMap == null) {
                this.structConnMap = new Lst();
            }
            this.structConnMap.addLast((Object)new Object[]{key1, key2, order});
            if (this.structConnList.indexOf(key1) < 0) {
                this.structConnList = this.structConnList + key1;
            }
            if (this.structConnList.indexOf(key2) >= 0) continue;
            this.structConnList = this.structConnList + key2;
        }
        return true;
    }

    private boolean processCompBondLoopBlock() throws Exception {
        this.doSetBonds = true;
        this.parseLoopParametersFor(FAMILY_COMPBOND, chemCompBondFields);
        while (this.parser.getData()) {
            Lst cmap;
            String comp = this.getField((byte)0);
            String atom1 = this.getField((byte)1);
            String atom2 = this.getField((byte)2);
            int order = this.getBondOrder(this.getField((byte)3));
            if (this.getField((byte)4).charAt(0) == 'Y') {
                switch (order) {
                    case 1: {
                        order = 513;
                        break;
                    }
                    case 2: {
                        order = 514;
                    }
                }
            }
            if (this.isLigand) {
                this.asc.addNewBondWithOrderA(this.asc.getAtomFromName(atom1), this.asc.getAtomFromName(atom2), order);
                continue;
            }
            if (!this.haveHAtoms && (this.htHetero == null || !this.htHetero.containsKey(comp))) continue;
            if (this.htBondMap == null) {
                this.htBondMap = new Hashtable<String, Lst<Object[]>>();
            }
            if ((cmap = this.htBondMap.get(comp)) == null) {
                cmap = new Lst();
                this.htBondMap.put(comp, (Lst<Object[]>)cmap);
            }
            cmap.addLast((Object)new Object[]{atom1, atom2, this.haveHAtoms ? order : 1});
        }
        return true;
    }

    @Override
    public boolean processSubclassAtom(Atom atom, String assemblyId, String strChain) {
        if (this.isBiomolecule) {
            if (this.isCourseGrained) {
                P3 sum = this.chainAtomMap.get(assemblyId);
                if (sum == null) {
                    sum = new P3();
                    this.chainAtomMap.put(assemblyId, sum);
                    this.chainAtomCounts.put(assemblyId, new int[1]);
                }
                int[] nArray = this.chainAtomCounts.get(assemblyId);
                nArray[0] = nArray[0] + 1;
                sum.add((T3)atom);
                return false;
            }
        } else if (this.byChain) {
            if (this.thisChain != atom.chainID) {
                this.thisChain = atom.chainID;
                this.chainSum = this.chainAtomMap.get(strChain);
                if (this.chainSum == null) {
                    this.chainSum = new P3();
                    this.chainAtomMap.put(strChain, this.chainSum);
                    this.chainAtomCount = new int[1];
                    this.chainAtomCounts.put(strChain, this.chainAtomCount);
                }
            }
            this.chainSum.add((T3)atom);
            this.chainAtomCount[0] = this.chainAtomCount[0] + 1;
            return false;
        }
        if (assemblyId != null) {
            BS bs;
            if (this.assemblyIdAtoms == null) {
                this.assemblyIdAtoms = new Hashtable<String, BS>();
            }
            if ((bs = this.assemblyIdAtoms.get(assemblyId)) == null) {
                bs = new BS();
                this.assemblyIdAtoms.put(assemblyId, bs);
            }
            bs.set(this.ac);
        }
        return true;
    }

    @Override
    protected int checkPDBModelField(int modelField, int currentModelNo) throws Exception {
        this.fieldProperty(modelField);
        int modelNo = this.parseIntStr(this.field);
        return modelNo == currentModelNo ? modelNo : this.incrementModel(modelNo);
    }

    protected int incrementModel(int modelNo) throws Exception {
        boolean isAssembly;
        boolean bl = isAssembly = this.thisDataSetName != null && this.thisDataSetName.indexOf("-assembly-") >= 0;
        if (isAssembly) {
            this.useFileModelNumbers = true;
            String key = "," + modelNo + ",";
            if (this.modelStrings.indexOf(key) >= 0) {
                this.requiresSorting = true;
            } else {
                this.modelStrings = this.modelStrings + key;
            }
        }
        if (this.iHaveDesiredModel && this.asc.atomSetCount > 0 && !isAssembly) {
            this.done = true;
            if (this.parser != null) {
                this.parser.skipLoop(false);
                this.skipping = false;
            }
            this.continuing = true;
            return Integer.MIN_VALUE;
        }
        int modelNumberToUse = this.useFileModelNumbers ? modelNo : (this.modelIndex = this.modelIndex + 1);
        this.setHetero();
        this.newModel(modelNumberToUse);
        if (!this.skipping) {
            this.nextAtomSet();
            if (this.modelMap == null || this.asc.ac == 0) {
                this.modelMap = new Hashtable();
            }
            this.modelMap.put("" + modelNo, Math.max(0, this.asc.iSet));
            this.modelMap.put("_" + Math.max(0, this.asc.iSet), modelNo);
        }
        return modelNo;
    }

    private void setHetero() {
        if (this.htHetero != null) {
            this.asc.setCurrentModelInfo("hetNames", this.htHetero);
            this.asc.setInfo("hetNames", this.htHetero);
        }
    }
}

