/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import javajs.awt.Font;
import org.jmol.api.JmolRendererInterface;
import org.jmol.modelset.Text;

class TextRenderer {
    TextRenderer() {
    }

    static boolean render(Text text, JmolRendererInterface g3d, float scalePixelsPerMicron, float imageFontScaling, boolean isAbsolute, float[] boxXY, float[] temp) {
        if (text == null || text.image == null && !text.doFormatText && text.lines == null) {
            return false;
        }
        boolean showText = g3d.setC(text.colix);
        if (!(showText || text.image != null || text.bgcolix != 0 && g3d.setC(text.bgcolix))) {
            return false;
        }
        text.setPosition(scalePixelsPerMicron, imageFontScaling, isAbsolute, boxXY);
        if (text.image == null && text.bgcolix != 0) {
            if (g3d.setC(text.bgcolix)) {
                TextRenderer.showBox(g3d, text.colix, (int)text.boxX, (int)text.boxY + text.boxYoff2 * 2, text.z + 2, text.zSlab, (int)text.boxWidth, (int)text.boxHeight, text.fontScale, text.isLabelOrHover);
            }
            if (!showText) {
                return false;
            }
        }
        if (text.image == null) {
            for (int i = 0; i < text.lines.length; ++i) {
                text.setXYA(temp, i);
                g3d.drawString(text.lines[i], text.font, (int)temp[0], (int)temp[1], text.z, text.zSlab, text.bgcolix);
            }
        } else {
            g3d.drawImage(text.image, (int)text.boxX, (int)text.boxY, text.z, text.zSlab, text.bgcolix, (int)text.boxWidth, (int)text.boxHeight);
        }
        if ((text.pointer & 1) == 0 || !g3d.setC((text.pointer & 2) != 0 && text.bgcolix != 0 ? text.bgcolix : text.colix)) {
            return true;
        }
        float w = text.boxWidth;
        float h = text.boxHeight;
        float pt = Float.NaN;
        float x = text.boxX + (text.boxX > (float)text.atomX + w ? 0.0f : (text.boxX + w < (float)text.atomX - w ? w : (pt = w / 2.0f)));
        boolean setY = !Float.isNaN(pt);
        float y = text.boxY + (setY && text.boxY > (float)text.atomY ? 0.0f : (setY && text.boxY + h < (float)text.atomY ? h : h / 2.0f));
        g3d.drawLineXYZ(text.atomX, text.atomY, text.atomZ, (int)x, (int)y, text.zSlab);
        return true;
    }

    static void renderSimpleLabel(JmolRendererInterface g3d, Font font, String strLabel, short colix, short bgcolix, float[] boxXY, int z, int zSlab, int xOffset, int yOffset, float ascent, int descent, boolean doPointer, short pointerColix, boolean isAbsolute) {
        float boxWidth = font.stringWidth(strLabel) + 8;
        float boxHeight = ascent + (float)descent + 8.0f;
        int x0 = (int)boxXY[0];
        int y0 = (int)boxXY[1];
        Text.setBoxXY(boxWidth, boxHeight, xOffset, yOffset, boxXY, isAbsolute);
        float x = boxXY[0];
        float y = boxXY[1];
        if (bgcolix != 0 && g3d.setC(bgcolix)) {
            TextRenderer.showBox(g3d, colix, (int)x, (int)y, z, zSlab, (int)boxWidth, (int)boxHeight, 1.0f, true);
        } else {
            g3d.setC(colix);
        }
        g3d.drawString(strLabel, font, (int)(x + 4.0f), (int)(y + 4.0f + ascent), z - 1, zSlab, bgcolix);
        if (doPointer) {
            g3d.setC(pointerColix);
            if (xOffset > 0) {
                g3d.drawLineXYZ(x0, y0, zSlab, (int)x, (int)(y + boxHeight / 2.0f), zSlab);
            } else if (xOffset < 0) {
                g3d.drawLineXYZ(x0, y0, zSlab, (int)(x + boxWidth), (int)(y + boxHeight / 2.0f), zSlab);
            }
        }
    }

    private static void showBox(JmolRendererInterface g3d, short colix, int x, int y, int z, int zSlab, int boxWidth, int boxHeight, float imageFontScaling, boolean atomBased) {
        g3d.fillTextRect(x, y, z, zSlab, boxWidth, boxHeight);
        g3d.setC(colix);
        if (!atomBased) {
            return;
        }
        if (imageFontScaling >= 2.0f) {
            g3d.drawRect(x + 3, y + 3, z - 1, zSlab, boxWidth - 6, boxHeight - 6);
        } else {
            g3d.drawRect(x + 1, y + 1, z - 1, zSlab, boxWidth - 2, boxHeight - 2);
        }
    }
}

