/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.data;

import java.util.Map;
import javajs.J2SIgnoreImport;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.XmlUtil;
import org.jmol.api.Interface;
import org.jmol.java.BS;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

@J2SIgnoreImport(value={XmlUtil.class})
public class JvxlCoder {
    public static final String JVXL_VERSION1 = "2.0";
    public static final String JVXL_VERSION_XML = "2.3";
    private static boolean haveXMLUtil;
    public static final int CONTOUR_NPOLYGONS = 0;
    public static final int CONTOUR_BITSET = 1;
    public static final int CONTOUR_VALUE = 2;
    public static final int CONTOUR_COLIX = 3;
    public static final int CONTOUR_COLOR = 4;
    public static final int CONTOUR_FDATA = 5;
    public static final int CONTOUR_POINTS = 6;
    public static final int defaultEdgeFractionBase = 35;
    public static final int defaultEdgeFractionRange = 90;
    public static final int defaultColorFractionBase = 35;
    public static final int defaultColorFractionRange = 90;

    public static String jvxlGetFile(VolumeData volumeData, JvxlData jvxlData, String[] title) {
        int[] counts = volumeData.getVoxelCounts();
        jvxlData.nPointsX = counts[0];
        jvxlData.nPointsY = counts[1];
        jvxlData.nPointsZ = counts[2];
        jvxlData.jvxlVolumeDataXml = volumeData.setVolumetricXml();
        return JvxlCoder.jvxlGetFileVwr(null, jvxlData, null, title, null, true, 1, null, null);
    }

    public static String jvxlGetFileVwr(Viewer vwr, JvxlData jvxlData, MeshData meshData, String[] title, String msg, boolean includeHeader, int nSurfaces, String state, String comment) {
        String[] stringArray;
        SB sb;
        String type;
        if (!haveXMLUtil) {
            if (vwr.isJS) {
                Interface.getInterface((String)"javajs.util.XmlUtil", (Viewer)vwr, (String)"show");
            }
            haveXMLUtil = true;
        }
        SB data = new SB();
        if ("TRAILERONLY".equals(msg)) {
            XmlUtil.closeTag((SB)data, (String)"jvxlSurfaceSet");
            XmlUtil.closeTag((SB)data, (String)"jvxl");
            return data.toString();
        }
        boolean vertexDataOnly = meshData != null;
        boolean isHeaderOnly = "HEADERONLY".equals(msg);
        if (includeHeader) {
            String volumeDataXml;
            XmlUtil.openDocument((SB)data);
            XmlUtil.openTagAttr((SB)data, (String)"jvxl", (Object[])new String[]{"version", JVXL_VERSION_XML, "jmolVersion", jvxlData.version, "xmlns", "http://jmol.org/jvxl_schema", "xmlns:cml", "http://www.xml-cml.org/schema"});
            if (jvxlData.jvxlFileTitle != null) {
                XmlUtil.appendCdata((SB)data, (String)"jvxlFileTitle", null, (String)("\n" + jvxlData.jvxlFileTitle));
            }
            if (jvxlData.moleculeXml != null) {
                data.append(jvxlData.moleculeXml);
            }
            String string = volumeDataXml = vertexDataOnly ? null : jvxlData.jvxlVolumeDataXml;
            if (volumeDataXml == null) {
                volumeDataXml = new VolumeData().setVolumetricXml();
            }
            data.append(volumeDataXml);
            XmlUtil.openTagAttr((SB)data, (String)"jvxlSurfaceSet", (Object[])new String[]{"count", "" + (nSurfaces > 0 ? nSurfaces : 1)});
            if (isHeaderOnly) {
                return data.toString();
            }
        }
        String string = vertexDataOnly ? "pmesh" : (type = jvxlData.jvxlPlane == null ? "isosurface" : "plane");
        if (jvxlData.jvxlColorData != null && jvxlData.jvxlColorData.length() > 0) {
            type = "mapped " + type;
        }
        XmlUtil.openTagAttr((SB)data, (String)"jvxlSurface", (Object[])new String[]{"type", type});
        data.append(JvxlCoder.jvxlGetInfoData(jvxlData, vertexDataOnly));
        JvxlCoder.jvxlAppendCommandState(data, comment, state);
        if (title != null || msg != null && msg.length() > 0) {
            sb = new SB();
            if (msg != null && msg.length() > 0) {
                sb.append(msg).append("\n");
            }
            if (title != null) {
                for (int i = 0; i < title.length; ++i) {
                    sb.append(title[i]).appendC('\n');
                }
            }
            XmlUtil.appendCdata((SB)data, (String)"jvxlSurfaceTitle", null, (String)sb.toString());
        }
        sb = new SB();
        if (vertexDataOnly || jvxlData.jvxlPlane == null) {
            stringArray = null;
        } else if (jvxlData.mapLattice == null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "plane";
            stringArray = stringArray2;
            stringArray2[1] = Escape.eP4((P4)jvxlData.jvxlPlane);
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = "plane";
            stringArray3[1] = Escape.eP4((P4)jvxlData.jvxlPlane);
            stringArray3[2] = "maplattice";
            stringArray = stringArray3;
            stringArray3[3] = Escape.eP((T3)jvxlData.mapLattice);
        }
        XmlUtil.openTagAttr((SB)sb, (String)"jvxlSurfaceData", stringArray);
        if (vertexDataOnly) {
            JvxlCoder.appendXmlVertexOnlyData(sb, jvxlData, meshData, true);
        } else if (jvxlData.jvxlPlane == null) {
            if (jvxlData.jvxlEdgeData == null) {
                return "";
            }
            JvxlCoder.appendXmlEdgeData(sb, jvxlData);
            JvxlCoder.appendXmlColorData(sb, jvxlData.jvxlColorData, true, jvxlData.isJvxlPrecisionColor, jvxlData.valueMappedToRed, jvxlData.valueMappedToBlue);
        } else {
            JvxlCoder.appendXmlColorData(sb, jvxlData.jvxlColorData, true, jvxlData.isJvxlPrecisionColor, jvxlData.valueMappedToRed, jvxlData.valueMappedToBlue);
        }
        JvxlCoder.appendEncodedBitSetTag(sb, "jvxlInvalidatedVertexData", jvxlData.jvxlExcluded[1], -1, null);
        if (jvxlData.excludedVertexCount > 0) {
            JvxlCoder.appendEncodedBitSetTag(sb, "jvxlExcludedVertexData", jvxlData.jvxlExcluded[0], jvxlData.excludedVertexCount, null);
            JvxlCoder.appendEncodedBitSetTag(sb, "jvxlExcludedPlaneData", jvxlData.jvxlExcluded[2], -1, null);
        }
        JvxlCoder.appendEncodedBitSetTag(sb, "jvxlExcludedTriangleData", jvxlData.jvxlExcluded[3], jvxlData.excludedTriangleCount, null);
        XmlUtil.closeTag((SB)sb, (String)"jvxlSurfaceData");
        int len = sb.length();
        data.appendSB(sb);
        if (jvxlData.vContours != null && jvxlData.vContours.length > 0) {
            JvxlCoder.jvxlEncodeContourData(jvxlData.vContours, data);
        }
        if (jvxlData.vertexColorMap != null) {
            if (jvxlData.baseColor == null) {
                XmlUtil.openTag((SB)data, (String)"jvxlVertexColorData");
            } else {
                XmlUtil.openTagAttr((SB)data, (String)"jvxlVertexColorData", (Object[])new String[]{"baseColor", jvxlData.baseColor});
            }
            for (Map.Entry<String, BS> entry : jvxlData.vertexColorMap.entrySet()) {
                JvxlCoder.appendEncodedBitSetTag(data, "jvxlColorMap", entry.getValue(), -1, new Object[]{"color", entry.getKey()});
            }
            jvxlData.vertexColorMap = null;
            XmlUtil.closeTag((SB)data, (String)"jvxlVertexColorData");
        }
        XmlUtil.closeTag((SB)data, (String)"jvxlSurface");
        if (includeHeader) {
            XmlUtil.closeTag((SB)data, (String)"jvxlSurfaceSet");
            XmlUtil.closeTag((SB)data, (String)"jvxl");
        }
        return JvxlCoder.jvxlSetCompressionRatio(data, jvxlData, len);
    }

    private static void appendEncodedBitSetTag(SB sb, String name, BS bs, int count, Object[] attribs) {
        if (count < 0) {
            count = BSUtil.cardinalityOf((BS)bs);
        }
        if (count == 0) {
            return;
        }
        SB sb1 = new SB();
        sb1.append("\n ");
        JvxlCoder.jvxlEncodeBitSetBuffer(bs, -1, sb1);
        XmlUtil.appendTagObj((SB)sb, (String)name, (Object[])new Object[]{attribs, "bsEncoding", "base90+35", "count", "" + count, "len", "" + bs.length()}, (Object)JvxlCoder.jvxlCompressString(sb1.toString(), true));
    }

    private static String jvxlSetCompressionRatio(SB data, JvxlData jvxlData, int len) {
        String s = data.toString();
        int r = (int)(jvxlData.nBytes > 0L ? (float)jvxlData.nBytes / (float)len : (float)(jvxlData.nPointsX * jvxlData.nPointsY * jvxlData.nPointsZ * 13) / (float)len);
        return PT.rep((String)s, (String)"\"not calculated\"", (String)(r > 0 ? "\"" + r + ":1\"" : "\"?\""));
    }

    private static void appendXmlEdgeData(SB sb, JvxlData jvxlData) {
        XmlUtil.appendTagObj((SB)sb, (String)"jvxlEdgeData", (Object[])new String[]{"count", "" + (jvxlData.jvxlEdgeData.length() - 1), "encoding", "base90f1", "bsEncoding", "base90+35c", "isXLowToHigh", "" + jvxlData.isXLowToHigh, "data", JvxlCoder.jvxlCompressString(jvxlData.jvxlEdgeData, true)}, (Object)("\n" + JvxlCoder.jvxlCompressString(jvxlData.jvxlSurfaceData, true)));
    }

    private static void jvxlAppendCommandState(SB data, String cmd, String state) {
        if (cmd != null) {
            XmlUtil.appendCdata((SB)data, (String)"jvxlIsosurfaceCommand", null, (String)("\n" + (cmd.indexOf("#") < 0 ? cmd : cmd.substring(0, cmd.indexOf("#"))) + "\n"));
        }
        if (state != null) {
            if (state.indexOf("** XML ** ") >= 0) {
                state = PT.split((String)state, (String)"** XML **")[1].trim();
                XmlUtil.appendTag((SB)data, (String)"jvxlIsosurfaceState", (Object)("\n" + state + "\n"));
            } else {
                XmlUtil.appendCdata((SB)data, (String)"jvxlIsosurfaceState", null, (String)("\n" + state));
            }
        }
    }

    private static void appendXmlColorData(SB sb, String data, boolean isEncoded, boolean isPrecisionColor, float value1, float value2) {
        int n;
        if (data == null || (n = data.length() - 1) < 0) {
            return;
        }
        if (isPrecisionColor) {
            n /= 2;
        }
        XmlUtil.appendTagObj((SB)sb, (String)"jvxlColorData", (Object[])new String[]{"count", "" + n, "encoding", isEncoded ? "base90f" + (isPrecisionColor ? "2" : "1") : "none", "min", "" + value1, "max", "" + value2, "data", JvxlCoder.jvxlCompressString(data, true)}, null);
    }

    public static String jvxlGetInfo(JvxlData jvxlData) {
        return JvxlCoder.jvxlGetInfoData(jvxlData, jvxlData.vertexDataOnly);
    }

    public static String jvxlGetInfoData(JvxlData jvxlData, boolean vertexDataOnly) {
        float red;
        int n;
        if (jvxlData.jvxlSurfaceData == null) {
            return "";
        }
        Lst attribs = new Lst();
        int nSurfaceInts = jvxlData.nSurfaceInts;
        int bytesUncompressedEdgeData = vertexDataOnly ? 0 : jvxlData.jvxlEdgeData.length() - 1;
        int nColorData = jvxlData.jvxlColorData == null ? -1 : jvxlData.jvxlColorData.length() - 1;
        JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  isModelConnected", "" + jvxlData.isModelConnected);
        if (!vertexDataOnly) {
            JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  cutoff", "" + jvxlData.cutoff);
            JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  isCutoffAbsolute", "" + jvxlData.isCutoffAbsolute);
            JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  pointsPerAngstrom", "" + jvxlData.pointsPerAngstrom);
            n = jvxlData.jvxlSurfaceData.length() + bytesUncompressedEdgeData + nColorData + 1;
            if (n > 0) {
                JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  nBytesData", "" + n);
            }
            JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  isXLowToHigh", "" + jvxlData.isXLowToHigh);
            if (jvxlData.jvxlPlane == null) {
                JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  nSurfaceInts", "" + nSurfaceInts);
                JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  nBytesUncompressedEdgeData", "" + bytesUncompressedEdgeData);
            }
            if (nColorData > 0) {
                JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  nBytesUncompressedColorData", "" + nColorData);
            }
        }
        jvxlData.excludedVertexCount = BSUtil.cardinalityOf((BS)jvxlData.jvxlExcluded[0]);
        jvxlData.excludedTriangleCount = BSUtil.cardinalityOf((BS)jvxlData.jvxlExcluded[3]);
        if (jvxlData.excludedVertexCount > 0) {
            JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  nExcludedVertexes", "" + jvxlData.excludedVertexCount);
        }
        if (jvxlData.excludedTriangleCount > 0) {
            JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  nExcludedTriangles", "" + jvxlData.excludedTriangleCount);
        }
        if ((n = BSUtil.cardinalityOf((BS)jvxlData.jvxlExcluded[1])) > 0) {
            JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  nInvalidatedVertexes", "" + n);
        }
        if (jvxlData.slabInfo != null) {
            JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  slabInfo", jvxlData.slabInfo);
        }
        if (jvxlData.isJvxlPrecisionColor) {
            JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  precisionColor", "true");
        }
        if (jvxlData.colorDensity) {
            JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  colorDensity", "true");
        }
        if (!Float.isNaN(jvxlData.pointSize)) {
            JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  pointSize", "" + jvxlData.pointSize);
        } else if (jvxlData.diameter != 0) {
            JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  diameter", "" + jvxlData.diameter);
        }
        if (!jvxlData.allowVolumeRender) {
            JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  allowVolumeRender", "false");
        }
        if (jvxlData.jvxlPlane == null || vertexDataOnly) {
            if (jvxlData.fixedLattice != null && !vertexDataOnly) {
                JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  fixedLattice", "" + jvxlData.fixedLattice);
            }
            if (jvxlData.isContoured) {
                JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  contoured", "true");
                JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  colorMapped", "true");
            } else if (jvxlData.isBicolorMap) {
                JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  bicolorMap", "true");
                JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  colorNegative", C.getHexCode((short)jvxlData.minColorIndex));
                JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  colorPositive", C.getHexCode((short)jvxlData.maxColorIndex));
            } else if (nColorData > 0) {
                JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  colorMapped", "true");
            }
            if (jvxlData.vContours != null && jvxlData.vContours.length > 0) {
                JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  nContourData", "" + jvxlData.vContours.length);
            }
        } else {
            if (jvxlData.mapLattice != null) {
                JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  mapLattice", "" + jvxlData.mapLattice);
            }
            if (jvxlData.scale3d != 0.0f) {
                JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  scale3d", "" + jvxlData.scale3d);
            }
            if (nColorData > 0) {
                JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  colorMapped", "true");
            }
            JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  plane", Escape.eP4((P4)jvxlData.jvxlPlane));
        }
        if (jvxlData.color != null && jvxlData.color.indexOf("null") < 0) {
            JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  color", jvxlData.color);
        }
        JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  translucency", "" + jvxlData.translucency);
        if (jvxlData.meshColor != null) {
            JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  meshColor", jvxlData.meshColor);
        }
        if (jvxlData.colorScheme != null) {
            JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  colorScheme", jvxlData.colorScheme);
        }
        if (jvxlData.rendering != null) {
            JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  rendering", jvxlData.rendering);
        }
        if (jvxlData.thisSet >= 0) {
            JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  set", "" + (jvxlData.thisSet + 1));
        }
        if (jvxlData.slabValue != Integer.MIN_VALUE) {
            JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  slabValue", "" + jvxlData.slabValue);
        }
        if (jvxlData.isSlabbable) {
            JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  slabbable", "true");
        }
        if (jvxlData.nVertexColors > 0) {
            JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  nVertexColors", "" + jvxlData.nVertexColors);
        }
        float min = jvxlData.mappedDataMin == Float.MAX_VALUE ? 0.0f : jvxlData.mappedDataMin;
        float blue = jvxlData.isColorReversed ? jvxlData.valueMappedToRed : jvxlData.valueMappedToBlue;
        float f = red = jvxlData.isColorReversed ? jvxlData.valueMappedToBlue : jvxlData.valueMappedToRed;
        if (jvxlData.jvxlColorData != null && jvxlData.jvxlColorData.length() > 0 && !jvxlData.isBicolorMap) {
            JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  dataMinimum", "" + min);
            JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  dataMaximum", "" + jvxlData.mappedDataMax);
            JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  valueMappedToRed", "" + red);
            JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  valueMappedToBlue", "" + blue);
        }
        if (jvxlData.isContoured) {
            if (jvxlData.contourValues == null || jvxlData.contourColixes == null) {
                if (jvxlData.vContours == null) {
                    JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  nContours", "" + Math.abs(jvxlData.nContours));
                }
            } else {
                if (jvxlData.jvxlPlane != null) {
                    JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  contoured", "true");
                }
                JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  nContours", "" + jvxlData.contourValues.length);
                JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  contourValues", Escape.eAF((float[])(jvxlData.contourValuesUsed == null ? jvxlData.contourValues : jvxlData.contourValuesUsed)));
                JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  contourColors", jvxlData.contourColors);
            }
            if (jvxlData.thisContour > 0) {
                JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  thisContour", "" + jvxlData.thisContour);
            }
        }
        if (jvxlData.insideOut) {
            JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  insideOut", "true");
        }
        if (jvxlData.vertexDataOnly) {
            JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  note", "vertex/face data only");
        } else if (jvxlData.isXLowToHigh) {
            JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  note", "progressive JVXL+ -- X values read from low(0) to high(" + (jvxlData.nPointsX - 1) + ")");
        }
        JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  xyzMin", Escape.eP((T3)jvxlData.boundingBox[0]));
        JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  xyzMax", Escape.eP((T3)jvxlData.boundingBox[1]));
        JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  approximateCompressionRatio", "not calculated");
        JvxlCoder.addAttrib((Lst<String[]>)attribs, "\n  jmolVersion", jvxlData.version);
        SB info = new SB();
        XmlUtil.openTagAttr((SB)info, (String)"jvxlSurfaceInfo", (Object[])attribs.toArray(new Object[attribs.size()]));
        XmlUtil.closeTag((SB)info, (String)"jvxlSurfaceInfo");
        return info.toString();
    }

    private static void addAttrib(Lst<String[]> attribs, String name, String value) {
        attribs.addLast((Object)new String[]{name, value});
    }

    private static void jvxlEncodeContourData(Lst<Object>[] contours, SB sb) {
        XmlUtil.openTagAttr((SB)sb, (String)"jvxlContourData", (Object[])new String[]{"count", "" + contours.length});
        for (int i = 0; i < contours.length; ++i) {
            if (contours[i].size() < 6) continue;
            int nPolygons = (Integer)contours[i].get(0);
            SB sb1 = new SB();
            sb1.append("\n");
            BS bs = (BS)contours[i].get(1);
            JvxlCoder.jvxlEncodeBitSetBuffer(bs, nPolygons, sb1);
            XmlUtil.appendTagObj((SB)sb, (String)"jvxlContour", (Object[])new String[]{"index", "" + i, "value", "" + contours[i].get(2), "color", Escape.escapeColor((int)((int[])contours[i].get(4))[0]), "count", "" + bs.length(), "encoding", "base90iff1", "bsEncoding", "base90+35c", "data", JvxlCoder.jvxlCompressString(contours[i].get(5).toString(), true)}, (Object)JvxlCoder.jvxlCompressString(sb1.toString(), true));
        }
        XmlUtil.closeTag((SB)sb, (String)"jvxlContourData");
    }

    public static void set3dContourVector(Lst<Object> v, int[][] polygonIndexes, T3[] vertices) {
        if (v.size() < 6) {
            return;
        }
        SB fData = (SB)v.get(5);
        BS bs = (BS)v.get(1);
        int pt = 0;
        int nBuf = fData.length();
        int type = 0;
        int c1 = 32;
        int c2 = 32;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            int i4;
            int i2;
            int i3;
            int i1;
            int[] vertexIndexes = polygonIndexes[i];
            while (pt < nBuf) {
                char c = fData.charAt(pt++);
                c1 = c;
                if (!PT.isDigit((char)c)) continue;
            }
            type = c1 - 48;
            while (pt < nBuf) {
                char c = fData.charAt(pt++);
                c1 = c;
                if (PT.isWhitespace((char)c)) continue;
            }
            while (pt < nBuf) {
                char c = fData.charAt(pt++);
                c2 = c;
                if (PT.isWhitespace((char)c)) continue;
            }
            float f1 = JvxlCoder.jvxlFractionFromCharacter(c1, 35, 90, 0.0f);
            float f2 = JvxlCoder.jvxlFractionFromCharacter(c2, 35, 90, 0.0f);
            if ((type & 1) == 0) {
                i1 = vertexIndexes[1];
                i2 = i3 = vertexIndexes[2];
                i4 = vertexIndexes[0];
            } else {
                i1 = vertexIndexes[0];
                i2 = vertexIndexes[1];
                if ((type & 2) != 0) {
                    i3 = i2;
                    i4 = vertexIndexes[2];
                } else {
                    i3 = vertexIndexes[2];
                    i4 = i1;
                }
            }
            v.addLast((Object)JvxlCoder.getContourPoint(vertices, i1, i2, f1));
            v.addLast((Object)JvxlCoder.getContourPoint(vertices, i3, i4, f2));
            i = bs.nextSetBit(i + 1);
        }
    }

    private static T3 getContourPoint(T3[] vertices, int i, int j, float f) {
        P3 pt = new P3();
        pt.sub2(vertices[j], vertices[i]);
        pt.scaleAdd2(f, (T3)pt, vertices[i]);
        return pt;
    }

    public static void appendContourTriangleIntersection(int type, float f1, float f2, SB fData) {
        fData.appendI(type);
        fData.appendC(JvxlCoder.jvxlFractionAsCharacter(f1));
        fData.appendC(JvxlCoder.jvxlFractionAsCharacter(f2));
    }

    public static void jvxlCreateColorData(JvxlData jvxlData, float[] vertexValues) {
        int vertexCount;
        if (vertexValues == null) {
            jvxlData.jvxlColorData = "";
            return;
        }
        boolean writePrecisionColor = jvxlData.isJvxlPrecisionColor;
        boolean doTruncate = jvxlData.isTruncated;
        int colorFractionBase = jvxlData.colorFractionBase;
        int colorFractionRange = jvxlData.colorFractionRange;
        float valueBlue = jvxlData.valueMappedToBlue;
        float valueRed = jvxlData.valueMappedToRed;
        int n = vertexCount = jvxlData.saveVertexCount > 0 ? jvxlData.saveVertexCount : jvxlData.vertexCount;
        if (vertexCount > vertexValues.length) {
            System.out.println("JVXLCODER ERROR");
        }
        float min = jvxlData.mappedDataMin;
        float max = jvxlData.mappedDataMax;
        SB list1 = new SB();
        SB list2 = new SB();
        if (vertexValues.length < vertexCount) {
            System.out.println("JVXLCOLOR OHOHO");
        }
        for (int i = 0; i < vertexCount; ++i) {
            float value = vertexValues[i];
            if (Float.isNaN(value)) {
                value = min;
            }
            if (doTruncate) {
                float f = value = value > 0.0f ? 0.999f : -0.999f;
            }
            if (writePrecisionColor) {
                JvxlCoder.jvxlAppendCharacter2(value, min, max, colorFractionBase, colorFractionRange, list1, list2);
                continue;
            }
            list1.appendC(JvxlCoder.jvxlValueAsCharacter(value, valueRed, valueBlue, colorFractionBase, colorFractionRange));
        }
        jvxlData.jvxlColorData = list1.appendSB(list2).appendC('\n').toString();
    }

    private static void appendXmlVertexOnlyData(SB sb, JvxlData jvxlData, MeshData meshData, boolean escapeXml) {
        int[] vertexIdNew = new int[meshData.vc];
        if (JvxlCoder.appendXmlTriangleData(sb, meshData.pis, meshData.pc, meshData.bsSlabDisplay, vertexIdNew, escapeXml)) {
            JvxlCoder.appendXmlVertexData(sb, jvxlData, vertexIdNew, meshData.vs, meshData.vvs, meshData.vc, meshData.polygonColorData, meshData.pc, meshData.bsSlabDisplay, jvxlData.vertexColors, jvxlData.jvxlColorData.length() > 0, escapeXml);
        }
    }

    private static boolean appendXmlTriangleData(SB sb, int[][] triangles, int nData, BS bsSlabDisplay, int[] vertexIdNew, boolean escapeXml) {
        SB list1 = new SB();
        SB list2 = new SB();
        int ilast = 1;
        int p = 0;
        int inew = 0;
        boolean addPlus = false;
        int nTri = 0;
        boolean removeSlabbed = bsSlabDisplay != null;
        int i = 0;
        while (i < nData) {
            if (triangles[i] == null || removeSlabbed && !bsSlabDisplay.get(i)) {
                ++i;
                continue;
            }
            int idata = triangles[i][p];
            idata = vertexIdNew[idata] > 0 ? vertexIdNew[idata] : (vertexIdNew[idata] = ++inew);
            int diff = idata - ilast;
            ilast = idata;
            if (diff == 0) {
                list1.appendC('!');
                addPlus = false;
            } else if (diff > 32) {
                if (addPlus) {
                    list1.appendC('+');
                }
                list1.appendI(diff);
                addPlus = true;
            } else if (diff < -32) {
                list1.appendI(diff);
                addPlus = true;
            } else {
                list1.appendC((char)(92 + diff));
                addPlus = false;
            }
            if (++p % 3 != 0) continue;
            list2.appendI(triangles[i][3]);
            p = 0;
            ++i;
            ++nTri;
        }
        if (list1.length() == 0) {
            return true;
        }
        XmlUtil.appendTagObj((SB)sb, (String)"jvxlTriangleData", (Object[])new String[]{"count", "" + nTri, "encoding", "jvxltdiff", "data", JvxlCoder.jvxlCompressString(list1.toString(), escapeXml)}, null);
        XmlUtil.appendTagObj((SB)sb, (String)"jvxlTriangleEdgeData", (Object[])new String[]{"count", "" + nTri, "encoding", "jvxlsc", "data", JvxlCoder.jvxlCompressString(list2.toString(), escapeXml)}, null);
        return true;
    }

    private static void appendXmlVertexData(SB sb, JvxlData jvxlData, int[] vertexIdNew, T3[] vertices, float[] vertexValues, int vertexCount, String polygonColorData, int polygonCount, BS bsSlabDisplay, int[] vertexColors, boolean addColorData, boolean escapeXml) {
        int i;
        boolean removeSlabbed;
        int colorFractionBase = jvxlData.colorFractionBase;
        int colorFractionRange = jvxlData.colorFractionRange;
        P3 min = jvxlData.boundingBox[0];
        P3 max = jvxlData.boundingBox[1];
        SB list1 = new SB();
        SB list2 = new SB();
        int[] vertexIdOld = null;
        boolean bl = removeSlabbed = bsSlabDisplay != null;
        if (polygonCount > 0) {
            if (removeSlabbed) {
                polygonCount = bsSlabDisplay.cardinality();
            }
            removeSlabbed = false;
            vertexIdOld = new int[vertexCount];
            for (int i2 = 0; i2 < vertexCount; ++i2) {
                if (vertexIdNew[i2] <= 0) continue;
                vertexIdOld[vertexIdNew[i2] - 1] = i2;
            }
        }
        int n = 0;
        for (i = 0; i < vertexCount; ++i) {
            if (removeSlabbed && !bsSlabDisplay.get(i)) continue;
            ++n;
            T3 p = vertices[polygonCount == 0 ? i : vertexIdOld[i]];
            JvxlCoder.jvxlAppendCharacter2(p.x, min.x, max.x, colorFractionBase, colorFractionRange, list1, list2);
            JvxlCoder.jvxlAppendCharacter2(p.y, min.y, max.y, colorFractionBase, colorFractionRange, list1, list2);
            JvxlCoder.jvxlAppendCharacter2(p.z, min.z, max.z, colorFractionBase, colorFractionRange, list1, list2);
        }
        list1.appendSB(list2);
        XmlUtil.appendTagObj((SB)sb, (String)"jvxlVertexData", (Object[])new String[]{"count", "" + n, "min", Escape.eP((T3)min), "max", Escape.eP((T3)max), "encoding", "base90xyz2", "data", JvxlCoder.jvxlCompressString(list1.toString(), escapeXml)}, null);
        if (polygonColorData != null) {
            XmlUtil.appendTagObj((SB)sb, (String)"jvxlPolygonColorData", (Object[])new String[]{"encoding", "jvxlnc", "count", "" + polygonCount}, (Object)("\n" + polygonColorData));
        }
        if (!addColorData) {
            return;
        }
        list1 = new SB();
        list2 = new SB();
        if (vertexColors == null) {
            for (i = 0; i < vertexCount; ++i) {
                if (removeSlabbed && !bsSlabDisplay.get(i)) continue;
                float value = vertexValues[polygonCount == 0 ? i : vertexIdOld[i]];
                JvxlCoder.jvxlAppendCharacter2(value, jvxlData.mappedDataMin, jvxlData.mappedDataMax, colorFractionBase, colorFractionRange, list1, list2);
            }
        } else {
            int lastColor = 0;
            list1.appendI(n).append(" ");
            for (int i3 = 0; i3 < vertexCount; ++i3) {
                if (removeSlabbed && !bsSlabDisplay.get(i3)) continue;
                int c = vertexColors[polygonCount == 0 ? i3 : vertexIdOld[i3]];
                if (c == lastColor) {
                    c = 0;
                } else {
                    lastColor = c;
                }
                list1.appendI(c);
                list1.append(" ");
            }
        }
        JvxlCoder.appendXmlColorData(sb, list1.appendSB(list2).append("\n").toString(), vertexColors == null, true, jvxlData.valueMappedToRed, jvxlData.valueMappedToBlue);
    }

    public static char jvxlFractionAsCharacter(float fraction) {
        return JvxlCoder.jvxlFractionAsCharacterRange(fraction, 35, 90);
    }

    public static char jvxlFractionAsCharacterRange(float fraction, int base, int range) {
        if (fraction > 0.9999f) {
            fraction = 0.9999f;
        } else if (Float.isNaN(fraction)) {
            fraction = 1.0001f;
        }
        int ich = (int)Math.floor(fraction * (float)range + (float)base);
        if (ich < base) {
            return (char)base;
        }
        if (ich == 92) {
            return '!';
        }
        return (char)ich;
    }

    private static void jvxlAppendCharacter2(float value, float min, float max, int base, int range, SB list1, SB list2) {
        float fraction = min == max ? value : (value - min) / (max - min);
        char ch1 = JvxlCoder.jvxlFractionAsCharacterRange(fraction, base, range);
        list1.appendC(ch1);
        list2.appendC(JvxlCoder.jvxlFractionAsCharacterRange((fraction -= JvxlCoder.jvxlFractionFromCharacter(ch1, base, range, 0.0f)) * (float)range, base, range));
    }

    public static float jvxlFractionFromCharacter(int ich, int base, int range, float fracOffset) {
        float fraction;
        if (ich == base + range) {
            return Float.NaN;
        }
        if (ich < base) {
            ich = 92;
        }
        if ((fraction = ((float)(ich - base) + fracOffset) / (float)range) < 0.0f) {
            return 0.0f;
        }
        if (fraction > 1.0f) {
            return 0.999999f;
        }
        return fraction;
    }

    public static float jvxlFractionFromCharacter2(int ich1, int ich2, int base, int range) {
        float fraction = JvxlCoder.jvxlFractionFromCharacter(ich1, base, range, 0.0f);
        float remains = JvxlCoder.jvxlFractionFromCharacter(ich2, base, range, 0.5f);
        return fraction + remains / (float)range;
    }

    public static char jvxlValueAsCharacter(float value, float min, float max, int base, int range) {
        float fraction = min == max ? value : (value - min) / (max - min);
        return JvxlCoder.jvxlFractionAsCharacterRange(fraction, base, range);
    }

    protected static float jvxlValueFromCharacter2(int ich, int ich2, float min, float max, int base, int range) {
        float fraction = JvxlCoder.jvxlFractionFromCharacter2(ich, ich2, base, range);
        return max == min ? fraction : min + fraction * (max - min);
    }

    public static int jvxlEncodeBitSet0(BS bs, int nPoints, SB sb) {
        int dataCount = 0;
        int prevCount = -1;
        int nPrev = 0;
        if (nPoints < 0) {
            nPoints = bs.length();
        }
        int n = 0;
        boolean isset = false;
        int lastPoint = nPoints - 1;
        for (int i = 0; i < nPoints; ++i) {
            if (isset == bs.get(i)) {
                ++dataCount;
                continue;
            }
            if (dataCount == prevCount && i != lastPoint) {
                ++nPrev;
            } else {
                if (nPrev > 0) {
                    sb.appendC(' ').appendI(-nPrev);
                    nPrev = 0;
                    ++n;
                }
                sb.appendC(' ').appendI(dataCount);
                ++n;
                prevCount = dataCount;
            }
            dataCount = 1;
            isset = !isset;
        }
        sb.appendC(' ').appendI(dataCount).appendC('\n');
        return n;
    }

    public static String jvxlEncodeBitSet(BS bs) {
        SB sb = new SB();
        JvxlCoder.jvxlEncodeBitSetBuffer(bs, -1, sb);
        return sb.toString();
    }

    public static int jvxlEncodeBitSetBuffer(BS bs, int nPoints, SB sb) {
        int dataCount = 0;
        int n = 0;
        boolean isset = false;
        if (nPoints < 0) {
            nPoints = bs.length();
        }
        if (nPoints == 0) {
            return 0;
        }
        sb.append("-");
        for (int i = 0; i < nPoints; ++i) {
            if (isset == bs.get(i)) {
                ++dataCount;
                continue;
            }
            JvxlCoder.jvxlAppendEncodedNumber(sb, dataCount, 35, 90);
            ++n;
            dataCount = 1;
            isset = !isset;
        }
        JvxlCoder.jvxlAppendEncodedNumber(sb, dataCount, 35, 90);
        sb.appendC('\n');
        return n;
    }

    public static void jvxlAppendEncodedNumber(SB sb, int n, int base, int range) {
        boolean isInRange;
        boolean bl = isInRange = n < range;
        if (n == 0) {
            sb.appendC((char)base);
        } else if (!isInRange) {
            sb.appendC((char)(base + range));
        }
        while (n > 0) {
            int n1 = n / range;
            int x = base + n - n1 * range;
            if (x == 92) {
                x = 33;
            }
            sb.appendC((char)x);
            n = n1;
        }
        if (!isInRange) {
            sb.append(" ");
        }
    }

    public static BS jvxlDecodeBitSetRange(String data, int base, int range) {
        BS bs = new BS();
        int dataCount = 0;
        int ptr = 0;
        boolean isset = false;
        int[] next = new int[1];
        while ((dataCount = JvxlCoder.jvxlParseEncodedInt(data, base, range, next)) != Integer.MIN_VALUE) {
            if (isset) {
                bs.setBits(ptr, ptr + dataCount);
            }
            ptr += dataCount;
            isset = !isset;
        }
        return bs;
    }

    public static int jvxlParseEncodedInt(String str, int offset, int base, int[] next) {
        boolean isLong;
        int ich;
        boolean digitSeen = false;
        int value = 0;
        int ichMax = str.length();
        if (ich < 0) {
            return Integer.MIN_VALUE;
        }
        for (ich = next[0]; ich < ichMax && PT.isWhitespace((char)str.charAt(ich)); ++ich) {
        }
        if (ich >= ichMax) {
            return Integer.MIN_VALUE;
        }
        int factor = 1;
        boolean bl = isLong = str.charAt(ich) == offset + base;
        if (isLong) {
            ++ich;
        }
        while (ich < ichMax && !PT.isWhitespace((char)str.charAt(ich))) {
            int i = str.charAt(ich);
            if (i < offset) {
                i = 92;
            }
            value += (i - offset) * factor;
            digitSeen = true;
            ++ich;
            if (!isLong) break;
            factor *= base;
        }
        if (!digitSeen) {
            value = Integer.MIN_VALUE;
        }
        next[0] = ich;
        return value;
    }

    public static BS jvxlDecodeBitSet(String data) {
        if (data.startsWith("-")) {
            return JvxlCoder.jvxlDecodeBitSetRange(JvxlCoder.jvxlDecompressString(data.substring(1)), 35, 90);
        }
        BS bs = new BS();
        int dataCount = 0;
        int lastCount = 0;
        int nPrev = 0;
        int ptr = 0;
        boolean isset = false;
        int[] next = new int[1];
        while (true) {
            int n = dataCount = nPrev++ < 0 ? dataCount : PT.parseIntNext((String)data, (int[])next);
            if (dataCount == Integer.MIN_VALUE) break;
            if (dataCount < 0) {
                nPrev = dataCount;
                dataCount = lastCount;
                continue;
            }
            if (isset) {
                bs.setBits(ptr, ptr + dataCount);
            }
            ptr += dataCount;
            lastCount = dataCount;
            isset = !isset;
        }
        return bs;
    }

    public static String jvxlCompressString(String data, boolean escapeXml) {
        if (data.indexOf("~") >= 0) {
            return data;
        }
        SB dataOut = new SB();
        char chLast = '\u0000';
        boolean escaped = false;
        boolean lastEscaped = false;
        int nLast = 0;
        int n = data.length();
        block4: for (int i = 0; i <= n; ++i) {
            char ch = i == n ? (char)'\u0000' : data.charAt(i);
            switch (ch) {
                case '\n': 
                case '\r': {
                    continue block4;
                }
                case '&': 
                case '<': {
                    escaped = escapeXml;
                    break;
                }
                default: {
                    escaped = false;
                }
            }
            if (ch == chLast) {
                ++nLast;
                ch = '\u0000';
            } else if (nLast > 0 || lastEscaped) {
                if (nLast < 4 && !lastEscaped || chLast == ' ' || chLast == '\t') {
                    while (--nLast >= 0) {
                        dataOut.appendC(chLast);
                    }
                } else {
                    if (lastEscaped) {
                        lastEscaped = false;
                    } else {
                        dataOut.appendC('~');
                    }
                    dataOut.appendI(nLast);
                    dataOut.appendC(' ');
                }
                nLast = 0;
            }
            if (ch == '\u0000') continue;
            if (escaped) {
                lastEscaped = true;
                escaped = false;
                dataOut.appendC('~');
                chLast = ch;
                ch = (char)(ch - '\u0001');
            } else {
                chLast = ch;
            }
            dataOut.appendC(ch);
        }
        return dataOut.toString();
    }

    public static String jvxlDecompressString(String data) {
        if (data.indexOf("~") < 0) {
            return data;
        }
        SB dataOut = new SB();
        char chLast = '\u0000';
        int[] next = new int[1];
        block5: for (int i = 0; i < data.length(); ++i) {
            char ch = data.charAt(i);
            if (ch == '~') {
                next[0] = ++i;
                ch = data.charAt(i);
                switch (ch) {
                    case '%': 
                    case ';': {
                        next[0] = next[0] + 1;
                        chLast = ch = (char)(ch + '\u0001');
                        dataOut.appendC(chLast);
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        int nChar = PT.parseIntNext((String)data, (int[])next);
                        for (int c = 0; c < nChar; ++c) {
                            dataOut.appendC(chLast);
                        }
                        i = next[0];
                        continue block5;
                    }
                    case '~': {
                        --i;
                        break;
                    }
                    default: {
                        Logger.error((String)("Error uncompressing string " + data.substring(0, i) + "?"));
                    }
                }
            }
            dataOut.appendC(ch);
            chLast = ch;
        }
        return dataOut.toString();
    }

    public static void jvxlCreateHeaderWithoutTitleOrAtoms(VolumeData v, SB bs) {
        JvxlCoder.jvxlCreateHeader(v, bs);
    }

    public static void jvxlCreateHeader(VolumeData v, SB sb) {
        v.setVolumetricXml();
        if (sb.length() == 0) {
            sb.append("Line 1\nLine 2\n");
        }
    }
}

