/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.SessionSaveAsAction;
import org.openstreetmap.josm.actions.UploadAction;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.io.AbstractIOTask;
import org.openstreetmap.josm.gui.io.AbstractUploadDialog;
import org.openstreetmap.josm.gui.io.SaveLayerInfo;
import org.openstreetmap.josm.gui.io.SaveLayerTask;
import org.openstreetmap.josm.gui.io.SaveLayersModel;
import org.openstreetmap.josm.gui.io.SaveLayersTable;
import org.openstreetmap.josm.gui.io.UploadAndSaveProgressRenderer;
import org.openstreetmap.josm.gui.io.UploadOrSaveState;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.swing.SwingRenderingProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.UserCancelException;
import org.openstreetmap.josm.tools.Utils;

public class SaveLayersDialog
extends JDialog
implements TableModelListener {
    private final SaveLayersModel model = new SaveLayersModel();
    private UserAction action = UserAction.CANCEL;
    private final UploadAndSaveProgressRenderer pnlUploadLayers = new UploadAndSaveProgressRenderer();
    private final SaveAndProceedAction saveAndProceedAction = new SaveAndProceedAction();
    private final SaveSessionAction saveSessionAction = new SaveSessionAction();
    private final DiscardAndProceedAction discardAndProceedAction = new DiscardAndProceedAction();
    private final CancelAction cancelAction = new CancelAction();
    private transient SaveAndUploadTask saveAndUploadTask;
    private final JButton saveAndProceedActionButton = new JButton(this.saveAndProceedAction);

    public static boolean saveUnsavedModifications(Iterable<? extends Layer> selectedLayers, Reason reason) {
        if (!GraphicsEnvironment.isHeadless()) {
            SaveLayersDialog dialog = new SaveLayersDialog(Main.parent);
            ArrayList<AbstractModifiableLayer> layersWithUnmodifiedChanges = new ArrayList<AbstractModifiableLayer>();
            for (Layer layer : selectedLayers) {
                AbstractModifiableLayer odl;
                if (!(layer instanceof AbstractModifiableLayer) || !(odl = (AbstractModifiableLayer)layer).isModified() || (odl.isSavable() || odl.isUploadable()) && !odl.requiresSaveToFile() && (!odl.requiresUploadToServer() || odl.isUploadDiscouraged())) continue;
                layersWithUnmodifiedChanges.add(odl);
            }
            dialog.prepareForSavingAndUpdatingLayers(reason);
            if (!layersWithUnmodifiedChanges.isEmpty()) {
                dialog.getModel().populate(layersWithUnmodifiedChanges);
                dialog.setVisible(true);
                switch (dialog.getUserAction()) {
                    case PROCEED: {
                        return true;
                    }
                }
                return false;
            }
        }
        return true;
    }

    public SaveLayersDialog(Component parent) {
        super((Window)GuiHelper.getFrameForComponent(parent), Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
    }

    protected void build() {
        WindowGeometry geometry = WindowGeometry.centerOnScreen(new Dimension(650, 300));
        geometry.applySafe(this);
        this.getContentPane().setLayout(new BorderLayout());
        SaveLayersTable table = new SaveLayersTable(this.model);
        JScrollPane pane = new JScrollPane(table);
        this.model.addPropertyChangeListener(table);
        table.getModel().addTableModelListener(this);
        this.getContentPane().add((Component)pane, "Center");
        this.getContentPane().add((Component)this.buildButtonRow(), "South");
        this.addWindowListener(new WindowClosingAdapter());
        this.setDefaultCloseOperation(2);
    }

    protected JPanel buildButtonRow() {
        JPanel pnl = new JPanel(new GridBagLayout());
        this.model.addPropertyChangeListener(this.saveAndProceedAction);
        pnl.add((Component)this.saveAndProceedActionButton, GBC.std(0, 0).insets(5, 5, 0, 0).fill(2));
        pnl.add((Component)new JButton(this.saveSessionAction), GBC.std(1, 0).insets(5, 5, 5, 0).fill(2));
        this.model.addPropertyChangeListener(this.discardAndProceedAction);
        pnl.add((Component)new JButton(this.discardAndProceedAction), GBC.std(0, 1).insets(5, 5, 0, 5).fill(2));
        pnl.add((Component)new JButton(this.cancelAction), GBC.std(1, 1).insets(5, 5, 5, 5).fill(2));
        JPanel pnl2 = new JPanel(new BorderLayout());
        pnl2.add((Component)this.pnlUploadLayers, "Center");
        this.model.addPropertyChangeListener(this.pnlUploadLayers);
        pnl2.add((Component)pnl, "South");
        return pnl2;
    }

    public void prepareForSavingAndUpdatingLayers(Reason reason) {
        switch (reason) {
            case EXIT: {
                this.setTitle(I18n.tr("Unsaved changes - Save/Upload before exiting?", new Object[0]));
                break;
            }
            case DELETE: {
                this.setTitle(I18n.tr("Unsaved changes - Save/Upload before deleting?", new Object[0]));
                break;
            }
            case RESTART: {
                this.setTitle(I18n.tr("Unsaved changes - Save/Upload before restarting?", new Object[0]));
            }
        }
        this.saveAndProceedAction.initForReason(reason);
        this.discardAndProceedAction.initForReason(reason);
    }

    public UserAction getUserAction() {
        return this.action;
    }

    public SaveLayersModel getModel() {
        return this.model;
    }

    protected void launchSafeAndUploadTask() {
        SwingRenderingProgressMonitor monitor = new SwingRenderingProgressMonitor(this.pnlUploadLayers);
        monitor.beginTask(I18n.tr("Uploading and saving modified layers ...", new Object[0]));
        this.saveAndUploadTask = new SaveAndUploadTask(this.model, monitor);
        new Thread((Runnable)this.saveAndUploadTask, this.saveAndUploadTask.getClass().getName()).start();
    }

    protected void cancelSafeAndUploadTask() {
        if (this.saveAndUploadTask != null) {
            this.saveAndUploadTask.cancel();
        }
        this.model.setMode(SaveLayersModel.Mode.EDITING_DATA);
    }

    private static void warn(String msg, List<SaveLayerInfo> infos, String title) {
        LayerListWarningMessagePanel panel = new LayerListWarningMessagePanel(msg, infos);
        if (!GraphicsEnvironment.isHeadless()) {
            JOptionPane.showConfirmDialog(Main.parent, panel, title, -1, 2);
        }
    }

    protected static void warnLayersWithConflictsAndUploadRequest(List<SaveLayerInfo> infos) {
        SaveLayersDialog.warn(I18n.trn("<html>{0} layer has unresolved conflicts.<br>Either resolve them first or discard the modifications.<br>Layer with conflicts:</html>", "<html>{0} layers have unresolved conflicts.<br>Either resolve them first or discard the modifications.<br>Layers with conflicts:</html>", infos.size(), infos.size()), infos, I18n.tr("Unsaved data and conflicts", new Object[0]));
    }

    protected static void warnLayersWithoutFilesAndSaveRequest(List<SaveLayerInfo> infos) {
        SaveLayersDialog.warn(I18n.trn("<html>{0} layer needs saving but has no associated file.<br>Either select a file for this layer or discard the changes.<br>Layer without a file:</html>", "<html>{0} layers need saving but have no associated file.<br>Either select a file for each of them or discard the changes.<br>Layers without a file:</html>", infos.size(), infos.size()), infos, I18n.tr("Unsaved data and missing associated file", new Object[0]));
    }

    protected static void warnLayersWithIllegalFilesAndSaveRequest(List<SaveLayerInfo> infos) {
        SaveLayersDialog.warn(I18n.trn("<html>{0} layer needs saving but has an associated file<br>which cannot be written.<br>Either select another file for this layer or discard the changes.<br>Layer with a non-writable file:</html>", "<html>{0} layers need saving but have associated files<br>which cannot be written.<br>Either select another file for each of them or discard the changes.<br>Layers with non-writable files:</html>", infos.size(), infos.size()), infos, I18n.tr("Unsaved data non-writable files", new Object[0]));
    }

    static boolean confirmSaveLayerInfosOK(SaveLayersModel model) {
        List<SaveLayerInfo> layerInfos = model.getLayersWithConflictsAndUploadRequest();
        if (!layerInfos.isEmpty()) {
            SaveLayersDialog.warnLayersWithConflictsAndUploadRequest(layerInfos);
            return false;
        }
        layerInfos = model.getLayersWithoutFilesAndSaveRequest();
        if (!layerInfos.isEmpty()) {
            SaveLayersDialog.warnLayersWithoutFilesAndSaveRequest(layerInfos);
            return false;
        }
        layerInfos = model.getLayersWithIllegalFilesAndSaveRequest();
        if (!layerInfos.isEmpty()) {
            SaveLayersDialog.warnLayersWithIllegalFilesAndSaveRequest(layerInfos);
            return false;
        }
        return true;
    }

    protected void setUserAction(UserAction action) {
        this.action = action;
    }

    public void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        boolean dis;
        boolean bl = dis = this.model.getLayersToSave().isEmpty() && this.model.getLayersToUpload().isEmpty();
        if (this.saveAndProceedActionButton != null) {
            this.saveAndProceedActionButton.setEnabled(!dis);
        }
        this.saveAndProceedAction.redrawIcon();
    }

    protected class SaveAndUploadTask
    implements Runnable {
        private final SaveLayersModel model;
        private final ProgressMonitor monitor;
        private final ExecutorService worker;
        private boolean canceled;
        private AbstractIOTask currentTask;

        public SaveAndUploadTask(SaveLayersModel model, ProgressMonitor monitor) {
            this.model = model;
            this.monitor = monitor;
            this.worker = Executors.newSingleThreadExecutor(Utils.newThreadFactory(this.getClass() + "-%d", 5));
        }

        protected void uploadLayers(List<SaveLayerInfo> toUpload) {
            for (SaveLayerInfo layerInfo : toUpload) {
                AbstractModifiableLayer layer = layerInfo.getLayer();
                if (this.canceled) {
                    this.model.setUploadState(layer, UploadOrSaveState.CANCELED);
                    continue;
                }
                this.monitor.subTask(I18n.tr("Preparing layer ''{0}'' for upload ...", layerInfo.getName()));
                if (!UploadAction.checkPreUploadConditions(layer)) {
                    this.model.setUploadState(layer, UploadOrSaveState.FAILED);
                    continue;
                }
                AbstractUploadDialog dialog = layer.getUploadDialog();
                if (dialog != null) {
                    dialog.setVisible(true);
                    if (dialog.isCanceled()) {
                        this.model.setUploadState(layer, UploadOrSaveState.CANCELED);
                        continue;
                    }
                    dialog.rememberUserInput();
                }
                this.currentTask = layer.createUploadTask(this.monitor);
                if (this.currentTask == null) {
                    this.model.setUploadState(layer, UploadOrSaveState.FAILED);
                    continue;
                }
                Future<?> currentFuture = this.worker.submit(this.currentTask);
                try {
                    currentFuture.get();
                }
                catch (CancellationException e) {
                    Logging.trace(e);
                    this.model.setUploadState(layer, UploadOrSaveState.CANCELED);
                }
                catch (InterruptedException | ExecutionException e) {
                    Logging.error(e);
                    this.model.setUploadState(layer, UploadOrSaveState.FAILED);
                    ExceptionDialogUtil.explainException(e);
                }
                if (this.currentTask.isCanceled()) {
                    this.model.setUploadState(layer, UploadOrSaveState.CANCELED);
                } else if (this.currentTask.isFailed()) {
                    Logging.error(this.currentTask.getLastException());
                    ExceptionDialogUtil.explainException(this.currentTask.getLastException());
                    this.model.setUploadState(layer, UploadOrSaveState.FAILED);
                } else {
                    this.model.setUploadState(layer, UploadOrSaveState.OK);
                }
                this.currentTask = null;
            }
        }

        protected void saveLayers(List<SaveLayerInfo> toSave) {
            for (SaveLayerInfo layerInfo : toSave) {
                if (this.canceled) {
                    this.model.setSaveState(layerInfo.getLayer(), UploadOrSaveState.CANCELED);
                    continue;
                }
                if (layerInfo.isDoCheckSaveConditions()) {
                    if (!layerInfo.getLayer().checkSaveConditions()) continue;
                    layerInfo.setDoCheckSaveConditions(false);
                }
                this.currentTask = new SaveLayerTask(layerInfo, this.monitor);
                Future<?> currentFuture = this.worker.submit(this.currentTask);
                try {
                    currentFuture.get();
                }
                catch (CancellationException e) {
                    Logging.trace(e);
                    this.model.setSaveState(layerInfo.getLayer(), UploadOrSaveState.CANCELED);
                }
                catch (InterruptedException | ExecutionException e) {
                    Logging.error(e);
                    this.model.setSaveState(layerInfo.getLayer(), UploadOrSaveState.FAILED);
                    ExceptionDialogUtil.explainException(e);
                }
                if (this.currentTask.isCanceled()) {
                    this.model.setSaveState(layerInfo.getLayer(), UploadOrSaveState.CANCELED);
                } else if (this.currentTask.isFailed()) {
                    if (this.currentTask.getLastException() != null) {
                        Logging.error(this.currentTask.getLastException());
                        ExceptionDialogUtil.explainException(this.currentTask.getLastException());
                    }
                    this.model.setSaveState(layerInfo.getLayer(), UploadOrSaveState.FAILED);
                } else {
                    this.model.setSaveState(layerInfo.getLayer(), UploadOrSaveState.OK);
                }
                this.currentTask = null;
            }
        }

        protected void warnBecauseOfUnsavedData() {
            int numProblems = this.model.getNumCancel() + this.model.getNumFailed();
            if (numProblems == 0) {
                return;
            }
            Logging.warn(numProblems + " problems occured during upload/save");
            String msg = I18n.trn("<html>An upload and/or save operation of one layer with modifications<br>was canceled or has failed.</html>", "<html>Upload and/or save operations of {0} layers with modifications<br>were canceled or have failed.</html>", numProblems, numProblems);
            JOptionPane.showMessageDialog(Main.parent, msg, I18n.tr("Incomplete upload and/or save", new Object[0]), 2);
        }

        @Override
        public void run() {
            GuiHelper.runInEDTAndWait(() -> {
                List<SaveLayerInfo> toSave;
                this.model.setMode(SaveLayersModel.Mode.UPLOADING_AND_SAVING);
                List<SaveLayerInfo> toUpload = this.model.getLayersToUpload();
                if (!toUpload.isEmpty()) {
                    this.uploadLayers(toUpload);
                }
                if (!(toSave = this.model.getLayersToSave()).isEmpty()) {
                    this.saveLayers(toSave);
                }
                this.model.setMode(SaveLayersModel.Mode.EDITING_DATA);
                if (this.model.hasUnsavedData()) {
                    this.warnBecauseOfUnsavedData();
                    this.model.setMode(SaveLayersModel.Mode.EDITING_DATA);
                    if (this.canceled) {
                        SaveLayersDialog.this.setUserAction(UserAction.CANCEL);
                        SaveLayersDialog.this.closeDialog();
                    }
                } else {
                    SaveLayersDialog.this.setUserAction(UserAction.PROCEED);
                    SaveLayersDialog.this.closeDialog();
                }
            });
            this.worker.shutdownNow();
        }

        public void cancel() {
            if (this.currentTask != null) {
                this.currentTask.cancel();
            }
            this.worker.shutdown();
            this.canceled = true;
        }
    }

    final class SaveAndProceedAction
    extends AbstractAction
    implements PropertyChangeListener {
        private static final int ICON_SIZE = 24;
        private static final String BASE_ICON = "BASE_ICON";
        private final transient Image save = this.getImage("save", false);
        private final transient Image upld = this.getImage("upload", false);
        private final transient Image saveDis = this.getImage("save", true);
        private final transient Image upldDis = this.getImage("upload", true);

        SaveAndProceedAction() {
            this.initForReason(Reason.EXIT);
        }

        Image getImage(String name, boolean disabled) {
            ImageIcon img = new ImageProvider(name).setDisabled(disabled).get();
            return img != null ? img.getImage() : null;
        }

        public void initForReason(Reason reason) {
            switch (reason) {
                case EXIT: {
                    this.putValue("Name", I18n.tr("Perform actions before exiting", new Object[0]));
                    this.putValue("ShortDescription", I18n.tr("Exit JOSM with saving. Unsaved changes are uploaded and/or saved.", new Object[0]));
                    this.putValue(BASE_ICON, ImageProvider.get("exit"));
                    break;
                }
                case RESTART: {
                    this.putValue("Name", I18n.tr("Perform actions before restarting", new Object[0]));
                    this.putValue("ShortDescription", I18n.tr("Restart JOSM with saving. Unsaved changes are uploaded and/or saved.", new Object[0]));
                    this.putValue(BASE_ICON, ImageProvider.get("restart"));
                    break;
                }
                case DELETE: {
                    this.putValue("Name", I18n.tr("Perform actions before deleting", new Object[0]));
                    this.putValue("ShortDescription", I18n.tr("Save/Upload layers before deleting. Unsaved changes are not lost.", new Object[0]));
                    this.putValue(BASE_ICON, ImageProvider.get("dialogs", "delete"));
                }
            }
            this.redrawIcon();
        }

        public void redrawIcon() {
            Image base = ((ImageIcon)this.getValue(BASE_ICON)).getImage();
            BufferedImage newIco = new BufferedImage(72, 24, 6);
            Graphics2D g = newIco.createGraphics();
            g.drawImage(SaveLayersDialog.this.model.getLayersToUpload().isEmpty() ? this.upldDis : this.upld, 0, 0, 24, 24, null);
            g.drawImage(SaveLayersDialog.this.model.getLayersToSave().isEmpty() ? this.saveDis : this.save, 24, 0, 24, 24, null);
            g.drawImage(base, 48, 0, 24, 24, null);
            this.putValue("SmallIcon", new ImageIcon(newIco));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SaveLayersDialog.confirmSaveLayerInfosOK(SaveLayersDialog.this.model)) {
                return;
            }
            SaveLayersDialog.this.launchSafeAndUploadTask();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(SaveLayersModel.MODE_PROP)) {
                SaveLayersModel.Mode mode = (SaveLayersModel.Mode)((Object)evt.getNewValue());
                switch (mode) {
                    case EDITING_DATA: {
                        this.setEnabled(true);
                        break;
                    }
                    case UPLOADING_AND_SAVING: {
                        this.setEnabled(false);
                    }
                }
            }
        }
    }

    class SaveSessionAction
    extends SessionSaveAsAction {
        SaveSessionAction() {
            super(false, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.saveSession();
                SaveLayersDialog.this.setUserAction(UserAction.PROCEED);
                SaveLayersDialog.this.closeDialog();
            }
            catch (UserCancelException ignore) {
                Logging.trace(ignore);
            }
        }
    }

    class DiscardAndProceedAction
    extends AbstractAction
    implements PropertyChangeListener {
        DiscardAndProceedAction() {
            this.initForReason(Reason.EXIT);
        }

        public void initForReason(Reason reason) {
            switch (reason) {
                case EXIT: {
                    this.putValue("Name", I18n.tr("Exit now!", new Object[0]));
                    this.putValue("ShortDescription", I18n.tr("Exit JOSM without saving. Unsaved changes are lost.", new Object[0]));
                    new ImageProvider("exit").getResource().attachImageIcon(this, true);
                    break;
                }
                case RESTART: {
                    this.putValue("Name", I18n.tr("Restart now!", new Object[0]));
                    this.putValue("ShortDescription", I18n.tr("Restart JOSM without saving. Unsaved changes are lost.", new Object[0]));
                    new ImageProvider("restart").getResource().attachImageIcon(this, true);
                    break;
                }
                case DELETE: {
                    this.putValue("Name", I18n.tr("Delete now!", new Object[0]));
                    this.putValue("ShortDescription", I18n.tr("Delete layers without saving. Unsaved changes are lost.", new Object[0]));
                    new ImageProvider("dialogs", "delete").getResource().attachImageIcon(this, true);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SaveLayersDialog.this.setUserAction(UserAction.PROCEED);
            SaveLayersDialog.this.closeDialog();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(SaveLayersModel.MODE_PROP)) {
                SaveLayersModel.Mode mode = (SaveLayersModel.Mode)((Object)evt.getNewValue());
                switch (mode) {
                    case EDITING_DATA: {
                        this.setEnabled(true);
                        break;
                    }
                    case UPLOADING_AND_SAVING: {
                        this.setEnabled(false);
                    }
                }
            }
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Close this dialog and resume editing in JOSM", new Object[0]));
            new ImageProvider("cancel").getResource().attachImageIcon(this, true);
            InputMapUtils.addEscapeAction(SaveLayersDialog.this.getRootPane(), this);
        }

        protected void cancelWhenInEditingModel() {
            SaveLayersDialog.this.setUserAction(UserAction.CANCEL);
            SaveLayersDialog.this.closeDialog();
        }

        public void cancel() {
            switch (SaveLayersDialog.this.model.getMode()) {
                case EDITING_DATA: {
                    this.cancelWhenInEditingModel();
                    break;
                }
                case UPLOADING_AND_SAVING: {
                    SaveLayersDialog.this.cancelSafeAndUploadTask();
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.cancel();
        }
    }

    class WindowClosingAdapter
    extends WindowAdapter {
        WindowClosingAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            SaveLayersDialog.this.cancelAction.cancel();
        }
    }

    private static class LayerListWarningMessagePanel
    extends JPanel {
        private final JLabel lblMessage = new JLabel();
        private final JList<SaveLayerInfo> lstLayers = new JList();

        LayerListWarningMessagePanel(String msg, List<SaveLayerInfo> infos) {
            super(new GridBagLayout());
            this.build();
            this.lblMessage.setText(msg);
            this.lstLayers.setListData((SaveLayerInfo[])infos.toArray(new SaveLayerInfo[infos.size()]));
        }

        protected void build() {
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridx = 0;
            gc.gridy = 0;
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            this.add((Component)this.lblMessage, gc);
            this.lblMessage.setHorizontalAlignment(2);
            this.lstLayers.setCellRenderer(new LayerCellRenderer());
            gc.gridx = 0;
            gc.gridy = 1;
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            this.add(this.lstLayers, gc);
        }

        static final class LayerCellRenderer
        implements ListCellRenderer<SaveLayerInfo> {
            private final DefaultListCellRenderer def = new DefaultListCellRenderer();

            LayerCellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends SaveLayerInfo> list, SaveLayerInfo info, int index, boolean isSelected, boolean cellHasFocus) {
                this.def.setIcon(info.getLayer().getIcon());
                this.def.setText(info.getName());
                return this.def;
            }
        }
    }

    private static enum UserAction {
        PROCEED,
        CANCEL;

    }

    public static enum Reason {
        DELETE,
        EXIT,
        RESTART;

    }
}

