/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.imagery;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.util.Optional;
import org.openstreetmap.josm.tools.Logging;

public class ColorfulFilter
implements BufferedImageOp {
    private final double colorfulness;

    ColorfulFilter(double colorfulness) {
        this.colorfulness = colorfulness;
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int redOffset;
        int greenOffset;
        int blueOffset;
        if (src.getWidth() == 0 || src.getHeight() == 0 || src.getType() == 0) {
            return src;
        }
        BufferedImage dest = Optional.ofNullable(dst).orElseGet(() -> this.createCompatibleDestImage(src, null));
        DataBuffer srcBuffer = src.getRaster().getDataBuffer();
        DataBuffer destBuffer = dest.getRaster().getDataBuffer();
        if (!(srcBuffer instanceof DataBufferByte) || !(destBuffer instanceof DataBufferByte)) {
            Logging.trace("Cannot apply color filter: Images do not use DataBufferByte.");
            return src;
        }
        int type = src.getType();
        if (type != dest.getType()) {
            Logging.trace("Cannot apply color filter: Src / Dest differ in type (" + type + '/' + dest.getType() + ')');
            return src;
        }
        int alphaOffset = 0;
        switch (type) {
            case 5: {
                blueOffset = 0;
                greenOffset = 1;
                redOffset = 2;
                break;
            }
            case 6: 
            case 7: {
                blueOffset = 1;
                greenOffset = 2;
                redOffset = 3;
                break;
            }
            case 2: 
            case 3: {
                redOffset = 0;
                greenOffset = 1;
                blueOffset = 2;
                alphaOffset = 3;
                break;
            }
            default: {
                Logging.trace("Cannot apply color filter: Source image is of wrong type (" + type + ").");
                return src;
            }
        }
        this.doFilter((DataBufferByte)srcBuffer, (DataBufferByte)destBuffer, redOffset, greenOffset, blueOffset, alphaOffset, src.getAlphaRaster() != null);
        return dest;
    }

    private void doFilter(DataBufferByte src, DataBufferByte dest, int redOffset, int greenOffset, int blueOffset, int alphaOffset, boolean hasAlpha) {
        byte[] destPixels;
        byte[] srcPixels = src.getData();
        if (srcPixels.length != (destPixels = dest.getData()).length) {
            Logging.trace("Cannot apply color filter: Source/Dest lengths differ.");
            return;
        }
        int entries = hasAlpha ? 4 : 3;
        for (int i = 0; i < srcPixels.length; i += entries) {
            int r = srcPixels[i + redOffset] & 0xFF;
            int g = srcPixels[i + greenOffset] & 0xFF;
            int b = srcPixels[i + blueOffset] & 0xFF;
            double luminosity = (double)r * 0.21 + (double)g * 0.72 + (double)b * 0.07;
            destPixels[i + redOffset] = this.mix(r, luminosity);
            destPixels[i + greenOffset] = this.mix(g, luminosity);
            destPixels[i + blueOffset] = this.mix(b, luminosity);
            if (!hasAlpha) continue;
            destPixels[i + alphaOffset] = srcPixels[i + alphaOffset];
        }
    }

    private byte mix(int color, double luminosity) {
        int val = (int)(this.colorfulness * (double)color + (1.0 - this.colorfulness) * luminosity);
        if (val < 0) {
            return 0;
        }
        if (val > 255) {
            return -1;
        }
        return (byte)val;
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage src) {
        return new Rectangle(src.getWidth(), src.getHeight());
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        return new BufferedImage(src.getWidth(), src.getHeight(), src.getType());
    }

    @Override
    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        return (Point2D)srcPt.clone();
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }
}

