/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.progress.swing;

import java.awt.Component;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.progress.AbstractProgressMonitor;
import org.openstreetmap.josm.gui.progress.CancelHandler;
import org.openstreetmap.josm.gui.progress.ProgressRenderer;
import org.openstreetmap.josm.gui.progress.ProgressTaskId;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class SwingRenderingProgressMonitor
extends AbstractProgressMonitor {
    private static final int PROGRESS_BAR_MAX = 100;
    private int currentProgressValue;
    private final ProgressRenderer delegate;

    public SwingRenderingProgressMonitor(ProgressRenderer delegate) {
        super(new CancelHandler());
        CheckParameterUtil.ensureParameterNotNull(delegate, "delegate");
        this.delegate = delegate;
    }

    @Override
    public void doBeginTask() {
        GuiHelper.runInEDT(() -> {
            this.delegate.setCustomText("");
            this.delegate.setMaximum(100);
        });
    }

    @Override
    public void doFinishTask() {
    }

    @Override
    protected void updateProgress(double progressValue) {
        int newValue = (int)(progressValue * 100.0);
        if (newValue != this.currentProgressValue) {
            this.currentProgressValue = newValue;
            GuiHelper.runInEDT(() -> this.delegate.setValue(this.currentProgressValue));
        }
    }

    @Override
    protected void doSetCustomText(String title) {
        this.checkState(AbstractProgressMonitor.State.IN_TASK, AbstractProgressMonitor.State.IN_SUBTASK);
        GuiHelper.runInEDT(() -> this.delegate.setCustomText(title));
    }

    @Override
    protected void doSetTitle(String title) {
        this.checkState(AbstractProgressMonitor.State.IN_TASK, AbstractProgressMonitor.State.IN_SUBTASK);
        GuiHelper.runInEDT(() -> this.delegate.setTaskTitle(title));
    }

    @Override
    protected void doSetIntermediate(boolean value) {
        GuiHelper.runInEDT(() -> this.delegate.setIndeterminate(value));
    }

    @Override
    public void setProgressTaskId(ProgressTaskId taskId) {
    }

    @Override
    public ProgressTaskId getProgressTaskId() {
        return null;
    }

    @Override
    public Component getWindowParent() {
        return Main.parent;
    }
}

