/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.proxies;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyProc;
import org.jruby.anno.JRubyMethod;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.JavaClass;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class InterfaceJavaProxy
extends JavaProxy {
    private static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
            return new InterfaceJavaProxy(runtime, klazz);
        }
    };

    public InterfaceJavaProxy(Ruby runtime, RubyClass klazz) {
        super(runtime, klazz);
    }

    public static RubyClass createInterfaceJavaProxy(ThreadContext context) {
        Ruby runtime = context.runtime;
        RubyClass InterfaceJavaProxy2 = runtime.defineClass("InterfaceJavaProxy", runtime.getJavaSupport().getJavaProxyClass(), ALLOCATOR);
        RubyClass JavaInterfaceExtended = runtime.defineClass("JavaInterfaceExtender", runtime.getObject(), runtime.getObject().getAllocator());
        JavaInterfaceExtended.defineAnnotatedMethods(JavaInterfaceExtender.class);
        return InterfaceJavaProxy2;
    }

    public static class JavaInterfaceExtender {
        @JRubyMethod(visibility=Visibility.PRIVATE)
        public static IRubyObject initialize(ThreadContext context, IRubyObject self2, IRubyObject javaClassName, Block block) {
            Ruby runtime = context.runtime;
            self2.getInstanceVariables().setInstanceVariable("@java_class", JavaClass.forNameVerbose(runtime, javaClassName.asJavaString()));
            self2.getInstanceVariables().setInstanceVariable("@block", RubyProc.newProc(runtime, block, block.type));
            self2.getInternalVariables().getInternalVariable("@block");
            return context.nil;
        }

        @JRubyMethod
        public static IRubyObject extend_proxy(ThreadContext context, IRubyObject self2, IRubyObject proxyClass) {
            return proxyClass.callMethod(context, "class_eval", IRubyObject.NULL_ARRAY, ((RubyProc)self2.getInstanceVariables().getInstanceVariable("@block")).getBlock());
        }
    }
}

