/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.util.LinkedList;
import java.util.Objects;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.util.Span;
import opennlp.tools.util.StringList;

public class DictionaryNameFinder
implements TokenNameFinder {
    private static final String DEFAULT_TYPE = "default";
    private Dictionary mDictionary;
    private final String type;

    public DictionaryNameFinder(Dictionary dictionary, String type) {
        this.mDictionary = Objects.requireNonNull(dictionary, "dictionary must not be null");
        this.type = Objects.requireNonNull(type, "type must not be null");
    }

    public DictionaryNameFinder(Dictionary dictionary) {
        this(dictionary, DEFAULT_TYPE);
    }

    @Override
    public Span[] find(String[] textTokenized) {
        LinkedList<Span> namesFound = new LinkedList<Span>();
        for (int offsetFrom = 0; offsetFrom < textTokenized.length; ++offsetFrom) {
            int lengthSearching;
            Span nameFound = null;
            for (int offsetTo = offsetFrom; offsetTo < textTokenized.length && (lengthSearching = offsetTo - offsetFrom + 1) <= this.mDictionary.getMaxTokenCount(); ++offsetTo) {
                String[] tokensSearching = new String[lengthSearching];
                System.arraycopy(textTokenized, offsetFrom, tokensSearching, 0, lengthSearching);
                StringList entryForSearch = new StringList(tokensSearching);
                if (!this.mDictionary.contains(entryForSearch)) continue;
                nameFound = new Span(offsetFrom, offsetTo + 1, this.type);
            }
            if (nameFound == null) continue;
            namesFound.add(nameFound);
            offsetFrom += nameFound.length() - 1;
        }
        return namesFound.toArray(new Span[namesFound.size()]);
    }

    @Override
    public void clearAdaptiveData() {
    }
}

