/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ChecksumUtils {
    private ChecksumUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(File checksumFile) throws IOException {
        String checksum;
        block12: {
            checksum = "";
            BufferedReader br = null;
            try {
                String line;
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(checksumFile), StandardCharsets.UTF_8), 512);
                do {
                    if ((line = br.readLine()) != null) continue;
                    break block12;
                } while ((line = line.trim()).length() <= 0);
                checksum = line;
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                        br = null;
                    }
                }
                catch (IOException line) {}
            }
        }
        if (checksum.matches(".+= [0-9A-Fa-f]+")) {
            int lastSpacePos = checksum.lastIndexOf(32);
            checksum = checksum.substring(lastSpacePos + 1);
        } else {
            int spacePos = checksum.indexOf(32);
            if (spacePos != -1) {
                checksum = checksum.substring(0, spacePos);
            }
        }
        return checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> calc(File dataFile, Collection<String> algos) throws IOException {
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, MessageDigest> digests = new LinkedHashMap<String, MessageDigest>();
        for (String algo : algos) {
            try {
                digests.put(algo, MessageDigest.getInstance(algo));
            }
            catch (NoSuchAlgorithmException e) {
                results.put(algo, e);
            }
        }
        FileInputStream in = null;
        try {
            int read;
            in = new FileInputStream(dataFile);
            byte[] buffer = new byte[32768];
            while ((read = ((InputStream)in).read(buffer)) >= 0) {
                for (MessageDigest digest : digests.values()) {
                    digest.update(buffer, 0, read);
                }
            }
            ((InputStream)in).close();
            in = null;
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException buffer) {}
        }
        for (Map.Entry entry : digests.entrySet()) {
            byte[] bytes = ((MessageDigest)entry.getValue()).digest();
            results.put((String)entry.getKey(), ChecksumUtils.toHexString(bytes));
        }
        return results;
    }

    public static String toHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(bytes.length * 2);
        for (byte aByte : bytes) {
            int b = aByte & 0xFF;
            if (b < 16) {
                buffer.append('0');
            }
            buffer.append(Integer.toHexString(b));
        }
        return buffer.toString();
    }
}

