// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _OSD_Timer_HeaderFile
#define _OSD_Timer_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Standard_Real.hxx>
#include <OSD_Chronometer.hxx>
#include <Standard_OStream.hxx>
#include <Standard_Integer.hxx>


//! Working on heterogeneous platforms
//! we need to use the system call gettimeofday.
//! This function is portable and it measures ELAPSED
//! time and CPU time in seconds and microseconds.
//! Example: OSD_Timer aTimer;
//! aTimer.Start();   // Start  the timers (t1).
//! .....            // Do something.
//! aTimer.Stop();    // Stop the timers (t2).
//! aTimer.Show();    // Give the elapsed time between t1 and t2.
//! // Give also the process CPU time between
//! // t1 and t2.
class OSD_Timer  : public OSD_Chronometer
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Builds a Chronometer initialized and stopped.
  Standard_EXPORT OSD_Timer();
  
  //! Stops and reinitializes the timer.
  Standard_EXPORT virtual   void Reset() ;
  
  //! Shows both the elapsed time and CPU time on the standard output
  //! stream <cout>.The chronometer can be running (Lap Time) or
  //! stopped.
  Standard_EXPORT virtual   void Show()  const;
  
  //! Shows both the elapsed time and CPU  time on the
  //! output stream <OS>.
  Standard_EXPORT virtual   void Show (Standard_OStream& os)  const;
  
  //! returns both the elapsed time(seconds,minutes,hours)
  //! and CPU  time.
  Standard_EXPORT   void Show (Standard_Real& theSeconds, Standard_Integer& theMinutes, Standard_Integer& theHours, Standard_Real& theCPUtime)  const;
  
  //! Stops the Timer.
  Standard_EXPORT virtual   void Stop() ;
  
  //! Starts (after Create or Reset) or restarts (after Stop)
  //! the Timer.
  Standard_EXPORT virtual   void Start() ;
  
  //! Returns elapsed time in seconds.
  Standard_EXPORT   Standard_Real ElapsedTime()  const;




protected:





private:



  Standard_Real TimeStart;
  Standard_Real TimeCumul;


};







#endif // _OSD_Timer_HeaderFile
