// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _ShapeExtend_ComplexCurve_HeaderFile
#define _ShapeExtend_ComplexCurve_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_ShapeExtend_ComplexCurve.hxx>

#include <Standard_Boolean.hxx>
#include <Geom_Curve.hxx>
#include <Standard_Integer.hxx>
#include <Handle_Geom_Curve.hxx>
#include <Standard_Real.hxx>
#include <GeomAbs_Shape.hxx>
class Geom_Curve;
class gp_Trsf;
class gp_Pnt;
class gp_Vec;


//! Defines a curve which consists of several segments.
//! Implements basic interface to it.
class ShapeExtend_ComplexCurve : public Geom_Curve
{

public:

  
  //! Returns number of curves
  Standard_EXPORT virtual   Standard_Integer NbCurves()  const = 0;
  
  //! Returns curve given by its index
  Standard_EXPORT virtual  const  Handle(Geom_Curve)& Curve (const Standard_Integer index)  const = 0;
  
  //! Returns number of the curve for the given parameter U
  //! and local paramete r UOut for the found curve
  Standard_EXPORT virtual   Standard_Integer LocateParameter (const Standard_Real U, Standard_Real& UOut)  const = 0;
  
  //! Returns global parameter for the whole curve according
  //! to the segment and local parameter on it
  Standard_EXPORT virtual   Standard_Real LocalToGlobal (const Standard_Integer index, const Standard_Real Ulocal)  const = 0;
  
  //! Applies transformation to each curve
  Standard_EXPORT virtual   void Transform (const gp_Trsf& T) ;
  
  //! Returns 1 - U
    virtual   Standard_Real ReversedParameter (const Standard_Real U)  const;
  
  //! Returns 0
    virtual   Standard_Real FirstParameter()  const;
  
  //! Returns 1
    virtual   Standard_Real LastParameter()  const;
  
  //! Returns True if the curve is closed
    virtual   Standard_Boolean IsClosed()  const;
  
  //! Returns False
    virtual   Standard_Boolean IsPeriodic()  const;
  
  //! Returns GeomAbs_C0
    virtual   GeomAbs_Shape Continuity()  const;
  
  //! Returns False if N > 0
    virtual   Standard_Boolean IsCN (const Standard_Integer N)  const;
  
  //! Returns point at parameter U.
  //! Finds appropriate curve and local parameter on it.
  Standard_EXPORT virtual   void D0 (const Standard_Real U, gp_Pnt& P)  const;
  
  Standard_EXPORT virtual   void D1 (const Standard_Real U, gp_Pnt& P, gp_Vec& V1)  const;
  
  Standard_EXPORT virtual   void D2 (const Standard_Real U, gp_Pnt& P, gp_Vec& V1, gp_Vec& V2)  const;
  
  Standard_EXPORT virtual   void D3 (const Standard_Real U, gp_Pnt& P, gp_Vec& V1, gp_Vec& V2, gp_Vec& V3)  const;
  
  Standard_EXPORT virtual   gp_Vec DN (const Standard_Real U, const Standard_Integer N)  const;
  
  //! Returns scale factor for recomputing of deviatives.
  Standard_EXPORT virtual   Standard_Real GetScaleFactor (const Standard_Integer ind)  const = 0;
  
  //! Checks geometrical connectivity of the curves, including
  //! closure (sets fields myClosed)
  Standard_EXPORT   Standard_Boolean CheckConnectivity (const Standard_Real Preci) ;




  DEFINE_STANDARD_RTTI(ShapeExtend_ComplexCurve)

protected:

  
  Standard_EXPORT ShapeExtend_ComplexCurve();
  
  //! Transform the derivative according to its order
  Standard_EXPORT   void TransformDN (gp_Vec& V, const Standard_Integer ind, const Standard_Integer N)  const;

  Standard_Boolean myClosed;


private: 




};


#include <ShapeExtend_ComplexCurve.lxx>





#endif // _ShapeExtend_ComplexCurve_HeaderFile
