// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Units_Quantity_HeaderFile
#define _Units_Quantity_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_Units_Quantity.hxx>

#include <Handle_TCollection_HAsciiString.hxx>
#include <Handle_Units_Dimensions.hxx>
#include <Handle_Units_UnitsSequence.hxx>
#include <MMgt_TShared.hxx>
#include <Standard_CString.hxx>
#include <TCollection_AsciiString.hxx>
#include <Standard_Boolean.hxx>
#include <Standard_Integer.hxx>
class TCollection_HAsciiString;
class Units_Dimensions;
class Units_UnitsSequence;


//! This  class stores  in its  field all the possible
//! units of all the unit systems for a given physical
//! quantity. Each unit's  value  is  expressed in the
//! S.I. unit system.
class Units_Quantity : public MMgt_TShared
{

public:

  
  //! Creates  a new Quantity  object with <aname> which  is
  //! the name of the physical quantity, <adimensions> which
  //! is the physical dimensions, and <aunitssequence> which
  //! describes all the units known for this quantity.
    Units_Quantity(const Standard_CString aname, const Handle(Units_Dimensions)& adimensions, const Handle(Units_UnitsSequence)& aunitssequence);
  
  //! Returns in a AsciiString from TCollection the name of the quantity.
      TCollection_AsciiString Name()  const;
  
  //! Returns the physical dimensions of the quantity.
      Handle(Units_Dimensions) Dimensions()  const;
  
  //! Returns <theunitssequence>, which  is the  sequence of
  //! all the units stored for this physical quantity.
      Handle(Units_UnitsSequence) Sequence()  const;
  
  //! Returns True if the name of the Quantity <me> is equal
  //! to <astring>, False otherwise.
  Standard_EXPORT   Standard_Boolean IsEqual (const Standard_CString astring)  const;
  
  //! Useful for debugging.
  Standard_EXPORT   void Dump (const Standard_Integer ashift, const Standard_Integer alevel)  const;




  DEFINE_STANDARD_RTTI(Units_Quantity)

protected:




private: 


  Handle(TCollection_HAsciiString) thename;
  Handle(Units_Dimensions) thedimensions;
  Handle(Units_UnitsSequence) theunitssequence;


};


#include <Units_Quantity.lxx>





#endif // _Units_Quantity_HeaderFile
