/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.preverification;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.preverification.StackMapFrame;
import proguard.classfile.attribute.preverification.visitor.StackMapFrameVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;

public class StackMapTableAttribute
extends Attribute {
    public int u2stackMapFramesCount;
    public StackMapFrame[] stackMapFrames;

    public StackMapTableAttribute() {
    }

    public StackMapTableAttribute(StackMapFrame[] stackMapFrameArray) {
        this(stackMapFrameArray.length, stackMapFrameArray);
    }

    public StackMapTableAttribute(int n, StackMapFrame[] stackMapFrameArray) {
        this.u2stackMapFramesCount = n;
        this.stackMapFrames = stackMapFrameArray;
    }

    @Override
    public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, AttributeVisitor attributeVisitor) {
        attributeVisitor.visitStackMapTableAttribute(clazz, method, codeAttribute, this);
    }

    public void stackMapFramesAccept(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapFrameVisitor stackMapFrameVisitor) {
        int n = 0;
        for (int i = 0; i < this.u2stackMapFramesCount; ++i) {
            StackMapFrame stackMapFrame = this.stackMapFrames[i];
            stackMapFrame.accept(clazz, method, codeAttribute, n += stackMapFrame.getOffsetDelta() + (i == 0 ? 0 : 1), stackMapFrameVisitor);
        }
    }
}

