/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;

public class ExceptClassesFilter
implements ClassVisitor {
    private final Clazz[] exceptClasses;
    private final ClassVisitor classVisitor;

    public ExceptClassesFilter(Clazz[] clazzArray, ClassVisitor classVisitor) {
        this.exceptClasses = clazzArray;
        this.classVisitor = classVisitor;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        if (!this.present(programClass)) {
            this.classVisitor.visitProgramClass(programClass);
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        if (!this.present(libraryClass)) {
            this.classVisitor.visitLibraryClass(libraryClass);
        }
    }

    private boolean present(Clazz clazz) {
        if (this.exceptClasses == null) {
            return false;
        }
        for (int i = 0; i < this.exceptClasses.length; ++i) {
            if (!this.exceptClasses[i].equals(clazz)) continue;
            return true;
        }
        return false;
    }
}

