/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.selection;

import com.google.common.base.Preconditions;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.protege.editor.core.util.HandlerRegistration;
import org.protege.editor.owl.model.selection.OWLSelectionModel;
import org.protege.editor.owl.model.selection.SelectionDriver;
import org.protege.editor.owl.model.selection.SelectionPlane;
import org.semanticweb.owlapi.model.OWLObject;

public class SelectionPlaneImpl
implements SelectionPlane {
    private final List<SelectionDriver> selectionDrivers = new ArrayList<SelectionDriver>();
    private final OWLSelectionModel selectionModel;
    private Optional<SelectionDriver> lastSelectionDriver = Optional.empty();
    private final List<SelectionDriver> lastShowingDrivers = new ArrayList<SelectionDriver>();
    private HierarchyListener hierarchyListener = e -> this.handleHierarchyChange();

    public SelectionPlaneImpl(@Nonnull OWLSelectionModel selectionModel) {
        this.selectionModel = (OWLSelectionModel)Preconditions.checkNotNull((Object)selectionModel);
    }

    @Override
    public HandlerRegistration registerSelectionDriver(@Nonnull SelectionDriver driver) {
        Preconditions.checkNotNull((Object)driver);
        if (this.selectionDrivers.contains(driver)) {
            return () -> {};
        }
        this.selectionDrivers.add(driver);
        driver.asComponent().addHierarchyListener(this.hierarchyListener);
        this.handleHierarchyChange();
        return () -> {
            this.selectionDrivers.remove(driver);
            if (this.lastShowingDrivers.remove(driver)) {
                this.lastShowingDrivers.clear();
            }
            driver.asComponent().removeHierarchyListener(this.hierarchyListener);
        };
    }

    @Override
    public void transmitSelection(@Nonnull SelectionDriver driver, OWLObject selection) {
        Preconditions.checkNotNull((Object)driver);
        this.lastSelectionDriver = Optional.of(driver);
        this.selectionModel.setSelectedObject(selection);
    }

    private void handleHierarchyChange() {
        List showingDrivers = this.selectionDrivers.stream().filter(driver -> driver.asComponent().isShowing()).collect(Collectors.toList());
        if (this.lastShowingDrivers.equals(showingDrivers)) {
            return;
        }
        this.lastShowingDrivers.clear();
        this.lastShowingDrivers.addAll(showingDrivers);
        if (showingDrivers.isEmpty()) {
            return;
        }
        if (showingDrivers.size() == 1) {
            OWLObject sel = ((SelectionDriver)showingDrivers.get(0)).getSelection().orElse(null);
            this.selectionModel.setSelectedObject(sel);
        } else if (this.lastSelectionDriver.isPresent() && showingDrivers.contains(this.lastSelectionDriver.get())) {
            OWLObject sel = this.lastSelectionDriver.get().getSelection().orElse(null);
            this.selectionModel.setSelectedObject(sel);
        } else {
            OWLObject sel = ((SelectionDriver)showingDrivers.get(0)).getSelection().orElse(null);
            this.selectionModel.setSelectedObject(sel);
        }
    }
}

