/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.hierarchy.creation;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.protege.editor.core.ui.wizard.WizardPanel;
import org.protege.editor.core.util.Recommendation;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.AbstractOWLWizardPanel;
import org.semanticweb.owlapi.model.EntityType;

public class MakeSiblingsDisjointPanel
extends AbstractOWLWizardPanel {
    public static final String ID = "MakeSiblingsDisjointPanel";
    private final JCheckBox checkBox;
    private final EntityType<?> entityType;
    private final Recommendation recommendation;

    public MakeSiblingsDisjointPanel(OWLEditorKit owlEditorKit, EntityType<?> entityType, Recommendation recommendation) {
        super(ID, String.format("Make sibling %s disjoint?", entityType.getPluralPrintName().toLowerCase()), owlEditorKit);
        this.checkBox = new JCheckBox(String.format("Do you want to make sibling %s disjoint? (%s)", entityType.getPluralPrintName().toLowerCase(), recommendation.getPrintName()), recommendation == Recommendation.RECOMMENDED);
        this.checkBox.setBackground(null);
        this.entityType = entityType;
        this.recommendation = recommendation;
        this.setInstructions(String.format("Do you want to make sibling %s disjoint? (%s)", entityType.getPluralPrintName().toLowerCase(), recommendation.getPrintName()));
        JPanel parent = new JPanel(new BorderLayout());
        parent.add((Component)this.checkBox, "North");
        this.setContent(parent);
    }

    public boolean isMakeSiblingsDisjoint() {
        return this.checkBox.isSelected();
    }

    @Deprecated
    public boolean isMakeSiblingClassesDisjoint() {
        return this.checkBox.isSelected();
    }

    public void displayingPanel() {
        this.checkBox.requestFocus();
    }

    public Object getNextPanelDescriptor() {
        return WizardPanel.FINISH;
    }

    public Object getBackPanelDescriptor() {
        return "TabIndentedHierarchyPanel";
    }
}

