/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer.layout;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.protege.editor.owl.ui.renderer.layout.Link;
import org.protege.editor.owl.ui.renderer.layout.LinkBox;
import org.protege.editor.owl.ui.renderer.layout.PageObject;

public class IconBox
extends PageObject {
    public static final Font FONT = new Font("sans-serif", 0, 20);
    private Icon image;
    private int maxHeight = -1;
    private LinkBox linkBox = null;
    private static final String warningIcon = "\u26a0";

    public IconBox(Icon image) {
        this.image = image;
    }

    public IconBox(Icon image, Link link) {
        this.image = image;
        this.linkBox = new LinkBox(link);
        this.add(this.linkBox);
    }

    @Override
    public void layout(FontRenderContext fontRenderContext) {
        if (this.isErrored()) {
            this.setWidth(26);
            this.setHeight(26);
        } else if (this.maxHeight < 0) {
            this.setHeight(this.image.getIconHeight());
            this.setWidth(this.image.getIconWidth());
        } else {
            this.setHeight(this.maxHeight);
            double scaleFactor = (double)this.maxHeight * 1.0 / (double)this.image.getIconHeight();
            this.setWidth((int)(scaleFactor * (double)this.image.getIconWidth()));
        }
        if (this.linkBox != null) {
            this.linkBox.setX(0);
            this.linkBox.setY(0);
            this.linkBox.setWidth(this.getWidth());
            this.linkBox.setHeight(this.getHeight());
        }
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    @Override
    protected void paintContent(Graphics2D g2) {
        boolean errored = this.isErrored();
        if (!errored) {
            int imageHeight = this.image.getIconHeight();
            if (this.getHeight() != imageHeight) {
                double scaleFactor = (double)this.getHeight() * 1.0 / (double)imageHeight;
                g2.scale(scaleFactor, scaleFactor);
            }
            this.image.paintIcon(null, g2, 0, 0);
            g2.scale(1.0, 1.0);
        } else {
            g2.setFont(FONT);
            FontMetrics fm = g2.getFontMetrics();
            g2.setColor(Color.ORANGE);
            int x = (int)((double)(this.getWidth() / 2) - fm.getStringBounds(warningIcon, g2).getWidth() / 2.0);
            int ascent = fm.getAscent();
            int descent = fm.getDescent();
            int y = this.getHeight() / 2 - (ascent + descent) / 2 + ascent;
            g2.drawString(warningIcon, x, y);
            g2.drawRect(1, 1, this.getWidth() - 1, this.getHeight() - 2);
        }
    }

    private boolean isErrored() {
        return !(this.image instanceof ImageIcon) || ((ImageIcon)this.image).getImageLoadStatus() == 4;
    }
}

