/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import org.protege.editor.core.log.LogRecord;
import org.protege.editor.core.log.ThrowableInfo;

public final class LogRecordElement {
    private final LogRecord logRecord;

    public LogRecordElement(LogRecord logRecord) {
        this.logRecord = logRecord;
    }

    public LogRecord getLogRecord() {
        return this.logRecord;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.format("Level:       %s\n", new Object[]{this.logRecord.getLogLevel()});
        pw.format("Time:        %s\n", this.logRecord.getTimestamp());
        pw.format("Message:     %s\n", this.logRecord.getFormattedMessage());
        Optional<ThrowableInfo> throwableInfo = this.logRecord.getThrowableInfo();
        if (throwableInfo.isPresent()) {
            pw.format("%s\n", throwableInfo.get().getClassName());
            pw.format("StackTrace:  \n", new Object[0]);
            LogRecordElement.formatThrowableInfo(1, pw, throwableInfo);
        }
        pw.flush();
        return sw.toString();
    }

    private static void formatThrowableInfo(int level, PrintWriter pw, Optional<ThrowableInfo> throwableInfo) {
        if (!throwableInfo.isPresent()) {
            return;
        }
        ThrowableInfo info = throwableInfo.get();
        for (StackTraceElement e : info.getStackTrace()) {
            for (int i = 0; i < level; ++i) {
                pw.format("    ", new Object[0]);
            }
            pw.format("%s\n", e.toString());
        }
        if (info.getCause().isPresent()) {
            pw.format("          Caused by:\n", new Object[0]);
            LogRecordElement.formatThrowableInfo(level + 1, pw, info.getCause());
        }
    }

    public int hashCode() {
        return this.logRecord.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LogRecordElement)) {
            return false;
        }
        LogRecordElement other = (LogRecordElement)obj;
        return this.logRecord.equals(other.logRecord);
    }
}

