/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.change;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.change.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class ConvertSuperClassesToEquivalentClass
extends AbstractCompositeOntologyChange {
    private static final long serialVersionUID = 40000L;

    public ConvertSuperClassesToEquivalentClass(@Nonnull OWLDataFactory dataFactory, @Nonnull OWLClass cls, @Nonnull Set<OWLOntology> ontologies, @Nonnull OWLOntology targetOntology) {
        super(dataFactory);
        this.generateChanges(OWLAPIPreconditions.checkNotNull(targetOntology, "targetOntology cannot be null"), OWLAPIPreconditions.checkNotNull(cls, "cls cannot be null"), OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null"));
    }

    private void generateChanges(@Nonnull OWLOntology targetOntology, @Nonnull OWLClass cls, @Nonnull Set<OWLOntology> ontologies) {
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        for (OWLOntology ont : ontologies) {
            assert (ont != null);
            for (OWLSubClassOfAxiom ax : ont.getSubClassAxiomsForSubClass(cls)) {
                assert (ax != null);
                this.addChange(new RemoveAxiom(ont, ax));
                descs.add(ax.getSuperClass());
            }
        }
        OWLObjectIntersectionOf equivalentClass = this.getDataFactory().getOWLObjectIntersectionOf(descs);
        HashSet<OWLClassExpression> equivalentClasses = new HashSet<OWLClassExpression>();
        equivalentClasses.add(cls);
        equivalentClasses.add(equivalentClass);
        this.addChange(new AddAxiom(targetOntology, this.getDataFactory().getOWLEquivalentClassesAxiom(equivalentClasses)));
    }
}

