/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.ToStringRenderer;
import org.semanticweb.owlapi.model.HasAnonymousIndividuals;
import org.semanticweb.owlapi.model.HasSignature;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.HashCode;
import org.semanticweb.owlapi.util.OWLClassExpressionCollector;
import org.semanticweb.owlapi.util.OWLObjectTypeIndexProvider;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import uk.ac.manchester.cs.owl.owlapi.HasIncrementalSignatureGenerationSupport;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLClassImpl;

public abstract class OWLObjectImplWithoutEntityAndAnonCaching
implements OWLObject,
HasIncrementalSignatureGenerationSupport,
Serializable {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    protected static final Set<OWLAnnotation> NO_ANNOTATIONS = CollectionFactory.emptySet();
    static final OWLObjectTypeIndexProvider OWLOBJECT_TYPEINDEX_PROVIDER = new OWLObjectTypeIndexProvider();
    protected int hashCode = 0;
    @Nonnull
    protected static final OWLClass OWL_THING = new OWLClassImpl(OWLRDFVocabulary.OWL_THING.getIRI());

    private static void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    @Override
    @Nonnull
    public Set<OWLAnonymousIndividual> getAnonymousIndividuals() {
        HashSet<OWLAnonymousIndividual> result = new HashSet<OWLAnonymousIndividual>();
        this.addAnonymousIndividualsToSet(result);
        return result;
    }

    @Override
    @Nonnull
    public Set<OWLEntity> getSignature() {
        HashSet<OWLEntity> result = new HashSet<OWLEntity>();
        this.addSignatureEntitiesToSet(result);
        return result;
    }

    protected static void addEntitiesFromAnnotationsToSet(Collection<OWLAnnotation> annotations, Set<OWLEntity> entities) {
        for (OWLAnnotation annotation : annotations) {
            if (annotation instanceof OWLAnnotationImpl) {
                OWLAnnotationImpl owlAnnotation = (OWLAnnotationImpl)annotation;
                owlAnnotation.addSignatureEntitiesToSet(entities);
                continue;
            }
            entities.addAll(annotation.getSignature());
        }
    }

    protected static void addAnonymousIndividualsFromAnnotationsToSet(Collection<OWLAnnotation> annotations, Set<OWLAnonymousIndividual> anons) {
        for (OWLAnnotation annotation : annotations) {
            if (annotation instanceof OWLAnnotationImpl) {
                OWLAnnotationImpl owlAnnotation = (OWLAnnotationImpl)annotation;
                owlAnnotation.addAnonymousIndividualsToSet(anons);
                continue;
            }
            anons.addAll(annotation.getAnonymousIndividuals());
        }
    }

    @Override
    public boolean containsEntityInSignature(@Nonnull OWLEntity owlEntity) {
        return this.getSignature().contains(owlEntity);
    }

    @Override
    public Set<OWLClass> getClassesInSignature() {
        HashSet<OWLClass> result = new HashSet<OWLClass>();
        for (OWLEntity ent : this.getSignature()) {
            if (!ent.isOWLClass()) continue;
            result.add(ent.asOWLClass());
        }
        return result;
    }

    @Override
    public Set<OWLDataProperty> getDataPropertiesInSignature() {
        HashSet<OWLDataProperty> result = new HashSet<OWLDataProperty>();
        for (OWLEntity ent : this.getSignature()) {
            if (!ent.isOWLDataProperty()) continue;
            result.add(ent.asOWLDataProperty());
        }
        return result;
    }

    @Override
    public Set<OWLObjectProperty> getObjectPropertiesInSignature() {
        HashSet<OWLObjectProperty> result = new HashSet<OWLObjectProperty>();
        for (OWLEntity ent : this.getSignature()) {
            if (!ent.isOWLObjectProperty()) continue;
            result.add(ent.asOWLObjectProperty());
        }
        return result;
    }

    @Override
    public Set<OWLNamedIndividual> getIndividualsInSignature() {
        HashSet<OWLNamedIndividual> result = new HashSet<OWLNamedIndividual>();
        for (OWLEntity ent : this.getSignature()) {
            if (!ent.isOWLNamedIndividual()) continue;
            result.add(ent.asOWLNamedIndividual());
        }
        return result;
    }

    @Override
    public Set<OWLDatatype> getDatatypesInSignature() {
        HashSet<OWLDatatype> result = new HashSet<OWLDatatype>();
        for (OWLEntity ent : this.getSignature()) {
            if (!ent.isOWLDatatype()) continue;
            result.add(ent.asOWLDatatype());
        }
        return result;
    }

    @Override
    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature() {
        HashSet<OWLAnnotationProperty> result = new HashSet<OWLAnnotationProperty>();
        for (OWLEntity ent : this.getSignature()) {
            if (!ent.isOWLAnnotationProperty()) continue;
            result.add(ent.asOWLAnnotationProperty());
        }
        return result;
    }

    @Override
    public Set<OWLClassExpression> getNestedClassExpressions() {
        OWLClassExpressionCollector collector = new OWLClassExpressionCollector();
        return this.accept(collector);
    }

    protected void addSignatureEntitiesToSetForValue(Set<OWLEntity> entities, HasSignature canHasSignature) {
        if (canHasSignature instanceof HasIncrementalSignatureGenerationSupport) {
            HasIncrementalSignatureGenerationSupport hasIncrementalSignatureGenerationSupport = (HasIncrementalSignatureGenerationSupport)((Object)canHasSignature);
            hasIncrementalSignatureGenerationSupport.addSignatureEntitiesToSet(entities);
        } else {
            entities.addAll(canHasSignature.getSignature());
        }
    }

    protected void addAnonymousIndividualsToSetForValue(Set<OWLAnonymousIndividual> anons, HasAnonymousIndividuals canHasAnons) {
        if (canHasAnons instanceof HasIncrementalSignatureGenerationSupport) {
            HasIncrementalSignatureGenerationSupport hasIncrementalSignatureGenerationSupport = (HasIncrementalSignatureGenerationSupport)((Object)canHasAnons);
            hasIncrementalSignatureGenerationSupport.addAnonymousIndividualsToSet(anons);
        } else {
            anons.addAll(canHasAnons.getAnonymousIndividuals());
        }
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof OWLObject;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = HashCode.hashCode(this);
        }
        return this.hashCode;
    }

    protected abstract int index();

    @Override
    public int compareTo(OWLObject o) {
        int thisTypeIndex = this.index();
        int otherTypeIndex = 0;
        otherTypeIndex = o instanceof OWLObjectImplWithoutEntityAndAnonCaching ? ((OWLObjectImplWithoutEntityAndAnonCaching)o).index() : OWLOBJECT_TYPEINDEX_PROVIDER.getTypeIndex(o);
        int diff = thisTypeIndex - otherTypeIndex;
        if (diff != 0) {
            return diff;
        }
        diff = this.compareObjectOfSameType(o);
        if (diff != 0) {
            return diff;
        }
        if (this instanceof OWLAxiom) {
            diff = OWLObjectImplWithoutEntityAndAnonCaching.compareLists(new ArrayList<OWLAnnotation>(((OWLAxiom)((Object)this)).getAnnotations()), new ArrayList<OWLAnnotation>(((OWLAxiom)o).getAnnotations()));
        }
        return diff;
    }

    protected int compareAnnotations(List<OWLAnnotation> l1, List<OWLAnnotation> l2) {
        int i;
        for (i = 0; i < l1.size() && i < l2.size(); ++i) {
            int diff = l1.get(i).compareTo(l2.get(i));
            if (diff == 0) continue;
            return diff;
        }
        if (i < l2.size()) {
            return -1;
        }
        if (i < l1.size()) {
            return 1;
        }
        return 0;
    }

    protected abstract int compareObjectOfSameType(@Nonnull OWLObject var1);

    @Override
    @Nonnull
    public String toString() {
        return ToStringRenderer.getInstance().getRendering(this);
    }

    @Override
    public boolean isTopEntity() {
        return false;
    }

    @Override
    public boolean isBottomEntity() {
        return false;
    }

    protected static int compareSets(Collection<? extends OWLObject> set1, Collection<? extends OWLObject> set2) {
        TreeSet<? extends OWLObject> ss1 = set1 instanceof SortedSet ? (TreeSet<? extends OWLObject>)set1 : new TreeSet<OWLObject>(set1);
        TreeSet<? extends OWLObject> ss2 = set2 instanceof SortedSet ? (TreeSet<? extends OWLObject>)set2 : new TreeSet<OWLObject>(set2);
        Iterator thisIt = ss1.iterator();
        Iterator otherIt = ss2.iterator();
        for (int i = 0; i < ss1.size() && i < ss2.size(); ++i) {
            OWLObject o2;
            OWLObject o1 = (OWLObject)thisIt.next();
            int diff = o1.compareTo(o2 = (OWLObject)otherIt.next());
            if (diff == 0) continue;
            return diff;
        }
        return ss1.size() - ss2.size();
    }

    protected static int compareLists(List<? extends OWLObject> list1, List<? extends OWLObject> list2) {
        int size;
        int n = size = list1.size() < list2.size() ? list1.size() : list2.size();
        for (int i = 0; i < size; ++i) {
            OWLObject o2;
            OWLObject o1 = list1.get(i);
            int diff = o1.compareTo(o2 = list2.get(i));
            if (diff == 0) continue;
            return diff;
        }
        return list1.size() - list2.size();
    }
}

