/****************************************************************************
**
** Copyright (C) 2015 The Qt Company Ltd and/or its subsidiary(-ies).
** Contact: http://www.qt-project.org/legal
**
** This file is part of the Qt Mobility Components.
**
** $QT_BEGIN_LICENSE:LGPL21$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see http://www.qt.io/terms-conditions. For further
** information use the contact form at http://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 or version 3 as published by the Free
** Software Foundation and appearing in the file LICENSE.LGPLv21 and
** LICENSE.LGPLv3 included in the packaging of this file. Please review the
** following information to ensure the GNU Lesser General Public License
** requirements will be met: https://www.gnu.org/licenses/lgpl.html and
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** As a special exception, The Qt Company gives you certain additional
** rights. These rights are described in The Qt Company LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef QSYSTEMALIGNEDTIMER_MEEGO_P_H
#define QSYSTEMALIGNEDTIMER_MEEGO_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include "qsystemalignedtimer.h"

#include <QSocketNotifier>

extern "C" {
#include <iphbd/libiphb.h>
}

QT_BEGIN_HEADER
QTM_BEGIN_NAMESPACE

class QSystemAlignedTimerPrivate : public QObject
{
    Q_OBJECT

public:
    explicit QSystemAlignedTimerPrivate(QObject *parent = 0);
    ~QSystemAlignedTimerPrivate();

public:
    void wokeUp();

    int minimumInterval() const;
    void setMinimumInterval(int seconds);

    int maximumInterval() const;
    void setMaximumInterval(int seconds);

    bool isSingleShot() const;
    void setSingleShot(bool singleShot);

    static void singleShot(int minimumTime, int maximumTime, QObject *receiver, const char *member);
    QSystemAlignedTimer::AlignedTimerError lastError() const;

    bool isActive() const;
    QSystemAlignedTimer::AlignedTimerError m_lastError;

Q_SIGNALS:
    void timeout();
    void error(QSystemAlignedTimer::AlignedTimerError error);

private:
    int m_minimumInterval;
    int m_maximumInterval;
    bool m_running;
    bool m_singleShot;
    iphb_t m_iphbdHandler;
    QSocketNotifier *m_notifier;

public Q_SLOTS:
    void start(int minimumTime, int maximumTime);
    void start();
    void stop();

private Q_SLOTS:
    void heartbeatReceived(int sock);
};

QTM_END_NAMESPACE
QT_END_HEADER

#endif // QSYSTEMALIGNEDTIMER_MEEGO_P_H
