/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.tools.analyser;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.HashMap;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.tools.analyser.DependencyAnalyser;
import org.apache.ivy.tools.analyser.JarModule;
import org.apache.ivy.tools.analyser.JarModuleFinder;
import org.apache.ivy.util.Message;

public class JarJarDependencyAnalyser
implements DependencyAnalyser {
    private File jarjarjarLocation;

    public JarJarDependencyAnalyser(File file) {
        this.jarjarjarLocation = file;
    }

    @Override
    public ModuleDescriptor[] analyze(JarModule[] jarModuleArray) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer("java -jar \"").append(this.jarjarjarLocation.getAbsolutePath()).append("\" --find --level=jar ");
        HashMap<String, JarModule> hashMap = new HashMap<String, JarModule>();
        HashMap<ModuleRevisionId, Object> hashMap2 = new HashMap<ModuleRevisionId, Object>();
        for (int i = 0; i < jarModuleArray.length; ++i) {
            hashMap.put(jarModuleArray[i].getJar().getAbsolutePath(), jarModuleArray[i]);
            object = DefaultModuleDescriptor.newBasicInstance(jarModuleArray[i].getMrid(), new Date(jarModuleArray[i].getJar().lastModified()));
            hashMap2.put(jarModuleArray[i].getMrid(), object);
            stringBuffer.append("\"").append(jarModuleArray[i].getJar().getAbsolutePath()).append("\"");
            if (i + 1 >= jarModuleArray.length) continue;
            stringBuffer.append(File.pathSeparator);
        }
        Message.verbose("jarjar command: " + stringBuffer);
        try {
            String string;
            Process process = Runtime.getRuntime().exec(stringBuffer.toString());
            object = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string = ((BufferedReader)object).readLine()) != null) {
                String[] stringArray = string.split(" -> ");
                JarModule jarModule = (JarModule)hashMap.get(stringArray[0]);
                JarModule jarModule2 = (JarModule)hashMap.get(stringArray[1]);
                if (jarModule.getMrid().getModuleId().equals(jarModule2.getMrid().getModuleId())) continue;
                Message.verbose(jarModule.getMrid() + " depends on " + jarModule2.getMrid());
                DefaultModuleDescriptor defaultModuleDescriptor = (DefaultModuleDescriptor)hashMap2.get(jarModule.getMrid());
                DefaultDependencyDescriptor defaultDependencyDescriptor = new DefaultDependencyDescriptor(defaultModuleDescriptor, jarModule2.getMrid(), false, false, true);
                defaultDependencyDescriptor.addDependencyConfiguration("default", "default");
                defaultModuleDescriptor.addDependency(defaultDependencyDescriptor);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return hashMap2.values().toArray(new ModuleDescriptor[hashMap2.values().size()]);
    }

    public static void main(String[] stringArray) {
        JarJarDependencyAnalyser jarJarDependencyAnalyser = new JarJarDependencyAnalyser(new File("D:/temp/test2/jarjar-0.7.jar"));
        jarJarDependencyAnalyser.analyze(new JarModuleFinder("D:/temp/test2/ivyrep/[organisation]/[module]/[revision]/[artifact].[ext]").findJarModules());
    }
}

