/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.view;

import ch.ehi.basics.i18n.ResourceBundle;
import ch.softenvironment.client.ResourceManager;
import ch.softenvironment.util.Tracer;
import ch.softenvironment.view.BaseFrame;
import ch.softenvironment.view.CommonUserAccess;
import ch.softenvironment.view.ErrorDialog;
import ch.softenvironment.view.ViewOptions;
import ch.softenvironment.view.WaitDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public abstract class BaseDialog
extends JDialog {
    private JPanel ivjJDialogContentPane = null;
    private boolean saved = false;
    private ViewOptions viewOptions = null;

    protected BaseDialog(Component owner, boolean modal) {
        this(owner, modal, null);
    }

    public BaseDialog(Frame owner, boolean modal) {
        this(owner, modal, null);
    }

    public BaseDialog(Dialog owner, boolean modal) {
        this(owner, modal, null);
    }

    private BaseDialog(Component owner, boolean modal, ViewOptions viewOptions) {
        super(BaseDialog.getFrameOwner(owner), modal);
        this.setup(BaseDialog.getFrameOwner(owner), viewOptions);
    }

    public BaseDialog(Frame owner, boolean modal, ViewOptions viewOptions) {
        super(owner, modal);
        this.setup(owner, viewOptions);
    }

    public BaseDialog(Dialog owner, boolean modal, ViewOptions viewOptions) {
        super(owner, modal);
        this.setup(owner, viewOptions);
    }

    private void setup(Component owner, ViewOptions viewOptions) {
        this.viewOptions = viewOptions;
        this.setRelativeLocation(owner);
        this.initialize();
    }

    public static Frame getFrameOwner(Component owner) {
        for (Component comp = owner; comp != null; comp = comp.getParent()) {
            if (!(comp instanceof Frame)) continue;
            return (Frame)comp;
        }
        Tracer.getInstance().developerWarning("Dialog owner (Frame) not determinable");
        return null;
    }

    public static Dialog getDialogOwner(Component owner) {
        for (Component comp = owner; comp != null; comp = comp.getParent()) {
            if (!(comp instanceof Dialog)) continue;
            return (Dialog)comp;
        }
        Tracer.getInstance().developerWarning("Dialog owner (Dialog) not determinable");
        return null;
    }

    protected void applyPressed() {
        this.save();
    }

    protected void cancelPressed() {
        this.undo();
        this.dispose();
    }

    protected void genericPopupDisplay(MouseEvent event, JPopupMenu popupMenu) {
        BaseFrame.popupDisplay(this, event, popupMenu);
    }

    @Override
    public void dispose() {
        if (this.getViewOptions() != null) {
            this.getViewOptions().getViewManager().checkOut(this);
        }
        super.dispose();
    }

    protected final ViewOptions getViewOptions() {
        return this.viewOptions;
    }

    protected static String getApplyString() {
        return ResourceManager.getResource(BaseDialog.class, "BtnApply_text");
    }

    protected static String getAssignString() {
        return ResourceManager.getResource(BaseDialog.class, "BtnAssign_text");
    }

    protected static String getCancelString() {
        return ResourceManager.getResource(BaseDialog.class, "BtnCancel_text");
    }

    protected String getChangeWindowString() {
        return CommonUserAccess.getMniEditChangeWindowText();
    }

    protected String getDescriptionString() {
        return ResourceManager.getResource(BaseDialog.class, "CIDescription");
    }

    protected String getDetailString() {
        return ResourceManager.getResource(BaseDialog.class, "CIDetail");
    }

    private JPanel getJDialogContentPane() {
        if (this.ivjJDialogContentPane == null) {
            try {
                this.ivjJDialogContentPane = new JPanel();
                this.ivjJDialogContentPane.setName("JDialogContentPane");
                this.ivjJDialogContentPane.setLayout(null);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJDialogContentPane;
    }

    protected String getNewString() {
        return CommonUserAccess.getMniFileNewText();
    }

    protected static String getOKString() {
        return ResourceManager.getResource(BaseDialog.class, "BtnOK_text");
    }

    protected String getRemoveString() {
        return ResourceManager.getResource(BaseDialog.class, "BtnRemove_text");
    }

    protected String getResourceString(String propertyName) {
        return ResourceManager.getResource(this.getClass(), propertyName);
    }

    protected void handleException(Throwable exception) {
        BaseFrame.showException(this, exception);
    }

    private void initialize() {
        try {
            this.setName("BaseDialog");
            this.setDefaultCloseOperation(2);
            this.setSize(426, 240);
            this.setContentPane(this.getJDialogContentPane());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public boolean isSaved() {
        return this.saved;
    }

    protected void okPressed() {
        if (this.save()) {
            this.dispose();
        }
    }

    protected boolean save() {
        this.saved = true;
        return true;
    }

    public void setCenterLocation() {
        this.setCenterLocation(BaseFrame.getScreenSize());
    }

    private void setCenterLocation(Dimension outerSize) {
        Dimension frameSize = this.getSize();
        if (frameSize.height > outerSize.height) {
            frameSize.height = outerSize.height;
        }
        if (frameSize.width > outerSize.width) {
            frameSize.width = outerSize.width;
        }
        this.setLocation(new Point((outerSize.width - frameSize.width) / 2, (outerSize.height - frameSize.height) / 2));
    }

    protected void traceOnly(Throwable exception) {
        Tracer.getInstance().uncaughtException(exception);
    }

    protected void undo() {
    }

    public BaseDialog(Component owner, String title, boolean modal) {
        super(BaseDialog.getFrameOwner(owner), title, modal);
        this.setRelativeLocation(owner);
        this.initialize();
    }

    protected void setRelativeLocation(Component parent) {
        if (parent != null) {
            this.setLocation(new Point(parent.getX() + 50, parent.getY() + 50));
        }
    }

    public static boolean showConfirm(Component owner, String title, Object message) {
        Object[] options = new Object[]{ResourceManager.getResource(BaseDialog.class, "BtnYes_text"), ResourceManager.getResource(BaseDialog.class, "BtnNo_text")};
        return BaseDialog.showOptionPane(owner, title == null ? ResourceManager.getResource(BaseDialog.class, "CTQuestion") : title, message, options, "question-icon.gif") == 0;
    }

    public static Boolean showConfirmCancel(Component owner, String title, Object message) {
        Object[] options = new Object[]{ResourceManager.getResource(BaseDialog.class, "BtnYes_text"), ResourceManager.getResource(BaseDialog.class, "BtnNo_text"), BaseDialog.getCancelString()};
        int answer = BaseDialog.showOptionPane(owner, title == null ? ResourceManager.getResource(BaseDialog.class, "CTQuestion") : title, message, options, "question-icon.gif");
        switch (answer) {
            case 0: {
                return Boolean.TRUE;
            }
            case 1: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static boolean showConfirmDeletion(Component owner) {
        return BaseDialog.showConfirmDeletion(owner, ResourceManager.getResource(BaseDialog.class, "CTDeletion"), ResourceManager.getResource(BaseDialog.class, "CIQueryForDeletion"));
    }

    public static boolean showConfirmDeletion(Component owner, String title, Object message) {
        Object[] options = new Object[]{ResourceManager.getResource(BaseDialog.class, "BtnYes_text"), ResourceManager.getResource(BaseDialog.class, "BtnNo_text")};
        return BaseDialog.showOptionPane(owner, title == null ? ResourceManager.getResource(BaseDialog.class, "CTDeletion") : title, message, options, "dustbin.png") == 0;
    }

    public static Boolean showConfirmExit(Component owner) {
        return BaseDialog.showConfirmCancel(owner, CommonUserAccess.getTitleSaveChanges(), CommonUserAccess.getQuestionSaveChanges());
    }

    public static void showError(Component owner, String title, Object message, Throwable exception) {
        Frame frame = BaseDialog.getFrameOwner(owner);
        if (frame != null) {
            new ErrorDialog(frame, title, message == null ? null : message.toString(), exception);
        } else {
            new ErrorDialog(BaseDialog.getDialogOwner(owner), title, message == null ? null : message.toString(), exception);
        }
    }

    private static int showOptionPane(Component owner, String title, Object message, Object[] options, String iconFile) {
        try {
            return JOptionPane.showOptionDialog(owner, message, title, -1, -1, ResourceBundle.getImageIcon(BaseDialog.class, iconFile), options, options[0]);
        }
        catch (Throwable e) {
            Tracer.getInstance().developerError(e.getLocalizedMessage());
            return -1;
        }
    }

    public static void showWarning(Component owner, String title, Object message) {
        Object[] options = new Object[]{BaseDialog.getCancelString()};
        BaseDialog.showOptionPane(owner, title == null ? ResourceManager.getResource(BaseDialog.class, "CTWarning") : title, message, options, "warning-icon.gif");
    }

    protected final void showProgress(int percentage, String currentActivity) {
        WaitDialog.updateProgress(percentage, currentActivity);
    }
}

