/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.record.loop;

import java.io.IOException;
import java.util.TooManyListenersException;
import java.util.Vector;
import org.freehep.record.loop.LoopException;
import org.freehep.record.loop.LoopInterruptedException;
import org.freehep.record.loop.LoopSourceExhaustedException;
import org.freehep.record.loop.NoLoopRecordException;
import org.freehep.record.loop.SequentialRecordLoop;
import org.freehep.record.loop.event.ConfigurationEvent;
import org.freehep.record.loop.event.LoopEvent;
import org.freehep.record.loop.event.LoopProgressEvent;
import org.freehep.record.loop.event.RecordAdapter;
import org.freehep.record.loop.event.RecordEvent;
import org.freehep.record.loop.event.RecordListener;
import org.freehep.record.loop.event.RecordLoopListener;
import org.freehep.record.loop.event.RecordSuppliedEvent;
import org.freehep.record.source.EndOfSourceException;
import org.freehep.record.source.NoSuchRecordException;
import org.freehep.record.source.SequentialRecordSource;

public class SequentialRecordLoopImpl
implements SequentialRecordLoop {
    private static final RecordListener NULL_LISTENER = new RecordAdapter();
    private static final double MAX_PROGRESS = 1.0;
    private static final long IGNORE_PROGRESS = 1L;
    private static final long DEFAULT_MILLIS_INTERVAL = 2000L;
    private SequentialRecordSource source;
    private RecordListener listener = NULL_LISTENER;
    private Vector loopListeners = new Vector();
    private long totalSupplied;
    private long totalCountableSupplied;
    private long target;
    private long supplied;
    private long countableSupplied;
    private final RecordEvent recordEvent;
    private final LoopEvent loopEvent;
    private boolean interruptRequested;
    private boolean stoppedDueToInterrupt;
    private boolean newListener;
    private boolean newConfiguration;
    private Object configuration;
    private boolean sourceExhausted;
    private boolean noRecord;
    private Object currentRecord;
    private boolean countableRecord;
    private long recordInterval;
    private long lastProgressSupplied;
    private long millisInterval;
    private long lastProgressTime;

    public SequentialRecordLoopImpl() {
        this(null);
    }

    public SequentialRecordLoopImpl(SequentialRecordSource supplier) {
        this.source = supplier;
        this.recordEvent = new RecordEvent(this);
        this.loopEvent = new LoopEvent(this);
    }

    public void addRecordListener(RecordListener listener) throws TooManyListenersException {
        if (NULL_LISTENER != this.listener) {
            throw new TooManyListenersException("An RecordListener is already registers with this SequentialRecordLoop");
        }
        if (null == listener) {
            listener = NULL_LISTENER;
        } else {
            this.listener = listener;
        }
        this.newListener = true;
    }

    public void addRecordLoopListener(RecordLoopListener listener) {
        if (null == listener || this.loopListeners.contains(listener)) {
            return;
        }
        this.loopListeners.add(listener);
    }

    void beginLoop(long target) throws IllegalStateException {
        if (null == this.source) {
            throw new IllegalStateException("No SequentialRecordSource is set");
        }
        this.target = target;
        this.countableSupplied = 0L;
        this.sourceExhausted = false;
        this.noRecord = false;
        this.stoppedDueToInterrupt = false;
        int finished = this.loopListeners.size();
        for (int loopListener = 0; finished != loopListener; ++loopListener) {
            ((RecordLoopListener)this.loopListeners.get(loopListener)).loopBeginning(this.loopEvent);
        }
        if (this.newListener) {
            this.listener.configure(new ConfigurationEvent(this, this.configuration));
            this.newConfiguration = false;
            this.newListener = false;
        } else if (this.newConfiguration) {
            this.listener.reconfigure(new ConfigurationEvent(this, this.configuration));
            this.newConfiguration = false;
        } else {
            this.listener.resume(this.recordEvent);
        }
        this.fireProgress(0.0);
    }

    public void dispose() {
        this.removeRecordListener(this.listener);
    }

    public void doNotCount(Object record) {
        if (this.currentRecord != record) {
            return;
        }
        this.countableRecord = false;
    }

    long endLoop() throws LoopException {
        this.listener.suspend(this.recordEvent);
        this.fireProgress(this.getProgress());
        int finished = this.loopListeners.size();
        for (int loopListener = 0; finished != loopListener; ++loopListener) {
            ((RecordLoopListener)this.loopListeners.get(loopListener)).loopEnded(this.loopEvent);
        }
        if (this.stoppedDueToInterrupt || this.isInterruptRequested()) {
            this.setInterruptRequested(false);
            throw new LoopInterruptedException(this.getClass().getName() + " was interrupted after " + this.countableSupplied + " records supplied.", this.supplied, this.countableSupplied);
        }
        if (this.sourceExhausted && 0L <= this.target) {
            throw new LoopSourceExhaustedException("Source was exhausted after " + this.countableSupplied + " records supplied.", this.supplied, this.countableSupplied);
        }
        if (this.noRecord) {
            throw new NoLoopRecordException("Filed to find a reocrd after " + this.countableSupplied + " records supplied.", this.supplied, this.countableSupplied);
        }
        return this.countableSupplied;
    }

    private void fireProgress(double fraction) {
        this.lastProgressSupplied = this.totalSupplied;
        this.lastProgressTime = System.currentTimeMillis();
        LoopProgressEvent progressEvent = new LoopProgressEvent(this, fraction);
        int finished = this.loopListeners.size();
        for (int loopListener = 0; finished != loopListener; ++loopListener) {
            ((RecordLoopListener)this.loopListeners.get(loopListener)).progress(progressEvent);
        }
    }

    Object getNextRecord() throws IOException {
        Object result = null;
        if (this.isInterruptRequested()) {
            this.stoppedDueToInterrupt = true;
        } else {
            this.source.next();
            try {
                result = this.source.getCurrentRecord();
                if (null == result) {
                    throw new NullPointerException("'null' returned by SequenctialRecordSource getCurrentRecord() method");
                }
            }
            catch (EndOfSourceException e) {
                this.sourceExhausted = true;
                result = null;
            }
            catch (NoSuchRecordException e) {
                this.noRecord = true;
                result = null;
            }
        }
        return result;
    }

    private double getProgress() {
        if (0L == this.target) {
            return 1.0;
        }
        if (0L < this.target) {
            return (double)this.countableSupplied / (double)this.target;
        }
        if (0L == this.countableSupplied) {
            return 0.0;
        }
        long estimatedSize = this.source.getEstimatedSize();
        if (0L > estimatedSize) {
            return 0.5;
        }
        double progress = (double)this.supplied / (double)estimatedSize;
        if (1.0 < progress) {
            progress = 1.0;
        }
        return progress;
    }

    public RecordListener getRecordListener() {
        return this.listener;
    }

    public SequentialRecordSource getRecordSource() {
        return this.source;
    }

    public long getTotalSupplied() {
        return this.totalSupplied;
    }

    public long getTotalCountableSupplied() {
        return this.totalCountableSupplied;
    }

    boolean hasMoreRecords() {
        return !this.stoppedDueToInterrupt && this.target != this.countableSupplied && !this.sourceExhausted;
    }

    public synchronized boolean isInterruptRequested() {
        return this.interruptRequested;
    }

    public long loop(long number) throws LoopException, IOException {
        this.beginLoop(number);
        while (this.hasMoreRecords()) {
            this.supplyRecord(this.getNextRecord());
        }
        return this.endLoop();
    }

    public void removeRecordListener(RecordListener listener) {
        if (this.listener == listener) {
            if (!this.newListener) {
                listener.finish(this.recordEvent);
            }
            this.listener = NULL_LISTENER;
        }
    }

    public void removeRecordLoopListener(RecordLoopListener listener) {
        if (null == listener || !this.loopListeners.contains(listener)) {
            return;
        }
        this.loopListeners.remove(listener);
    }

    public void reset() throws IOException {
        this.source.rewind();
        if (!this.newListener) {
            this.listener.finish(this.recordEvent);
            this.newListener = true;
        }
        int finished = this.loopListeners.size();
        for (int loopListener = 0; finished != loopListener; ++loopListener) {
            ((RecordLoopListener)this.loopListeners.get(loopListener)).loopReset(this.loopEvent);
        }
    }

    public void setConfiguration(Object configuration) {
        this.configuration = configuration;
        this.newConfiguration = true;
    }

    public synchronized void setInterruptRequested(boolean interruptRequested) {
        this.interruptRequested = interruptRequested;
    }

    public void setProgessByRecords(long records) {
        this.recordInterval = records;
    }

    public void setProgessByTime(long milliseconds) {
        this.millisInterval = milliseconds;
    }

    public void setRecordSource(SequentialRecordSource supplier) {
        this.source = supplier;
    }

    void supplyRecord(Object record) {
        if (null == record) {
            return;
        }
        this.currentRecord = record;
        this.countableRecord = true;
        this.listener.recordSupplied(new RecordSuppliedEvent(this, record));
        this.currentRecord = null;
        ++this.totalSupplied;
        if (this.countableRecord) {
            ++this.totalCountableSupplied;
            ++this.supplied;
            ++this.countableSupplied;
        }
        this.source.releaseRecord(record);
        if (0 != this.loopListeners.size()) {
            long recordsRemaining = 0L < this.recordInterval ? this.recordInterval + this.lastProgressSupplied - this.totalSupplied : 1L;
            long millisRemaining = 0L < this.millisInterval ? this.millisInterval + this.lastProgressTime - System.currentTimeMillis() : 1L;
            if (0L >= recordsRemaining || 0L >= millisRemaining || 0L >= this.recordInterval && 0L >= this.millisInterval && 0L > 2000L - System.currentTimeMillis()) {
                this.fireProgress(this.getProgress());
            }
        }
    }
}

