/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.generator;

import ch.ehi.basics.io.IndentPrintWriter;
import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.ili2c.Main;
import ch.interlis.ili2c.generator.Interlis1Generator;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AbstractPatternDef;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.AttributePathType;
import ch.interlis.ili2c.metamodel.BlackboxType;
import ch.interlis.ili2c.metamodel.Cardinality;
import ch.interlis.ili2c.metamodel.ClassType;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Enumeration;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.FormattedType;
import ch.interlis.ili2c.metamodel.LineForm;
import ch.interlis.ili2c.metamodel.LineType;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.NumericOIDType;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.PolylineType;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.StructuredUnitType;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TextOIDType;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public final class Gml32Generator {
    public static final String ILIGML_XMLNSBASE = "http://www.interlis.ch/INTERLIS2.3/GML32";
    public static final String BASKETMEMBER = "member";
    public static final String TRANSFER = "TRANSFER";
    public static final String TRANSFERMEMBER = "baskets";
    public static final String ORDER_POS = "ORDER_POS";
    public static final String LINK_DATA = "LINK_DATA";
    IndentPrintWriter ipw;
    TransferDescription td;
    String outdir;
    int numErrors = 0;
    static ResourceBundle rsrc = ResourceBundle.getBundle(Interlis1Generator.class.getName(), Locale.getDefault());
    private Model currentModel = null;
    HashMap def2name = null;
    private ArrayList surfaceOrAreaAttrs = null;
    private ArrayList codelists = null;

    private Gml32Generator(TransferDescription td, String outdir) {
        this.td = td;
        this.outdir = outdir;
        this.setupNameMapping();
    }

    public static int generate(TransferDescription td, String outdir) {
        Gml32Generator d = new Gml32Generator(td, outdir);
        d.printXSD(td);
        return d.numErrors;
    }

    private static String getTransferName(Element elt) {
        if (elt instanceof Model) {
            return elt.getName();
        }
        if (elt instanceof Topic) {
            return elt.getScopedName(null);
        }
        if (elt instanceof Viewable) {
            return elt.getScopedName(null);
        }
        if (elt instanceof Domain) {
            return elt.getScopedName(null);
        }
        if (elt instanceof AttributeDef) {
            return elt.getName();
        }
        if (elt instanceof RoleDef) {
            return elt.getName();
        }
        throw new IllegalArgumentException();
    }

    private void printXSD(TransferDescription td) {
        for (Object mObj : td) {
            if (!(mObj instanceof Model) || mObj instanceof PredefinedModel) continue;
            Model model = (Model)mObj;
            this.printModel(model);
        }
    }

    private void setupNameMapping() {
        this.def2name = Gml32Generator.createDef2NameMapping(this.td);
    }

    public static HashMap createName2NameMapping(TransferDescription td) {
        HashMap def2name = Gml32Generator.createDef2NameMapping(td);
        HashMap ret = new HashMap();
        for (Element def : def2name.keySet()) {
            ret.put(def.getScopedName(null), def2name.get(def));
        }
        return ret;
    }

    public static HashMap createDef2NameMapping(TransferDescription td) {
        HashMap<Element, String> def2name = new HashMap<Element, String>();
        for (Object modelo : td) {
            if (!(modelo instanceof Model)) continue;
            Model model = (Model)modelo;
            HashMap<String, Element> name2def = new HashMap<String, Element>();
            for (Element topic : model) {
                String topicName = topic.getName();
                name2def.put(topicName, topic);
                def2name.put(topic, topicName);
            }
            for (Object topico : model) {
                if (!(topico instanceof Topic)) continue;
                Topic topic = (Topic)topico;
                String topicName = topic.getName();
                for (Element aclass : topic) {
                    String className = aclass.getName();
                    if (name2def.containsKey(className)) {
                        String scopedName = topicName + "." + className;
                        name2def.put(scopedName, aclass);
                        def2name.put(aclass, scopedName);
                        continue;
                    }
                    name2def.put(className, aclass);
                    def2name.put(aclass, className);
                }
            }
        }
        return def2name;
    }

    private String getScopedName(Element elt) {
        if (!this.def2name.containsKey(elt)) {
            throw new IllegalArgumentException("unexpected model element: " + elt.getScopedName(null));
        }
        Model eleModel = (Model)elt.getContainer(Model.class);
        String eleName = (String)this.def2name.get(elt);
        if (eleModel == this.currentModel) {
            return eleName;
        }
        return eleModel.getName() + ":" + eleName;
    }

    private String getName(Element elt) {
        if (!this.def2name.containsKey(elt)) {
            throw new IllegalArgumentException("unexpected model element: " + elt.getScopedName(null));
        }
        String eleName = (String)this.def2name.get(elt);
        return eleName;
    }

    private void printModel(Model model) {
        int modeli;
        String filename = this.outdir + "/" + model.getName() + ".xsd";
        try {
            this.ipw = new IndentPrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8")));
        }
        catch (IOException ex) {
            EhiLogger.logError(ex);
            return;
        }
        this.currentModel = model;
        this.codelists = new ArrayList();
        this.surfaceOrAreaAttrs = new ArrayList();
        this.ipw.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        this.ipw.println("<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        this.ipw.indent();
        this.ipw.println("xmlns=\"http://www.interlis.ch/INTERLIS2.3/GML32/" + model.getName() + "\"" + " targetNamespace=\"" + ILIGML_XMLNSBASE + "/" + model.getName() + "\"" + " elementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\"");
        this.ipw.println("xmlns:gml=\"http://www.opengis.net/gml/3.2\"");
        this.ipw.println("xmlns:INTERLIS=\"http://www.interlis.ch/INTERLIS2.3/GML32/INTERLIS\"");
        this.ipw.println("xmlns:ili2c=\"http://www.interlis.ch/ili2c\"");
        Model[] importedModels = model.getImporting();
        for (modeli = 0; modeli < importedModels.length; ++modeli) {
            if (importedModels[modeli] == this.td.INTERLIS) continue;
            this.ipw.println("xmlns:" + importedModels[modeli].getName() + "=\"" + ILIGML_XMLNSBASE + "/" + importedModels[modeli].getName() + "\"");
        }
        this.ipw.println(">");
        this.ipw.unindent();
        this.ipw.println("<xsd:annotation>");
        this.ipw.indent();
        this.ipw.print("<xsd:appinfo source=\"http://www.interlis.ch/ili2c/ili2cversion\">");
        this.ipw.print(Main.getVersion());
        this.ipw.println("</xsd:appinfo>");
        this.ipw.println("<xsd:appinfo source=\"http://www.interlis.ch/ili2c\">");
        this.ipw.indent();
        this.ipw.println("<ili2c:model>" + model.getName() + "</ili2c:model>");
        if (!model.getIliVersion().equals("1")) {
            this.ipw.println("<ili2c:modelVersion>" + model.getModelVersion() + "</ili2c:modelVersion>");
            if (model.getModelVersionExpl() != null) {
                this.ipw.println("<ili2c:modelVersionExplanation>" + model.getModelVersionExpl() + "</ili2c:modelVersionExplanation>");
            }
            this.ipw.println("<ili2c:modelAt>" + model.getIssuer() + "</ili2c:modelAt>");
        }
        this.ipw.unindent();
        this.ipw.println("</xsd:appinfo>");
        this.ipw.unindent();
        this.ipw.println("</xsd:annotation>");
        this.ipw.println("<xsd:import namespace=\"http://www.opengis.net/gml/3.2\"/>");
        this.ipw.println("<xsd:import namespace=\"http://www.interlis.ch/INTERLIS2.3/GML32/INTERLIS\"/>");
        for (modeli = 0; modeli < importedModels.length; ++modeli) {
            if (importedModels[modeli] == this.td.INTERLIS) continue;
            this.ipw.println("<xsd:import namespace=\"http://www.interlis.ch/INTERLIS2.3/GML32/" + importedModels[modeli].getName() + "\"/>");
        }
        for (Object tObj : model) {
            if (tObj instanceof Domain) {
                this.declareDomainDef((Domain)tObj);
            }
            if (tObj instanceof AbstractClassDef) {
                this.declareAbstractClassDef((AbstractClassDef)tObj);
            }
            if (tObj instanceof LineForm) {
                this.declareLineForm((LineForm)tObj);
            }
            if (!(tObj instanceof Topic)) continue;
            Topic topic = (Topic)tObj;
            this.declareTopic(topic);
        }
        this.declareLinetables();
        this.declareCodelists();
        this.ipw.println("</xsd:schema>");
        this.ipw.close();
    }

    private void declareTopic(Topic topic) {
        for (Object e : topic) {
            if (e instanceof Domain) {
                this.declareDomainDef((Domain)e);
            }
            if (!(e instanceof AbstractClassDef)) continue;
            this.declareAbstractClassDef((AbstractClassDef)e);
        }
        this.ipw.println("<xsd:complexType name=\"" + this.getName(topic) + "MemberType\">");
        this.ipw.indent();
        this.ipw.println("<xsd:complexContent>");
        this.ipw.indent();
        this.ipw.println("<xsd:extension base=\"gml:AbstractFeatureMemberType\">");
        this.ipw.indent();
        this.ipw.println("<xsd:sequence>");
        this.ipw.indent();
        this.ipw.println("<xsd:choice>");
        this.ipw.indent();
        for (Object object : topic.getViewables()) {
            if (!(object instanceof Viewable) || AbstractPatternDef.suppressViewableInTransfer((Viewable)object)) continue;
            Viewable v = (Viewable)object;
            this.ipw.println("<xsd:element ref=\"" + this.getScopedName(v) + "\"/>");
        }
        for (AttributeDef attr : this.surfaceOrAreaAttrs) {
            AbstractClassDef aclass = (AbstractClassDef)attr.getContainer();
            if (aclass.getContainer() != topic) continue;
            String linetableName = this.getName(aclass) + "." + Gml32Generator.getTransferName(attr);
            this.ipw.println("<xsd:element ref=\"" + linetableName + "\"/>");
        }
        this.ipw.unindent();
        this.ipw.println("</xsd:choice>");
        this.ipw.unindent();
        this.ipw.println("</xsd:sequence>");
        this.ipw.unindent();
        this.ipw.println("</xsd:extension>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexContent>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
        this.ipw.println("<xsd:element name=\"" + this.getName(topic) + "\" type=\"" + this.getName(topic) + "Type\" substitutionGroup=\"gml:AbstractFeature\"/>");
        this.ipw.println("<xsd:complexType name=\"" + this.getName(topic) + "Type\">");
        this.ipw.indent();
        this.ipw.println("<xsd:complexContent>");
        this.ipw.indent();
        this.ipw.println("<xsd:extension base=\"gml:AbstractFeatureType\">");
        this.ipw.indent();
        this.ipw.println("<xsd:sequence>");
        this.ipw.indent();
        this.ipw.println("<xsd:element name=\"member\" type=\"" + this.getName(topic) + "MemberType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>");
        this.ipw.unindent();
        this.ipw.println("</xsd:sequence>");
        this.ipw.println("<xsd:attributeGroup ref=\"gml:AggregationAttributeGroup\"/>");
        this.ipw.unindent();
        this.ipw.println("</xsd:extension>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexContent>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
    }

    private void declareAbstractClassDef(Viewable v) {
        if (v instanceof AssociationDef) {
            AssociationDef assoc = (AssociationDef)v;
            if (assoc.getDerivedFrom() != null) {
                return;
            }
            if (v.isFinal() && !v.getAttributes().hasNext() && assoc.isLightweight()) {
                return;
            }
        }
        String baseElement = "gml:AbstractFeature";
        Viewable baseType = (Viewable)v.getExtending();
        if (baseType != null) {
            baseElement = this.getScopedName(baseType);
        }
        this.ipw.println("<xsd:element name=\"" + this.getName(v) + "\" type=\"" + this.getName(v) + "Type\" substitutionGroup=\"" + baseElement + "\"/>");
        this.ipw.println("<xsd:complexType  name=\"" + this.getName(v) + "Type\">");
        this.ipw.indent();
        this.ipw.println("<xsd:complexContent>");
        this.ipw.indent();
        String baseXsdType = "gml:AbstractFeatureType";
        if (baseType != null) {
            baseXsdType = this.getScopedName(baseType) + "Type";
        }
        this.ipw.println("<xsd:extension base=\"" + baseXsdType + "\">");
        this.ipw.indent();
        this.ipw.println("<xsd:sequence>");
        this.ipw.indent();
        Iterator<ViewableTransferElement> iter = v.getAttributesAndRoles2();
        while (iter.hasNext()) {
            RoleDef oppend;
            AssociationDef roleOwner;
            AttributeDef attr;
            ViewableTransferElement obj = iter.next();
            if (obj.obj instanceof AttributeDef && (attr = (AttributeDef)obj.obj).getExtending() == null && attr.getContainer() == v && !attr.isTransient()) {
                this.declareAttribute(attr);
            }
            if (!(obj.obj instanceof RoleDef)) continue;
            RoleDef role = (RoleDef)obj.obj;
            if (!obj.embedded && !((AssociationDef)v).isLightweight() && v.getExtending() == null && role.getExtending() == null) {
                if (role.isOrdered()) {
                    this.ipw.println("<xsd:element name=\"" + Gml32Generator.getTransferName(role) + ">");
                } else {
                    this.ipw.println("<xsd:element name=\"" + Gml32Generator.getTransferName(role) + "\" type=\"gml:ReferenceType\">");
                }
                this.ipw.indent();
                this.ipw.println("<xsd:annotation>");
                this.ipw.indent();
                this.ipw.println("<xsd:appinfo>");
                this.ipw.indent();
                this.ipw.println("<gml:targetElement>" + this.getScopedName(role.getDestination()) + "</gml:targetElement>");
                this.ipw.unindent();
                this.ipw.println("</xsd:appinfo>");
                this.ipw.unindent();
                this.ipw.println("</xsd:annotation>");
                if (role.isOrdered()) {
                    this.ipw.println("<xsd:complexType>");
                    this.ipw.indent();
                    this.ipw.println("<xsd:sequence/>");
                    this.ipw.println("<xsd:attributeGroup ref=\"gml:OwnershipAttributeGroup\"/>");
                    this.ipw.println("<xsd:attributeGroup ref=\"gml:AssociationAttributeGroup\"/>");
                    this.ipw.println("<xsd:attribute ref=\"INTERLIS:ORDER_POS\"/>");
                    this.ipw.unindent();
                    this.ipw.println("</xsd:complexType>");
                }
                this.ipw.unindent();
                this.ipw.println("</xsd:element>");
            }
            if (!obj.embedded || (roleOwner = (AssociationDef)role.getContainer()).getDerivedFrom() != null || (oppend = role.getOppEnd()).getExtending() != null || oppend.getDestination() != v) continue;
            Cardinality card = role.getCardinality();
            String minOccurs = "";
            if (card.getMinimum() == 0L) {
                minOccurs = " minOccurs=\"0\"";
            }
            if (oppend.isOrdered()) {
                this.ipw.println("<xsd:element name=\"" + Gml32Generator.getTransferName(role) + "\"" + minOccurs + ">");
            } else {
                this.ipw.println("<xsd:element name=\"" + Gml32Generator.getTransferName(role) + "\" type=\"gml:ReferenceType\"" + minOccurs + ">");
            }
            this.ipw.indent();
            this.ipw.println("<xsd:annotation>");
            this.ipw.indent();
            this.ipw.println("<xsd:appinfo>");
            this.ipw.indent();
            this.ipw.println("<gml:targetElement>" + this.getScopedName(role.getDestination()) + "</gml:targetElement>");
            this.ipw.unindent();
            this.ipw.println("</xsd:appinfo>");
            this.ipw.unindent();
            this.ipw.println("</xsd:annotation>");
            if (oppend.isOrdered()) {
                this.ipw.println("<xsd:complexType>");
                this.ipw.indent();
                this.ipw.println("<xsd:sequence/>");
                this.ipw.println("<xsd:attributeGroup ref=\"gml:OwnershipAttributeGroup\"/>");
                this.ipw.println("<xsd:attributeGroup ref=\"gml:AssociationAttributeGroup\"/>");
                this.ipw.println("<xsd:attribute ref=\"INTERLIS:ORDER_POS\"/>");
                this.ipw.unindent();
                this.ipw.println("</xsd:complexType>");
            }
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
            if (roleOwner.isFinal() && !roleOwner.getAttributes().hasNext()) continue;
            this.ipw.println("<xsd:element name=\"" + Gml32Generator.getTransferName(role) + "." + LINK_DATA + "\" minOccurs=\"0\">");
            this.ipw.indent();
            this.ipw.println("<xsd:complexType>");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element ref=\"" + this.getScopedName(roleOwner) + "\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
        }
        this.ipw.unindent();
        this.ipw.println("</xsd:sequence>");
        this.ipw.unindent();
        this.ipw.println("</xsd:extension>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexContent>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
    }

    private void declareDomainDef(Domain domain) {
        Type type = domain.getType();
        if (type instanceof TypeAlias) {
            Domain realDomain = ((TypeAlias)type).getAliasing();
            Type realType = realDomain.getType();
            String base = null;
            String facets = null;
            if (realDomain == this.td.INTERLIS.URI) {
                base = "xsd:anyURI";
                facets = "<xsd:maxLength value=\"1023\"/>";
            } else if (realDomain == this.td.INTERLIS.NAME) {
                base = "xsd:token";
                facets = "<xsd:maxLength value=\"255\"/><xsd:pattern value=\"[a-zA-Z][a-zA-Z0-9_]*\"/>";
            } else if (realDomain == this.td.INTERLIS.INTERLIS_1_DATE) {
                base = "xsd:token";
                facets = "<xsd:maxLength value=\"8\"/><xsd:pattern value=\"[0-9]*\"/>";
            } else if (realDomain == this.td.INTERLIS.BOOLEAN) {
                base = "xsd:boolean";
            } else if (realDomain == this.td.INTERLIS.HALIGNMENT) {
                base = "INTERLIS:HALIGNMENT";
            } else if (realDomain == this.td.INTERLIS.VALIGNMENT) {
                base = "INTERLIS:VALIGNMENT";
            } else {
                throw new IllegalArgumentException(realDomain.getScopedName(null) + ": type " + type.getClass() + " not yet supported");
            }
            this.ipw.println("<xsd:simpleType name=\"" + this.getName(domain) + "\">");
            this.ipw.indent();
            if (facets == null) {
                this.ipw.println("<xsd:restriction base=\"" + base + "\"/>");
            } else {
                this.ipw.println("<xsd:restriction base=\"" + base + "\">");
                this.ipw.indent();
                this.ipw.println(facets);
                this.ipw.unindent();
                this.ipw.println("</xsd:restriction>");
            }
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        } else {
            this.declareType(type, domain);
        }
    }

    private void declareLinetables() {
        for (AttributeDef attr : this.surfaceOrAreaAttrs) {
            AbstractClassDef aclass = (AbstractClassDef)attr.getContainer();
            String linetableName = this.getName(aclass) + "." + Gml32Generator.getTransferName(attr);
            String baseElement = "gml:AbstractFeature";
            this.ipw.println("<xsd:element name=\"" + linetableName + "\" type=\"" + linetableName + "Type\" substitutionGroup=\"" + baseElement + "\"/>");
            this.ipw.println("<xsd:complexType  name=\"" + linetableName + "Type\">");
            this.ipw.indent();
            this.ipw.println("<xsd:complexContent>");
            this.ipw.indent();
            String baseXsdType = "gml:AbstractFeatureType";
            this.ipw.println("<xsd:extension base=\"" + baseXsdType + "\">");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element name=\"mainTable\" type=\"gml:ReferenceType\">");
            this.ipw.indent();
            this.ipw.println("<xsd:annotation>");
            this.ipw.indent();
            this.ipw.println("<xsd:appinfo>");
            this.ipw.indent();
            this.ipw.println("<gml:targetElement>" + this.getName(aclass) + "</gml:targetElement>");
            this.ipw.unindent();
            this.ipw.println("</xsd:appinfo>");
            this.ipw.unindent();
            this.ipw.println("</xsd:annotation>");
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
            this.ipw.println("<xsd:element name=\"geometry\" type=\"gml:CurvePropertyType\"/>");
            SurfaceOrAreaType type = (SurfaceOrAreaType)attr.getDomainResolvingAliases();
            Table lineattrs = type.getLineAttributeStructure();
            if (lineattrs != null) {
                this.ipw.println("<xsd:element name=\"lineattr\">");
                this.ipw.indent();
                this.ipw.println("<xsd:complexType>");
                this.ipw.indent();
                this.ipw.println("<xsd:sequence>");
                this.ipw.indent();
                this.ipw.println("<xsd:element ref=\"" + this.getScopedName(lineattrs) + "\"/>");
                this.ipw.unindent();
                this.ipw.println("</xsd:sequence>");
                this.ipw.println("<xsd:attributeGroup ref=\"gml:OwnershipAttributeGroup\"/>");
                this.ipw.unindent();
                this.ipw.println("</xsd:complexType>");
                this.ipw.unindent();
                this.ipw.println("</xsd:element>");
            }
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:extension>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexContent>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        }
    }

    private void declareAttribute(AttributeDef attribute) {
        Type type;
        String minOccurs = "";
        if (!attribute.getDomain().isMandatoryConsideringAliases()) {
            minOccurs = " minOccurs=\"0\"";
        }
        if ((type = attribute.getDomain()) instanceof TypeAlias) {
            Domain realDomain = ((TypeAlias)type).getAliasing();
            String base = null;
            String facets = null;
            if (realDomain == this.td.INTERLIS.URI) {
                base = "xsd:anyURI";
                facets = "<xsd:maxLength value=\"1023\"/>";
            } else if (realDomain == this.td.INTERLIS.NAME) {
                base = "xsd:token";
                facets = "<xsd:maxLength value=\"255\"/><xsd:pattern value=\"[a-zA-Z][a-zA-Z0-9_]*\"/>";
            } else if (realDomain == this.td.INTERLIS.INTERLIS_1_DATE) {
                base = "xsd:token";
                facets = "<xsd:maxLength value=\"8\"/><xsd:pattern value=\"[0-9]*\"/>";
            } else if (realDomain == this.td.INTERLIS.BOOLEAN) {
                base = "xsd:boolean";
            } else if (realDomain == this.td.INTERLIS.HALIGNMENT) {
                base = "INTERLIS:HALIGNMENT";
            } else if (realDomain == this.td.INTERLIS.VALIGNMENT) {
                base = "INTERLIS:VALIGNMENT";
            } else if (realDomain == this.td.INTERLIS.ANYOID) {
                base = "xsd:token";
            } else if (realDomain == this.td.INTERLIS.I32OID) {
                base = "INTERLIS:I32OID";
            } else if (realDomain == this.td.INTERLIS.STANDARDOID) {
                base = "INTERLIS:STANDARDOID";
            } else if (realDomain == this.td.INTERLIS.UUIDOID) {
                base = "INTERLIS:UUIDOID";
            } else if (realDomain == this.td.INTERLIS.GregorianYear) {
                base = "xsd:gYear";
            } else if (realDomain == this.td.INTERLIS.XmlTime) {
                base = "xsd:time";
            } else if (realDomain == this.td.INTERLIS.XmlDate) {
                base = "xsd:date";
            } else if (realDomain == this.td.INTERLIS.XmlDateTime) {
                base = "xsd:dateTime";
            } else {
                base = this.getScopedName(realDomain);
                if (realDomain.getType() instanceof SurfaceOrAreaType) {
                    this.surfaceOrAreaAttrs.add(attribute);
                }
            }
            if (facets == null) {
                this.ipw.println("<xsd:element name=\"" + Gml32Generator.getTransferName(attribute) + "\" type=\"" + base + "\"" + minOccurs + "/>");
            } else {
                this.ipw.println("<xsd:element name=\"" + Gml32Generator.getTransferName(attribute) + "\"" + minOccurs + ">");
                this.ipw.indent();
                this.ipw.println("<xsd:simpleType>");
                this.ipw.indent();
                this.ipw.println("<xsd:restriction base=\"" + base + "\">");
                this.ipw.indent();
                this.ipw.println(facets);
                this.ipw.unindent();
                this.ipw.println("</xsd:restriction>");
                this.ipw.unindent();
                this.ipw.println("</xsd:simpleType>");
                this.ipw.unindent();
                this.ipw.println("</xsd:element>");
            }
        } else if (type instanceof CoordType) {
            this.ipw.println("<xsd:element name=\"" + Gml32Generator.getTransferName(attribute) + "\"" + minOccurs + " type=\"gml:PointPropertyType\"" + ">");
            this.ipw.indent();
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
        } else if (type instanceof PolylineType) {
            this.ipw.println("<xsd:element name=\"" + Gml32Generator.getTransferName(attribute) + "\"" + minOccurs + " type=\"gml:CurvePropertyType\"" + ">");
            this.ipw.indent();
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
        } else if (type instanceof SurfaceOrAreaType) {
            this.ipw.println("<xsd:element name=\"" + Gml32Generator.getTransferName(attribute) + "\"" + minOccurs + " type=\"gml:SurfacePropertyType\"" + ">");
            this.ipw.indent();
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
            this.surfaceOrAreaAttrs.add(attribute);
        } else if (type instanceof CompositionType) {
            CompositionType composition = (CompositionType)type;
            Table part = composition.getComponentType();
            Cardinality card = composition.getCardinality();
            minOccurs = "";
            if (card.getMinimum() > 1L) {
                minOccurs = " minOccurs=\"" + Long.toString(card.getMinimum()) + "\"";
            }
            String maxOccurs = "";
            if (card.getMaximum() != 1L) {
                maxOccurs = card.getMaximum() == Long.MAX_VALUE ? " maxOccurs=\"unbounded\"" : " maxOccurs=\"" + Long.toString(card.getMaximum()) + "\"";
            }
            this.ipw.println("<xsd:element name=\"" + Gml32Generator.getTransferName(attribute) + "\"" + minOccurs + maxOccurs + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:complexType>");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element ref=\"" + this.getScopedName(part) + "\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
        } else if (type instanceof ReferenceType) {
            this.ipw.println("<xsd:element name=\"" + Gml32Generator.getTransferName(attribute) + "\" type=\"gml:ReferenceType\"" + minOccurs + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:annotation>");
            this.ipw.indent();
            this.ipw.println("<xsd:appinfo>");
            this.ipw.indent();
            this.ipw.println("<gml:targetElement>" + this.getScopedName(((ReferenceType)type).getReferred()) + "</gml:targetElement>");
            this.ipw.unindent();
            this.ipw.println("</xsd:appinfo>");
            this.ipw.unindent();
            this.ipw.println("</xsd:annotation>");
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
        } else if (type instanceof EnumerationType && !attribute.isFinal()) {
            this.ipw.println("<xsd:element name=\"" + Gml32Generator.getTransferName(attribute) + "\" type=\"gml:CodeWithAuthorityType\"" + minOccurs + "/>");
            this.codelists.add(attribute);
        } else {
            this.ipw.println("<xsd:element name=\"" + Gml32Generator.getTransferName(attribute) + "\"" + minOccurs + ">");
            this.ipw.indent();
            this.declareType(type, null);
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
        }
    }

    private void declareCodelists() {
        if (this.codelists.size() > 0) {
            this.ipw.println("<xsd:annotation>");
            this.ipw.indent();
            this.ipw.println("<xsd:appinfo source=\"http://www.interlis.ch/ili2c\">");
            this.ipw.indent();
            String modelName = this.currentModel.getName();
            int oid = 1;
            for (Element codelisto : this.codelists) {
                String enumName = null;
                EnumerationType type = null;
                if (codelisto instanceof Domain) {
                    Domain domain = (Domain)codelisto;
                    enumName = this.getName(domain);
                    type = (EnumerationType)domain.getType();
                } else {
                    AttributeDef attr = (AttributeDef)codelisto;
                    enumName = this.getName(attr.getContainer()) + "." + Gml32Generator.getTransferName(attr);
                    type = (EnumerationType)attr.getDomain();
                }
                this.ipw.println("<gml:Dictionary gml:id=\"o" + oid++ + "\">");
                this.ipw.indent();
                this.ipw.println("<gml:identifier codeSpace=\"http://www.interlis.ch/INTERLIS2.3/GML32/" + modelName + "\">" + enumName + "</gml:identifier>");
                String codeSpace = "http://www.interlis.ch/INTERLIS2.3/GML32/" + modelName + "/" + enumName;
                ArrayList ev = new ArrayList();
                this.buildEnumList(ev, "", type.getConsolidatedEnumeration());
                for (String enumVal : ev) {
                    this.ipw.println("<gml:dictionaryEntry>");
                    this.ipw.indent();
                    this.ipw.println("<gml:Definition gml:id=\"o" + oid++ + "\">");
                    this.ipw.indent();
                    this.ipw.println("<gml:identifier codeSpace=\"" + codeSpace + "\">" + enumVal + "</gml:identifier>");
                    this.ipw.unindent();
                    this.ipw.println("</gml:Definition>");
                    this.ipw.unindent();
                    this.ipw.println("</gml:dictionaryEntry>");
                }
                this.ipw.unindent();
                this.ipw.println("</gml:Dictionary>");
            }
            this.ipw.unindent();
            this.ipw.println("</xsd:appinfo>");
            this.ipw.unindent();
            this.ipw.println("</xsd:annotation>");
        }
    }

    private void declareType(Type type, Domain domain) {
        String typeName = "";
        if (domain != null) {
            typeName = " name=\"" + this.getName(domain) + "\"";
        }
        if (type instanceof PolylineType) {
            this.ipw.println("<xsd:complexType" + typeName + ">");
            this.ipw.indent();
            this.declarePolylineValue(domain, (PolylineType)type);
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        } else if (type instanceof SurfaceOrAreaType) {
            this.ipw.println("<xsd:complexType" + typeName + ">");
            this.ipw.indent();
            this.declarePolylineValue(domain, (SurfaceOrAreaType)type);
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        } else if (type instanceof CoordType) {
            this.ipw.println("<xsd:complexType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:complexContent>");
            this.ipw.indent();
            String base = domain != null && domain.getExtending() != null ? this.getScopedName(domain.getExtending()) : "gml:PointPropertyType";
            this.ipw.println("<xsd:restriction base=\"" + base + "\">");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element ref=\"gml:Point\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:restriction>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexContent>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        } else if (type instanceof EnumerationType) {
            if (domain != null && !domain.isFinal()) {
                this.ipw.println("<xsd:complexType" + typeName + ">");
                this.ipw.indent();
                this.ipw.println("<xsd:simpleContent>");
                this.ipw.indent();
                String base = domain != null && domain.getExtending() != null ? this.getScopedName(domain.getExtending()) : "gml:CodeWithAuthorityType";
                this.ipw.println("<xsd:restriction base=\"" + base + "\">");
                this.ipw.indent();
                this.ipw.println("<xsd:attribute name=\"codeSpace\" type=\"xsd:anyURI\" use=\"required\"/>");
                this.ipw.unindent();
                this.ipw.println("</xsd:restriction>");
                this.ipw.unindent();
                this.ipw.println("</xsd:simpleContent>");
                this.ipw.unindent();
                this.ipw.println("</xsd:complexType>");
                this.codelists.add(domain);
            } else {
                this.ipw.println("<xsd:simpleType" + typeName + ">");
                this.ipw.indent();
                this.ipw.println("<xsd:restriction base=\"xsd:normalizedString\">");
                this.ipw.indent();
                ArrayList ev = new ArrayList();
                this.buildEnumList(ev, "", ((EnumerationType)type).getConsolidatedEnumeration());
                for (String value : ev) {
                    this.ipw.println("<xsd:enumeration value=\"" + value + "\"/>");
                }
                this.ipw.unindent();
                this.ipw.println("</xsd:restriction>");
                this.ipw.unindent();
                this.ipw.println("</xsd:simpleType>");
            }
        } else if (type instanceof NumericType) {
            this.ipw.println("<xsd:simpleType" + typeName + ">");
            this.ipw.indent();
            if (type.isAbstract()) {
                this.ipw.println("<xsd:restriction base=\"xsd:double\">");
                this.ipw.println("</xsd:restriction>");
            } else {
                PrecisionDecimal min = ((NumericType)type).getMinimum();
                if (min.getAccuracy() > 0) {
                    if (min.getExponent() != 0) {
                        this.ipw.println("<xsd:restriction base=\"xsd:double\">");
                    } else {
                        this.ipw.println("<xsd:restriction base=\"xsd:decimal\">");
                    }
                    this.ipw.indent();
                    this.ipw.println("<xsd:minInclusive value=\"" + ((NumericType)type).getMinimum().doubleValue() + "\"/>");
                    this.ipw.println("<xsd:maxInclusive value=\"" + ((NumericType)type).getMaximum().doubleValue() + "\"/>");
                    this.ipw.unindent();
                    this.ipw.println("</xsd:restriction>");
                } else {
                    this.ipw.println("<xsd:restriction base=\"xsd:integer\">");
                    this.ipw.indent();
                    this.ipw.println("<xsd:minInclusive value=\"" + (int)((NumericType)type).getMinimum().doubleValue() + "\"/>");
                    this.ipw.println("<xsd:maxInclusive value=\"" + (int)((NumericType)type).getMaximum().doubleValue() + "\"/>");
                    this.ipw.unindent();
                    this.ipw.println("</xsd:restriction>");
                }
            }
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        } else if (type instanceof TextType) {
            this.ipw.println("<xsd:simpleType" + typeName + ">");
            this.ipw.indent();
            if (((TextType)type).isNormalized()) {
                this.ipw.println("<xsd:restriction base=\"xsd:normalizedString\">");
            } else {
                this.ipw.println("<xsd:restriction base=\"xsd:string\">");
            }
            if (((TextType)type).getMaxLength() > 0) {
                this.ipw.indent();
                this.ipw.println("<xsd:maxLength value=\"" + ((TextType)type).getMaxLength() + "\"/>");
                this.ipw.unindent();
            }
            this.ipw.println("</xsd:restriction>");
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        } else if (type instanceof FormattedType) {
            String base;
            this.ipw.println("<xsd:simpleType" + typeName + ">");
            this.ipw.indent();
            Domain baseDomain = ((FormattedType)type).getDefinedBaseDomain();
            if (baseDomain == this.td.INTERLIS.XmlDate) {
                base = "xsd:date";
            } else if (baseDomain == this.td.INTERLIS.XmlDateTime) {
                base = "xsd:dateTime";
            } else if (baseDomain == this.td.INTERLIS.XmlTime) {
                base = "xsd:time";
            } else {
                baseDomain = null;
                base = "xsd:normalizedString";
            }
            this.ipw.println("<xsd:restriction base=\"" + base + "\">");
            if (baseDomain == null) {
                this.ipw.println("<xsd:pattern value=\"" + ((FormattedType)type).getRegExp() + "\"/>");
            }
            this.ipw.println("</xsd:restriction>");
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        } else if (type instanceof BlackboxType) {
            if (((BlackboxType)type).getKind() == 1) {
                this.ipw.println("<xsd:complexType " + typeName + ">");
                this.ipw.indent();
                this.ipw.println("<xsd:sequence>");
                this.ipw.indent();
                this.ipw.println("<xsd:any namespace=\"##any\" minOccurs=\"0\" maxOccurs=\"unbounded\" processContents=\"lax\"/>");
                this.ipw.unindent();
                this.ipw.println("</xsd:sequence>");
                this.ipw.unindent();
                this.ipw.println("</xsd:complexType>");
            } else {
                this.ipw.println("<xsd:simpleType " + typeName + ">");
                this.ipw.indent();
                this.ipw.println("<xsd:restriction base=\"xsd:base64Binary\">");
                this.ipw.println("</xsd:restriction>");
                this.ipw.unindent();
                this.ipw.println("</xsd:simpleType>");
            }
        } else if (type instanceof ClassType) {
            this.ipw.println("<xsd:simpleType" + typeName + ">");
            this.ipw.indent();
            String base = "xsd:normalizedString";
            this.ipw.println("<xsd:restriction base=\"" + base + "\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        } else if (type instanceof AttributePathType) {
            this.ipw.println("<xsd:simpleType" + typeName + ">");
            this.ipw.indent();
            String base = "xsd:normalizedString";
            this.ipw.println("<xsd:restriction base=\"" + base + "\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        } else if (type instanceof NumericOIDType) {
            this.ipw.println("<xsd:simpleType" + typeName + ">");
            this.ipw.indent();
            String base = "xsd:int";
            this.ipw.println("<xsd:restriction base=\"" + base + "\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        } else if (type instanceof TextOIDType) {
            this.ipw.println("<xsd:simpleType" + typeName + ">");
            this.ipw.indent();
            String base = "xsd:token";
            this.ipw.println("<xsd:restriction base=\"" + base + "\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        } else if (type instanceof StructuredUnitType) {
            this.ipw.println("<xsd:simpleType" + typeName + ">");
            this.ipw.indent();
            String base = "xsd:token";
            this.ipw.println("<xsd:restriction base=\"" + base + "\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        } else {
            throw new IllegalArgumentException("type " + type.getClass() + " not yet supported");
        }
    }

    private void declarePolylineValue(Domain domain, LineType type) {
        this.ipw.println("<xsd:complexContent>");
        this.ipw.indent();
        String base = domain != null && domain.getExtending() != null ? this.getScopedName(domain.getExtending()) : (type instanceof SurfaceOrAreaType ? "gml:SurfacePropertyType" : "gml:CurvePropertyType");
        this.ipw.println("<xsd:restriction base=\"" + base + "\">");
        this.ipw.indent();
        this.ipw.println("<xsd:sequence>");
        this.ipw.indent();
        if (type instanceof SurfaceOrAreaType) {
            this.ipw.println("<xsd:element ref=\"gml:Polygon\"/>");
        } else {
            this.ipw.println("<xsd:element ref=\"gml:AbstractCurve\"/>");
        }
        this.ipw.unindent();
        this.ipw.println("</xsd:sequence>");
        this.ipw.unindent();
        this.ipw.println("</xsd:restriction>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexContent>");
    }

    private void declareLineForm(LineForm form) {
        EhiLogger.logAdaption("User defined line form " + form.getScopedName((Container)null) + " not yet supported");
    }

    private void buildEnumList(List accu, String prefix1, Enumeration enumer) {
        Iterator<Enumeration.Element> iter = enumer.getElements();
        String prefix = "";
        if (prefix1.length() > 0) {
            prefix = prefix1 + ".";
        }
        while (iter.hasNext()) {
            Enumeration.Element ee = iter.next();
            Enumeration subEnum = ee.getSubEnumeration();
            if (subEnum != null) {
                this.buildEnumList(accu, prefix + ee.getName(), subEnum);
                continue;
            }
            accu.add(prefix + ee.getName());
        }
    }
}

